/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibus.standard;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.entity.parameters.EntityStorageLoadParameters;
import com.gridnine.xtrip.common.model.system.IBusStandardContextKeys;
import com.gridnine.xtrip.server.ibus.IbusConfigurationHelper;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.Map;
import java.util.Objects;

public class EntityContainerReloadProcessor
extends BaseProcessor {
    private String contextKey;
    private boolean noCache;

    @Override
    public void configure(Map<String, String> params) {
        this.contextKey = IbusConfigurationHelper.getMandatoryParameter(params, "context-key");
        this.noCache = Boolean.parseBoolean(IbusConfigurationHelper.getOptionalParameter(params, "no-cache", Boolean.TRUE.toString()));
    }

    @Override
    public void process(MessageContext ctx) throws Exception {
        EntityReference ref;
        EntityContainer cachedContainer;
        EntityContainer container = (EntityContainer)ctx.getMandatoryObject(this.contextKey);
        Map containersCache = (Map)ctx.getObject((Enum<?>)IBusStandardContextKeys.CONTAINERS_CACHE);
        if (containersCache != null && (cachedContainer = (EntityContainer)containersCache.get(ref = container.toReference())) == container) {
            ctx.putObject(this.contextKey, (Object)cachedContainer);
            return;
        }
        EntityStorageLoadParameters loadParameters = (EntityStorageLoadParameters)new EntityStorageLoadParameters().noCache(this.noCache);
        EntityContainer reloadContainer = EntityStorage.get().load(container.getEntityType(), container.getUid(), loadParameters);
        if (Objects.nonNull(reloadContainer)) {
            ctx.putObject(this.contextKey, (Object)reloadContainer);
        }
    }
}

