/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibus.standard;

import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.VersionInfo;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.entity.parameters.EntityStorageSaveParameters;
import com.gridnine.xtrip.common.model.system.IBusStandardContextKeys;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ibus.IbusConfigurationHelper;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang.BooleanUtils;

public class EntityContainerSaveProcessor
extends BaseProcessor {
    private String contextKey;
    private boolean autoWrap;
    private String dataSource;

    @Override
    public void configure(Map<String, String> parameters) {
        this.contextKey = IbusConfigurationHelper.getMandatoryParameter(parameters, "context-key");
        this.autoWrap = BooleanUtils.toBoolean((String)IbusConfigurationHelper.getOptionalParameter(parameters, "auto-wrap"));
        this.dataSource = IbusConfigurationHelper.getOptionalParameter(parameters, "data-source");
    }

    @Override
    public void process(MessageContext ctx) throws Exception {
        Object obj = ctx.getMandatoryObject(this.contextKey);
        EntityContainer ctr = this.autoWrap && obj instanceof BaseEntity && !(obj instanceof EntityContainer) ? EntityContainer.create((BaseEntity)((BaseEntity)obj)) : (EntityContainer)obj;
        String dataSourceContext = (String)ctx.getObject((Enum<?>)IBusStandardContextKeys.VERSION_INFO_DATA_SOURCE);
        String dataSource = Stream.of("ibus", this.dataSource, dataSourceContext).filter(TextUtil::nonBlank).collect(Collectors.joining(" ", "[", "]"));
        String versionNotesContext = (String)ctx.getObject((Enum<?>)IBusStandardContextKeys.VERSION_INFO_VERSION_NOTES);
        String versionNotes = String.format("routeId=[%s] cls=[%s] info=[%s]", ctx.getRouteId(), this.getClass().getName(), versionNotesContext);
        VersionInfo versionInfo = ctr.getVersionInfo();
        versionInfo.setDataSource(dataSource);
        versionInfo.setVersionNotes(versionNotes);
        EntityStorage.get().save(ctr, true, (EntityStorageSaveParameters)new EntityStorageSaveParameters().context(IBusStandardContextKeys.MESSAGE_CONTEXT.name(), (Object)ctx));
    }
}

