/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibus.standard;

import com.gridnine.xtrip.common.model.MulticallException;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.standard.helpers.MessagesHelper;
import com.gridnine.xtrip.common.model.system.IBusStandardContextKeys;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.util.CaseInsensitive;
import com.gridnine.xtrip.common.util.EnumUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ibus.IbusConfigurationHelper;
import com.gridnine.xtrip.server.ibus.components.AdviceOnExceptionCallback;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.Map;

public class Exception2MessageProcessor
extends BaseProcessor {
    private MessageType messageType = MessageType.ERROR;

    @Override
    public void configure(Map<String, String> parameters) {
        String mesTypeStr = IbusConfigurationHelper.getOptionalParameter(parameters, "message-type");
        if (TextUtil.nonBlank((String)mesTypeStr)) {
            this.messageType = (MessageType)EnumUtil.fromNameSafe(MessageType.class, (String)mesTypeStr, (CaseInsensitive)CaseInsensitive.YES, null);
        }
    }

    @Override
    public void process(MessageContext ctx) throws Exception {
        AdviceOnExceptionCallback callback = (AdviceOnExceptionCallback)ctx.getMandatoryObject((Enum<?>)IBusStandardContextKeys.ADVICE_ON_EXCEPTION_CALLBACK);
        Throwable exception = callback.getException();
        if (exception instanceof MulticallException) {
            MulticallException me = (MulticallException)exception;
            me.getSubrouteExceptions().values().forEach(ex -> this.addMessage(ctx, (Throwable)ex));
            return;
        }
        this.addMessage(ctx, exception);
    }

    private void addMessage(MessageContext ctx, Throwable exception) {
        String errorText;
        boolean isError = this.messageType == MessageType.ERROR;
        String string = errorText = isError ? "\u043f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430" : this.messageType.toString();
        if (exception instanceof Xeption) {
            Xeption xe = (Xeption)exception;
            if (xe.getEndUserMessage() != null) {
                errorText = xe.getEndUserMessage().toString();
            } else if (xe.getAdminMessage() != null) {
                errorText = xe.getAdminMessage().toString();
            }
        }
        ctx.addMessage(MessagesHelper.createMessage((MessageType)this.messageType, (String)errorText, (Throwable)(isError ? exception : null), (Object[])new Object[0]));
    }
}

