/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibus.standard;

import com.gridnine.xtrip.common.model.MulticallException;
import com.gridnine.xtrip.common.model.system.IBusStandardContextKeys;
import com.gridnine.xtrip.server.ibus.IbusConfigurationHelper;
import com.gridnine.xtrip.server.ibus.components.AdviceOnExceptionCallback;
import com.gridnine.xtrip.server.ibus.components.BaseRoutingKeyProvider;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.Iterator;
import java.util.Map;

public class ExceptionOfClassNameProvider
extends BaseRoutingKeyProvider {
    private String exClassName;

    @Override
    public void configure(Map<String, String> parameters) {
        super.configure(parameters);
        this.exClassName = IbusConfigurationHelper.getMandatoryParameter(parameters, "class-name");
    }

    @Override
    public String getRoutingKey(MessageContext ctx) throws Exception {
        AdviceOnExceptionCallback callback = (AdviceOnExceptionCallback)ctx.getMandatoryObject((Enum<?>)IBusStandardContextKeys.ADVICE_ON_EXCEPTION_CALLBACK);
        return String.valueOf(this.foundException(callback));
    }

    boolean foundException(AdviceOnExceptionCallback callback) {
        if (callback.getException() instanceof MulticallException) {
            MulticallException me = (MulticallException)callback.getException();
            Iterator iterator = me.getSubrouteExceptions().values().iterator();
            while (iterator.hasNext()) {
                if (!this.exClassName.equals(((Throwable)iterator.next()).getClass().getName())) continue;
                return true;
            }
            return false;
        }
        return this.exClassName.equals(callback.getException().getClass().getName());
    }
}

