/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibus.standard;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.system.IBusStandardContextKeys;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.Map;

public class LoadEntityContainerPreviousVersionProcessor
extends BaseProcessor {
    private String newContainerKey;
    private String oldContainerKey;

    @Override
    public void configure(Map<String, String> parameters) {
        this.newContainerKey = this.getKey(parameters, "new-container-key", IBusStandardContextKeys.NEW_ENTITY_CONTAINER_VERSION);
        this.oldContainerKey = this.getKey(parameters, "old-container-key", IBusStandardContextKeys.OLD_ENTITY_CONTAINER_VERSION);
    }

    private String getKey(Map<String, String> parameters, String key, IBusStandardContextKeys def) {
        String value = parameters.get(key);
        return TextUtil.isBlank((String)value) ? def.name() : value;
    }

    @Override
    public void process(MessageContext ctx) throws Exception {
        EntityContainer ctr = (EntityContainer)ctx.getMandatoryObject(this.newContainerKey);
        int versionsCount = ctr.getVersionsCount();
        ctx.putObject(this.oldContainerKey, versionsCount > 1 ? EntityStorage.get().load(ctr.getEntityType(), ctr.getUid(), Integer.valueOf(versionsCount - 2)) : null);
    }
}

