/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibus.standard;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.system.IBusStandardContextKeys;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.Map;

public class LoadEntityContainerProcessor
extends BaseProcessor {
    private String containerKey;
    private String referenceKey;
    private String entityKey;

    @Override
    public void configure(Map<String, String> parameters) {
        this.containerKey = this.getKey(parameters, "container-key", IBusStandardContextKeys.NEW_ENTITY_CONTAINER_VERSION);
        this.referenceKey = this.getKey(parameters, "reference-key", IBusStandardContextKeys.ENTITY_REFERENCE);
        this.entityKey = parameters.get("entity-key");
    }

    private String getKey(Map<String, String> parameters, String key, IBusStandardContextKeys def) {
        String value = parameters.get(key);
        return TextUtil.isBlank((String)value) ? def.name() : value;
    }

    @Override
    public void process(MessageContext ctx) throws Exception {
        EntityReference ref = (EntityReference)ctx.getMandatoryObject(this.referenceKey);
        EntityContainer container = EntityStorage.get().resolve(ref);
        ctx.putObject(this.containerKey, (Object)container);
        if (container != null && !TextUtil.isBlank((String)this.entityKey)) {
            ctx.putObject(this.entityKey, (Object)container.getEntity());
        }
    }
}

