/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibus.standard;

import com.gridnine.xtrip.common.lockmanager.NamedLock;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.system.IBusStandardContextKeys;
import com.gridnine.xtrip.server.db.storage.common.LogicalSession;
import com.gridnine.xtrip.server.db.storage.common.SessionsHelper;
import com.gridnine.xtrip.server.db.storage.entity.LogicalEntityStorage;
import com.gridnine.xtrip.server.ibus.components.BaseAdvice;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.LinkedList;
import java.util.Map;

public class LogicalSessionBasedEntityContainerLockAdvice
extends BaseAdvice {
    private static final String NAMED_LOCK = LogicalSessionBasedEntityContainerLockAdvice.class.getName() + "_NAMED_LOCK";
    private String containerKey;

    @Override
    public void configure(Map<String, String> parameters) {
        this.containerKey = parameters.get("container-key");
    }

    @Override
    public void before(MessageContext context) throws Exception {
        EntityContainer entityContainer = (EntityContainer)context.getMandatoryObject(this.containerKey);
        Map logicalSessionsMap = (Map)context.getMandatoryObject((Enum<?>)IBusStandardContextKeys.LOGICAL_STORAGE_SESSIONS);
        if (logicalSessionsMap.isEmpty()) {
            throw new Exception("sessions map is empty!");
        }
        LinkedList logicalSessions = (LinkedList)logicalSessionsMap.get(Thread.currentThread());
        if (logicalSessions.isEmpty()) {
            throw new Exception("sessions list is empty!");
        }
        NamedLock namedLock = SessionsHelper.lock((LogicalSession)logicalSessions.get(logicalSessions.size() - 1), LogicalEntityStorage.getLockKey(entityContainer));
        context.putObject(NAMED_LOCK, (Object)namedLock);
    }

    @Override
    public void after(MessageContext context) throws Exception {
        Map logicalSessionsMap = (Map)context.getMandatoryObject((Enum<?>)IBusStandardContextKeys.LOGICAL_STORAGE_SESSIONS);
        if (logicalSessionsMap.isEmpty()) {
            throw new Exception("sessions map is empty!");
        }
        LinkedList logicalSessions = (LinkedList)logicalSessionsMap.get(Thread.currentThread());
        if (logicalSessions.isEmpty()) {
            throw new Exception("sessions list is empty!");
        }
        NamedLock namedLock = (NamedLock)context.removeObject(NAMED_LOCK);
        SessionsHelper.unlock(namedLock);
    }
}

