/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibus.standard;

import com.gridnine.xtrip.common.model.system.IBusStandardContextKeys;
import com.gridnine.xtrip.server.db.storage.LogicalStorage;
import com.gridnine.xtrip.server.db.storage.common.LogicalSession;
import com.gridnine.xtrip.server.ibus.components.BaseAdvice;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class LogicalStorageSessionAdvice
extends BaseAdvice {
    private static final String LOGICAL_STORAGE_EXCEPTION_FLAG_KEY = "LOGICAL_STORAGE_EXCEPTION_FLAG_KEY";

    @Override
    public void before(MessageContext ctx) throws Exception {
        LinkedList<LogicalSession> list;
        ConcurrentHashMap sessions = (ConcurrentHashMap)ctx.getObject((Enum<?>)IBusStandardContextKeys.LOGICAL_STORAGE_SESSIONS);
        if (sessions == null) {
            sessions = new ConcurrentHashMap();
            ctx.putObject((Enum<?>)IBusStandardContextKeys.LOGICAL_STORAGE_SESSIONS, (Object)sessions);
        }
        if ((list = (LinkedList<LogicalSession>)sessions.get(Thread.currentThread())) == null) {
            list = new LinkedList<LogicalSession>();
            sessions.put(Thread.currentThread(), list);
        }
        LogicalSession ls = LogicalStorage.get().beginUnitOfWork();
        list.add(ls);
    }

    @Override
    public boolean handleException(Throwable e, MessageContext ctx) throws Exception {
        ctx.putObject(LOGICAL_STORAGE_EXCEPTION_FLAG_KEY, (Object)Boolean.TRUE);
        return false;
    }

    @Override
    public void after(MessageContext ctx) throws Exception {
        Map sessions = (Map)ctx.getObject((Enum<?>)IBusStandardContextKeys.LOGICAL_STORAGE_SESSIONS);
        if (Boolean.TRUE.equals(ctx.removeObject(LOGICAL_STORAGE_EXCEPTION_FLAG_KEY))) {
            LogicalStorage.get().cancelUnitOfWork((LogicalSession)((LinkedList)sessions.get(Thread.currentThread())).removeLast());
            return;
        }
        LogicalStorage.get().endUnitOfWork((LogicalSession)((LinkedList)sessions.get(Thread.currentThread())).removeLast(), true);
    }
}

