/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibus.standard;

import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ibus.components.BaseAdvice;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.metrics.Metrics;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;

public class MetricsAdvice
extends BaseAdvice {
    private String TIME_CONTEXT_KEY;
    private final List<String> PATH_CONTEXT_KEYS = new ArrayList<String>();

    @Override
    public void configure(Map<String, String> parameters) {
        String path;
        this.TIME_CONTEXT_KEY = parameters.get("time-context-key");
        int count = 1;
        while (!TextUtil.isBlank((String)(path = parameters.get(String.format("path-context-key-%s", String.valueOf(count)))))) {
            this.PATH_CONTEXT_KEYS.add(path);
            ++count;
        }
    }

    @Override
    public void before(MessageContext context) throws Exception {
        if (TextUtil.isBlank((String)this.TIME_CONTEXT_KEY) || this.PATH_CONTEXT_KEYS.size() == 0) {
            return;
        }
        context.putObject(this.TIME_CONTEXT_KEY, (Object)System.currentTimeMillis());
    }

    @Override
    public void after(MessageContext context) throws Exception {
        if (TextUtil.isBlank((String)this.TIME_CONTEXT_KEY) || this.PATH_CONTEXT_KEYS.size() == 0) {
            return;
        }
        Long time = (Long)context.removeObject(this.TIME_CONTEXT_KEY);
        if (time != null) {
            String key = Metrics.key(this.PATH_CONTEXT_KEYS.toArray(new String[this.PATH_CONTEXT_KEYS.size()]));
            Metrics.get().timingAndEvent(key, time);
            if (this.log.isDebugEnabled()) {
                Duration duration = Duration.between(LocalDateTime.ofInstant(Instant.ofEpochMilli(time), TimeZone.getDefault().toZoneId()), LocalDateTime.now());
                this.log.debug(key + " -> " + LocalTime.MIDNIGHT.plus(duration).format(DateTimeFormatter.ofPattern("HH:mm:ss.SSS")) + " -> " + duration.toMillis());
            }
        }
    }
}

