/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibus.standard;

import com.gridnine.xtrip.common.model.profiling.Profiler;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.util.UUIDGenerator;
import com.gridnine.xtrip.server.ibus.components.BaseAdvice;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.metrics.Metrics;
import java.util.Map;

public class ProfilingAdvice
extends BaseAdvice {
    private String profilingKey;
    private String startTimeKey;

    @Override
    public void configure(Map<String, String> params) throws Exception {
        this.profilingKey = params.get("profiling-key");
        this.startTimeKey = String.format("start-time-%s", UUIDGenerator.generate((boolean)false).toString());
    }

    @Override
    public void before(MessageContext ctx) throws Exception {
        if (TextUtil.isBlank((String)this.profilingKey)) {
            return;
        }
        ctx.putObject(this.startTimeKey, (Object)System.currentTimeMillis());
    }

    @Override
    public void after(MessageContext ctx) throws Exception {
        if (TextUtil.isBlank((String)this.profilingKey)) {
            return;
        }
        Long startTime = (Long)ctx.getMandatoryObject(this.startTimeKey);
        Profiler.get().updateTiming(this.profilingKey, startTime.longValue(), null);
        Metrics.get().timingAndEvent("profiling." + this.profilingKey, startTime);
    }
}

