/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibus.standard;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityIndex;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.NestedEntityReference;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.entity.EntityStorageContext;
import com.gridnine.xtrip.common.model.entity.EntityStorageHelper;
import com.gridnine.xtrip.common.model.entity.parameters.EntityStorageLoadParameters;
import com.gridnine.xtrip.common.model.system.IBusStandardContextKeys;
import com.gridnine.xtrip.server.ibus.IbusConfigurationHelper;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang.BooleanUtils;

public class ResolveProcessor
extends BaseProcessor {
    private String key;
    private String result;
    private boolean noCache;
    private Boolean tolerant;

    @Override
    public void configure(Map<String, String> parameters) {
        this.key = IbusConfigurationHelper.getMandatoryParameter(parameters, "key");
        this.result = IbusConfigurationHelper.getMandatoryParameter(parameters, "result");
        this.noCache = Boolean.parseBoolean(IbusConfigurationHelper.getOptionalParameter(parameters, "no-cache", Boolean.FALSE.toString()));
        this.tolerant = BooleanUtils.toBooleanObject((String)IbusConfigurationHelper.getOptionalParameter(parameters, "tolerant", null));
    }

    @Override
    public void process(MessageContext ctx) throws Exception {
        Object object = ctx.getMandatoryObject(this.key);
        EntityContainer result = null;
        EntityStorageLoadParameters loadParameters = (EntityStorageLoadParameters)new EntityStorageLoadParameters().noCache(this.noCache);
        if (Objects.nonNull(this.tolerant)) {
            loadParameters.context("irrelevance-tolerant-query", (Object)this.tolerant);
        }
        if (object instanceof EntityIndex) {
            EntityIndex index = (EntityIndex)object;
            result = EntityStorage.get().resolve(index.getSource(), loadParameters);
        } else if (object instanceof EntityReference) {
            EntityReference reference = (EntityReference)object;
            result = EntityStorage.get().resolve(reference, loadParameters);
        } else if (object instanceof NestedEntityReference) {
            NestedEntityReference ref = (NestedEntityReference)object;
            result = EntityStorageHelper.resolve((NestedEntityReference)ref, (EntityStorageContext)(ctx.hasObject((Enum<?>)IBusStandardContextKeys.ENTITY_STORAGE_CONTEXT) ? (EntityStorageContext)ctx.getObject((Enum<?>)IBusStandardContextKeys.ENTITY_STORAGE_CONTEXT) : EntityStorageHelper.createContext()));
        } else {
            throw Xeption.forDeveloper((String)String.format("unsupported object=[%s]", object.getClass().getName()), (Object[])new Object[0]);
        }
        ctx.putObject(this.result, (Object)result);
    }
}

