/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibus.standard;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.entity.EntityStorageContext;
import com.gridnine.xtrip.common.model.entity.EntityStorageHelper;
import com.gridnine.xtrip.common.model.standard.helpers.MessagesHelper;
import com.gridnine.xtrip.common.model.system.IBusStandardContextKeys;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.db.storage.LogicalStorage;
import com.gridnine.xtrip.server.db.storage.common.LogicalSession;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class SaveChangedEntitiesProcessor
extends BaseProcessor {
    private String dataSource;
    private String versionNotes;
    private String last;
    private static final DateTimeFormatter DTF = DateTimeFormatter.ofPattern("dd.MM.yyyy HH:mm:ss.SSS");

    @Override
    public void configure(Map<String, String> parameters) {
        this.dataSource = parameters.get("data-source");
        this.versionNotes = parameters.get("version-notes");
        this.last = parameters.get("last");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process(MessageContext ctx) throws Exception {
        EntityStorageContext context = (EntityStorageContext)ctx.getMandatoryObject((Enum<?>)IBusStandardContextKeys.ENTITY_STORAGE_CONTEXT);
        ArrayList lst = EntityStorageHelper.getChangedContainers((EntityStorageContext)context);
        List lst2 = EntityStorageHelper.getDeletedContainers((EntityStorageContext)context);
        if (lst.isEmpty() && lst2.isEmpty()) {
            ctx.addMessage(MessagesHelper.createMessage((MessageType)MessageType.MESSAGE, (String)("[" + LocalDateTime.now().format(DTF) + "] nothing to save, skip it"), (Object[])new Object[0]));
            return;
        }
        boolean success = false;
        LogicalSession ls = LogicalStorage.get().beginUnitOfWork();
        try {
            Map<String, Object> sessionContext = LogicalStorage.get().getSessionContext();
            sessionContext.put(IBusStandardContextKeys.ENTITY_STORAGE_CONTEXT.name(), context);
            sessionContext.put(IBusStandardContextKeys.MESSAGE_CONTEXT.name(), ctx);
            try {
                if (!TextUtil.isBlank((String)this.last)) {
                    String[] types = this.last.trim().split("\\s,\\s");
                    lst = new ArrayList(lst);
                    ArrayList<EntityContainer> lastList = new ArrayList<EntityContainer>();
                    for (String type : types) {
                        for (EntityContainer item : lst) {
                            String itemType = item.getEntityType().getName();
                            if (!itemType.equals(type)) continue;
                            lastList.add(item);
                        }
                    }
                    lst.removeAll(lastList);
                    lst.addAll(lastList);
                }
                for (EntityContainer ctr : lst) {
                    if (null != this.dataSource) {
                        ctr.getVersionInfo().setDataSource(this.dataSource);
                    } else {
                        ctr.getVersionInfo().setDataSource(ctx.getRouteId());
                    }
                    if (null != this.versionNotes) {
                        ctr.getVersionInfo().setVersionNotes(this.versionNotes);
                    }
                    ctx.addMessage(MessagesHelper.createMessage((MessageType)MessageType.MESSAGE, (String)("[" + LocalDateTime.now().format(DTF) + "] save entity {0}"), (Object[])new Object[]{ctr.toReference().toString(), ctr.getUid(), ctr.getEntityType().getName()}));
                    EntityStorage.get().save(ctr, true);
                }
                for (EntityContainer ctr : lst2) {
                    ctx.addMessage(MessagesHelper.createMessage((MessageType)MessageType.MESSAGE, (String)("[" + LocalDateTime.now().format(DTF) + "] delete entity {0}"), (Object[])new Object[]{ctr.toReference().toString(), ctr.getUid(), ctr.getEntityType().getName()}));
                    EntityStorage.get().delete(ctr);
                }
            }
            finally {
                sessionContext.remove(IBusStandardContextKeys.ENTITY_STORAGE_CONTEXT.name());
                sessionContext.remove(IBusStandardContextKeys.MESSAGE_CONTEXT.name());
            }
            ctx.addMessage(MessagesHelper.createMessage((MessageType)MessageType.MESSAGE, (String)("[" + LocalDateTime.now().format(DTF) + "] endUnitOfWork"), (Object[])new Object[0]));
            LogicalStorage.get().endUnitOfWork(ls, true);
            success = true;
            ctx.addMessage(MessagesHelper.createMessage((MessageType)MessageType.MESSAGE, (String)("[" + LocalDateTime.now().format(DTF) + "] " + (success ? "save completed successfully" : "fail save")), (Object[])new Object[0]));
        }
        catch (Throwable throwable) {
            ctx.addMessage(MessagesHelper.createMessage((MessageType)MessageType.MESSAGE, (String)("[" + LocalDateTime.now().format(DTF) + "] " + (success ? "save completed successfully" : "fail save")), (Object[])new Object[0]));
            LogicalStorage.get().cancelUnitOfWork(ls);
            throw throwable;
        }
        LogicalStorage.get().cancelUnitOfWork(ls);
    }
}

