/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibus.standard;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.VersionInfo;
import com.gridnine.xtrip.common.model.entity.EntityActualizer;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.entity.parameters.EntityStorageSaveParameters;
import com.gridnine.xtrip.common.model.system.IBusStandardContextKeys;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ibus.IbusConfigurationHelper;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang.BooleanUtils;

public class SaveEntityContainerProcessor
extends BaseProcessor {
    private String key;
    private String dataSource;
    private String versionNotes;
    private boolean updateIndexes;
    private boolean ignoreInterceptors;
    private boolean withCheckPoint;
    private boolean actualize;
    private boolean mandatory;

    @Override
    public void configure(Map<String, String> parameters) {
        this.key = IbusConfigurationHelper.getMandatoryParameter(parameters, "key");
        this.dataSource = IbusConfigurationHelper.getOptionalParameter(parameters, "data-source", "");
        this.versionNotes = IbusConfigurationHelper.getOptionalParameter(parameters, "version-notes", "");
        this.updateIndexes = BooleanUtils.toBoolean((String)IbusConfigurationHelper.getOptionalParameter(parameters, "update-indexes", Boolean.TRUE.toString()));
        this.withCheckPoint = BooleanUtils.toBoolean((String)IbusConfigurationHelper.getOptionalParameter(parameters, "check-point"));
        this.ignoreInterceptors = BooleanUtils.toBoolean((String)IbusConfigurationHelper.getOptionalParameter(parameters, "ignore-interceptors"));
        this.actualize = BooleanUtils.toBoolean((String)IbusConfigurationHelper.getOptionalParameter(parameters, "actualize"));
        this.mandatory = Boolean.parseBoolean(IbusConfigurationHelper.getOptionalParameter(parameters, "mandatory", Boolean.TRUE.toString()));
    }

    @Override
    public void process(MessageContext ctx) throws Exception {
        EntityContainer container;
        EntityContainer entityContainer = container = this.mandatory ? (EntityContainer)ctx.getMandatoryObject(this.key) : (EntityContainer)ctx.getObject(this.key);
        if (Objects.isNull(container)) {
            return;
        }
        String dataSourceContext = (String)ctx.getObject((Enum<?>)IBusStandardContextKeys.VERSION_INFO_DATA_SOURCE);
        String versionNotesContext = (String)ctx.getObject((Enum<?>)IBusStandardContextKeys.VERSION_INFO_VERSION_NOTES);
        Map contextValues = (Map)ctx.getObject((Enum<?>)IBusStandardContextKeys.SAVE_PARAMETERS_CONTEXT_VALUES);
        String dataSource = Stream.of("ibus", this.dataSource, dataSourceContext).filter(TextUtil::nonBlank).collect(Collectors.joining(" ", "[", "]"));
        String versionNotes = String.format("routeId=[%s] cls=[%s] notes=[%s] info=[%s]", ctx.getRouteId(), this.getClass().getName(), this.versionNotes, versionNotesContext);
        VersionInfo versionInfo = container.getVersionInfo();
        versionInfo.setDataSource(dataSource);
        versionInfo.setVersionNotes(versionNotes);
        EntityStorageSaveParameters parameters = (EntityStorageSaveParameters)((EntityStorageSaveParameters)new EntityStorageSaveParameters().dontTouchTheIndexes(!this.updateIndexes).ignoreInterceptors(this.ignoreInterceptors)).context(IBusStandardContextKeys.MESSAGE_CONTEXT.name(), (Object)ctx);
        if (CollectionUtil.isNotEmptyMap((Map)contextValues)) {
            parameters.getContext().putAll(contextValues);
        }
        if (this.actualize) {
            EntityActualizer.newInstance().actualize((Object)container.getEntity());
        }
        EntityStorage.get().save(container, this.withCheckPoint, parameters);
    }
}

