/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibus.standard;

import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ibus.IbusConfigurationHelper;
import com.gridnine.xtrip.server.ibus.IbusHelper;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.Arrays;
import java.util.Map;
import org.apache.commons.lang.BooleanUtils;

public class SetContextValueProcessor
extends BaseProcessor {
    private String key;
    private boolean force;
    private Class cls;
    private String enumItem;
    private String enumCls;
    private String containerCls;
    private Boolean bool;
    private String str;
    private Integer integer;

    @Override
    public void configure(Map<String, String> parameters) {
        this.key = IbusConfigurationHelper.getMandatoryParameter(parameters, "key");
        this.force = BooleanUtils.toBoolean((String)IbusConfigurationHelper.getOptionalParameter(parameters, "force", "true"));
        this.enumItem = IbusConfigurationHelper.getOptionalParameter(parameters, "enum-item");
        this.enumCls = IbusConfigurationHelper.getOptionalParameter(parameters, "enum");
        this.containerCls = IbusConfigurationHelper.getOptionalParameter(parameters, "container");
        this.bool = BooleanUtils.toBooleanObject((String)IbusConfigurationHelper.getOptionalParameter(parameters, "boolean"));
        this.str = IbusConfigurationHelper.getOptionalParameter(parameters, "str");
        String intStr = IbusConfigurationHelper.getOptionalParameter(parameters, "int");
        if (TextUtil.nonBlank((String)intStr)) {
            this.integer = Integer.parseInt(intStr);
        }
        try {
            String buffer = IbusConfigurationHelper.getOptionalParameter(parameters, "cls");
            if (!TextUtil.isBlank((String)buffer)) {
                this.cls = Class.forName(buffer);
            } else if (!TextUtil.isBlank((String)this.enumCls)) {
                this.cls = Class.forName(this.enumCls);
            } else if (!TextUtil.isBlank((String)this.containerCls)) {
                this.cls = Class.forName(this.containerCls);
            }
        }
        catch (Throwable throwable) {
            throw Xeption.forDeveloper((String)"error config", (Throwable)throwable, (Object[])new Object[0]);
        }
    }

    @Override
    public void process(MessageContext ctx) throws Exception {
        Object res = !TextUtil.isBlank((String)this.enumItem) ? Enum.valueOf(this.cls, this.enumItem) : (!TextUtil.isBlank((String)this.enumCls) ? Arrays.asList(this.cls.getEnumConstants()) : (this.bool != null ? this.bool : (!TextUtil.isBlank((String)this.containerCls) ? EntityContainer.create((BaseEntity)((BaseEntity)this.cls.newInstance())) : (this.cls != null ? this.cls.newInstance() : (this.str != null ? this.str : (this.integer != null ? this.integer : null))))));
        if (this.force) {
            IbusHelper.getForceObject(ctx, this.key, res);
        } else {
            IbusHelper.getObjectN(ctx, this.key, () -> res);
        }
    }
}

