/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibus.standard;

import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ibus.IbusConfigurationHelper;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;

public class ThrowExceptionProcessor<T extends Exception>
extends BaseProcessor {
    private String text;
    private String format;
    private final List<String> ibusParams = new ArrayList<String>();
    private Class<T> cls;
    private XeptionType xeptionType;

    @Override
    public void configure(Map<String, String> parameters) {
        this.text = IbusConfigurationHelper.getOptionalParameter(parameters, "text");
        this.format = IbusConfigurationHelper.getOptionalParameter(parameters, "format");
        StringTokenizer ibusParamsParser = new StringTokenizer(IbusConfigurationHelper.getOptionalParameter(parameters, "params", ""), " \t\n\r\f,;");
        while (ibusParamsParser.hasMoreTokens()) {
            this.ibusParams.add(ibusParamsParser.nextToken());
        }
        String buffer = IbusConfigurationHelper.getOptionalParameter(parameters, "cls");
        if (!TextUtil.isBlank((String)buffer)) {
            try {
                this.cls = Class.forName(buffer);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
        if (!TextUtil.isBlank((String)(buffer = IbusConfigurationHelper.getOptionalParameter(parameters, "type")))) {
            this.xeptionType = XeptionType.valueOf(buffer);
        }
    }

    @Override
    public void process(MessageContext ctx) throws Exception {
        Throwable exception;
        block15: {
            String message;
            block16: {
                block14: {
                    message = "";
                    exception = null;
                    if (!TextUtil.isBlank((String)this.text)) {
                        message = this.text;
                    } else if (!TextUtil.isBlank((String)this.format)) {
                        if (!CollectionUtil.isEmpty(this.ibusParams)) {
                            ArrayList ibusValues = new ArrayList(this.ibusParams.size());
                            for (String ibusParam : this.ibusParams) {
                                ibusValues.add(ctx.getObject(ibusParam));
                            }
                            message = String.format(this.format, ibusValues.toArray(new Object[ibusValues.size()]));
                        } else {
                            message = this.format;
                        }
                    }
                    if (this.cls == null) break block14;
                    if (!TextUtil.isBlank((String)message)) {
                        Constructor<T> constrictorWithMessage = this.cls.getDeclaredConstructor(String.class);
                        if (!constrictorWithMessage.isAccessible()) {
                            constrictorWithMessage.setAccessible(true);
                        }
                        exception = (Exception)constrictorWithMessage.newInstance(message);
                    } else {
                        exception = (Exception)this.cls.newInstance();
                    }
                    break block15;
                }
                if (this.xeptionType == null) break block16;
                switch (this.xeptionType) {
                    case ADMIN: {
                        exception = Xeption.forAdmin((String)message, (Object[])new Object[0]);
                        break block15;
                    }
                    case DEVELOPER: {
                        exception = Xeption.forDeveloper((String)message, (Object[])new Object[0]);
                        break block15;
                    }
                    case END_USER: {
                        exception = Xeption.forEndUser((String)message, (Object[])new Object[0]);
                        break block15;
                    }
                    default: {
                        throw Xeption.forDeveloper((String)String.format("not supported XeptionType=[%s]", new Object[]{this.xeptionType}), (Object[])new Object[0]);
                    }
                }
            }
            exception = new Exception(message);
        }
        throw exception;
    }

    public static enum XeptionType {
        ADMIN,
        DEVELOPER,
        END_USER;

    }
}

