/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibus.standard.serverdependent;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ServerApplication;
import com.gridnine.xtrip.server.ibus.components.BaseRoutingKeyProvider;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.Map;

public class BooleanServerConfigurationPropertyProvider
extends BaseRoutingKeyProvider {
    private String property;

    @Override
    public void configure(Map<String, String> parameters) {
        this.property = parameters.get("property-key");
        if (TextUtil.isBlank((String)this.property)) {
            throw new IllegalArgumentException();
        }
    }

    @Override
    public String getRoutingKey(MessageContext ctx) throws Exception {
        return Boolean.toString(this.getValue());
    }

    private boolean getValue() {
        Object value = this.getServerConfigValue();
        if (value == null) {
            return false;
        }
        return "true".equalsIgnoreCase(value.toString());
    }

    protected Object getServerConfigValue() {
        ServerApplication serverApplication = (ServerApplication)Environment.getPublished(ServerApplication.class);
        return serverApplication.getConfiguration().get((Object)this.property);
    }
}

