/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibus.tools;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public class BaseIntegrationBusTask
extends Task {
    private File root;
    private boolean debug = true;

    public File getRoot() {
        return this.root;
    }

    public void setRoot(File root) {
        this.root = root;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(String className, Object ... args) throws BuildException {
        try {
            if (null == this.root) {
                throw new BuildException("Root set required");
            }
            Path rootPath = this.getRoot().toPath();
            Path plugins = rootPath.resolve("plugins");
            String log4jConfigKey = "log4j.configuration";
            String old4j = System.getProperty("log4j.configuration");
            try {
                System.setProperty("log4j.configuration", BaseIntegrationBusTask.class.getResource(this.debug ? "log4j-debug.properties" : "log4j.properties").toExternalForm());
                ArrayList<URL> urls = new ArrayList<URL>();
                Files.list(rootPath.resolve("lib")).map(path -> {
                    try {
                        return path.toUri().toURL();
                    }
                    catch (MalformedURLException e) {
                        throw new RuntimeException(e);
                    }
                }).forEach(urls::add);
                urls.add(plugins.resolve("com.gridnine.xtrip.server").resolve("classes/").toUri().toURL());
                try (URLClassLoader classLoader = new URLClassLoader(urls.toArray(new URL[urls.size()]));){
                    Class<?> clazz = classLoader.loadClass(BaseIntegrationBusTask.class.getPackage().getName() + ".JPFStarter");
                    clazz.getMethod("start", Path.class, String.class, Object[].class).invoke(null, plugins, className, args);
                }
            }
            finally {
                if (old4j != null) {
                    System.setProperty("log4j.configuration", old4j);
                } else {
                    System.clearProperty("log4j.configuration");
                }
            }
        }
        catch (BuildException e) {
            throw e;
        }
        catch (Exception e) {
            throw new BuildException((Throwable)e);
        }
    }
}

