/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibus.tools;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.java.plugin.ObjectFactory;
import org.java.plugin.PluginManager;
import org.java.plugin.boot.DefaultPluginsCollector;
import org.java.plugin.registry.IntegrityCheckReport;
import org.java.plugin.registry.ManifestInfo;
import org.java.plugin.registry.ManifestProcessingException;
import org.java.plugin.registry.PluginDescriptor;
import org.java.plugin.registry.PluginRegistry;
import org.java.plugin.util.ExtendedProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JPFStarter {
    private static final Logger log = LoggerFactory.getLogger(JPFStarter.class);

    public static void start(Path plugins, String className, Object ... args) throws Throwable {
        ExtendedProperties config = new ExtendedProperties();
        config.put((Object)"org.java.plugin.standard.StandardPluginLifecycleHandler.stickySynchronizing", (Object)"true");
        config.put((Object)"org.java.plugin.boot.pluginsRepositories", (Object)plugins.toAbsolutePath().toString());
        config.put((Object)"org.java.plugin.standard.StandardPluginLifecycleHandler.probeParentLoaderLast", (Object)"true");
        log.info("collecting plug-in locations");
        DefaultPluginsCollector collector = new DefaultPluginsCollector();
        collector.configure(config);
        log.info("collecting plug-in locations");
        Collection<PluginManager.PluginLocation> pluginLocations = collector.collectPluginLocations();
        log.info("collected " + pluginLocations.size() + " plug-in locations, instantiating plug-in manager");
        PluginManager pluginManager = ObjectFactory.newInstance((ExtendedProperties)config).createManager();
        pluginLocations = JPFStarter.filterPluginLocations(pluginManager.getRegistry(), pluginLocations);
        log.info(pluginLocations.size() + " plug-in locations remain after applying filters, publishing plug-ins");
        pluginManager.publishPlugins(pluginLocations.toArray(new PluginManager.PluginLocation[pluginLocations.size()]));
        log.info("checking plug-ins set integrity");
        IntegrityCheckReport integrityCheckReport = pluginManager.getRegistry().checkIntegrity(null);
        log.info("integrity check done: errors - " + integrityCheckReport.countErrors() + ", warnings - " + integrityCheckReport.countWarnings());
        if (integrityCheckReport.countErrors() != 0) {
            log.info(JPFStarter.integrityCheckReport2str(integrityCheckReport));
            throw new Exception("integrity check error");
        }
        if (integrityCheckReport.countErrors() > 0 || integrityCheckReport.countWarnings() > 0) {
            log.info(JPFStarter.integrityCheckReport2str(integrityCheckReport));
        }
        for (PluginDescriptor plugin : pluginManager.getRegistry().getPluginDescriptors()) {
            pluginManager.activatePlugin(plugin.getId());
        }
        Class[] params = (Class[])Arrays.stream(args).map(a -> a.getClass()).toArray(Class[]::new);
        pluginManager.getPluginClassLoader(pluginManager.getRegistry().getPluginDescriptor("com.gridnine.xtrip.server")).loadClass(className).getMethod("run", params).invoke(null, args);
    }

    private static Collection<PluginManager.PluginLocation> filterPluginLocations(PluginRegistry registry, Collection<PluginManager.PluginLocation> pluginLocations) throws ManifestProcessingException {
        ArrayList<PluginManager.PluginLocation> result = new ArrayList<PluginManager.PluginLocation>();
        for (PluginManager.PluginLocation pluginLocation : pluginLocations) {
            ManifestInfo manifestInfo = registry.readManifestInfo(pluginLocation.getManifestLocation());
            String id = manifestInfo.getId();
            if (!id.contains("common") && !id.contains("server")) continue;
            result.add(pluginLocation);
        }
        return result;
    }

    private static String integrityCheckReport2str(IntegrityCheckReport report) {
        StringBuilder buf = new StringBuilder();
        buf.append("integrity check report:\r\n");
        buf.append("-------------- REPORT BEGIN -----------------\r\n");
        for (IntegrityCheckReport.ReportItem item : report.getItems()) {
            buf.append("\tseverity=").append(item.getSeverity()).append("; code=").append(item.getCode()).append("; message=").append(item.getMessage()).append("; source=").append(item.getSource()).append("\r\n");
        }
        buf.append("-------------- REPORT END -----------------");
        return buf.toString();
    }
}

