/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.index.usage;

import com.gridnine.xtrip.common.usage.IndexUsage;
import com.gridnine.xtrip.common.usage.IndexUsageSource;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.db.storage.model.BaseAssetData;
import java.util.Date;
import java.util.Set;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.hibernate.annotations.Index;

@Entity
public class IndexUsageData
extends BaseAssetData<IndexUsage> {
    @Temporal(value=TemporalType.TIMESTAMP)
    @Index(name="IndexUsageData_modified")
    private Date modified;
    @Index(name="IndexUsageData_reportId")
    private String reportId;
    @Index(name="IndexUsageData_reportDescriptionUid")
    private String reportDescriptionUid;
    @Index(name="IndexUsageData_indexId")
    private String indexId;
    @Index(name="IndexUsageData_fieldId")
    private String fieldId;
    private boolean sorted;
    private boolean retrieved;
    private boolean filtered;
    @Enumerated(value=EnumType.STRING)
    private IndexUsageSource source;

    public void setReportId(String reportId) {
        this.reportId = reportId;
    }

    public void setReportDescriptionUid(String reportDescriptionUid) {
        this.reportDescriptionUid = reportDescriptionUid;
    }

    public void setIndexId(String indexId) {
        this.indexId = indexId;
    }

    public void setFieldId(String fieldId) {
        this.fieldId = fieldId;
    }

    public void setSorted(boolean sorted) {
        this.sorted = sorted;
    }

    public void setRetrieved(boolean retrieved) {
        this.retrieved = retrieved;
    }

    public void setFiltered(boolean filtered) {
        this.filtered = filtered;
    }

    public void setSource(IndexUsageSource source) {
        this.source = source;
    }

    @Override
    public Date getModified() {
        return this.modified;
    }

    @Override
    public void setModified(Date date) {
        this.modified = date;
    }

    @Override
    public IndexUsage toAsset(Set<String> preferredProperties) throws Exception {
        IndexUsage result = new IndexUsage(this.getUid());
        result.setModified(MiscUtil.cloneDate((Date)this.modified));
        if (preferredProperties.isEmpty() || preferredProperties.contains("reportId")) {
            result.setReportId(this.reportId);
        }
        if (preferredProperties.isEmpty() || preferredProperties.contains("source")) {
            result.setSource(this.source);
        }
        if (preferredProperties.isEmpty() || preferredProperties.contains("reportDescriptionUid")) {
            result.setReportDescriptionUid(this.reportDescriptionUid);
        }
        if (preferredProperties.isEmpty() || preferredProperties.contains("indexId")) {
            result.setIndexId(this.indexId);
        }
        if (preferredProperties.isEmpty() || preferredProperties.contains("fieldId")) {
            result.setFieldId(this.fieldId);
        }
        if (preferredProperties.isEmpty() || preferredProperties.contains("sorted")) {
            result.setSorted(this.sorted);
        }
        if (preferredProperties.isEmpty() || preferredProperties.contains("filtered")) {
            result.setFiltered(this.filtered);
        }
        if (preferredProperties.isEmpty() || preferredProperties.contains("retrieved")) {
            result.setRetrieved(this.retrieved);
        }
        return result;
    }

    @Override
    public void fromAsset(IndexUsage asset) throws Exception {
        this.setUid(asset.getUid());
        this.source = asset.getSource();
        this.reportId = asset.getReportId();
        this.reportDescriptionUid = asset.getReportDescriptionUid();
        this.indexId = asset.getIndexId();
        this.fieldId = asset.getFieldId();
        this.sorted = asset.isSorted();
        this.filtered = asset.isFiltered();
        this.retrieved = asset.isRetrieved();
    }
}

