/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.index.usage;

import com.gridnine.xtrip.common.Disposable;
import com.gridnine.xtrip.common.model.BaseAsset;
import com.gridnine.xtrip.common.model.asset.AssetsStorage;
import com.gridnine.xtrip.common.service.ExecutorServiceFacade;
import com.gridnine.xtrip.common.usage.IndexUsage;
import com.gridnine.xtrip.common.usage.IndexUsageHandler;
import com.gridnine.xtrip.common.usage.IndexUsageSource;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.db.storage.LogicalStorage;
import java.util.Properties;

public class ServerIndexUsageHandler
extends IndexUsageHandler
implements Disposable {
    private boolean enabled;
    private ExecutorServiceFacade facade = null;

    public ServerIndexUsageHandler(Properties props) {
        this.enabled = "true".equalsIgnoreCase(props.getProperty("index-usage-handler.enabled"));
        if (this.enabled) {
            this.facade = ExecutorServiceFacade.get().newFixedThreadPool("server-index-usage-handler", 1);
        }
    }

    public ServerIndexUsageHandler(boolean enabled) {
        this.enabled = enabled;
        if (enabled) {
            this.facade = ExecutorServiceFacade.get().newFixedThreadPool("server-index-usage-handler", 1);
        }
    }

    public void statRetrieving(String indexId, String fieldId) {
        this.stat(indexId, fieldId, true, false, false);
    }

    private void stat(String indexId, String fieldId, boolean retrieved, boolean sorted, boolean filtered) {
        if (!this.enabled) {
            return;
        }
        IndexUsageHandler.IndexUsageContext ctx = (IndexUsageHandler.IndexUsageContext)context.get();
        IndexUsageSource source = ctx == null ? IndexUsageSource.OTHER : ctx.source;
        String reportId = ctx == null ? null : ctx.reportId;
        String reportDescriptionUid = ctx == null ? null : ctx.reportDescriptionId;
        this.facade.submit(() -> {
            if (LogicalStorage.get().getUser() == null) {
                LogicalStorage.get().setUser("system");
            }
            String compaundKey = String.format("%s_%s_%s_%s", source.name(), TextUtil.isBlank((String)reportDescriptionUid) ? reportId : reportDescriptionUid, indexId, fieldId);
            IndexUsage usage = (IndexUsage)AssetsStorage.get().load(IndexUsage.class, compaundKey);
            if (usage == null) {
                usage = new IndexUsage(compaundKey);
                usage.setReportId(reportId);
                usage.setSource(source);
                usage.setReportDescriptionUid(reportDescriptionUid);
                usage.setFieldId(fieldId);
                usage.setIndexId(indexId);
            }
            boolean changed = false;
            if (retrieved && !usage.isRetrieved()) {
                changed = true;
                usage.setRetrieved(true);
            }
            if (filtered && !usage.isFiltered()) {
                changed = true;
                usage.setFiltered(true);
            }
            if (sorted && !usage.isSorted()) {
                changed = true;
                usage.setSorted(true);
            }
            if (changed) {
                AssetsStorage.get().save((BaseAsset)usage);
            }
        });
    }

    public void statSorting(String indexId, String fieldId) {
        this.stat(indexId, fieldId, false, true, false);
    }

    public void statFiltering(String indexId, String fieldId) {
        this.stat(indexId, fieldId, false, false, true);
    }

    public boolean isStatEnabled() {
        return this.enabled;
    }

    public void dispose() {
        if (this.facade != null) {
            this.facade.dispose();
        }
    }
}

