/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.jms.config;

import com.gridnine.xtrip.server.cache.asset.AssetsCacheJMSListener;
import com.gridnine.xtrip.server.cache.entity.advanced.AECJMSListener;
import com.gridnine.xtrip.server.jms.JMSConfigurator;
import com.gridnine.xtrip.server.jms.JMSFacade;
import com.gridnine.xtrip.server.jms.JMSTopicConfiguration;
import com.gridnine.xtrip.server.scheduler.ScheduledTasksSettingsJMSListener;

public class BasicJMSConfigurator
implements JMSConfigurator {
    public static final String ENTITY_EXPORT_TOPIC_ID = "entity-export";

    @Override
    public void configure(JMSFacade jms) {
        this.registerAECListener(jms);
        this.registerAssetsCacheListener(jms);
        this.registerScheduledSettingsListener(jms);
        this.registerEntitiesExportListener(jms);
    }

    private void registerScheduledSettingsListener(JMSFacade jms) {
        jms.registerTopic("scheduled-tasks-settings");
        jms.registerTopicListener("scheduled-tasks-settings", new ScheduledTasksSettingsJMSListener());
    }

    private void registerAssetsCacheListener(JMSFacade jms) {
        jms.registerTopic("assets-cache");
        jms.registerTopicListener("assets-cache", new AssetsCacheJMSListener());
    }

    private void registerAECListener(JMSFacade jms) {
        jms.registerTopic("entity-cache");
        jms.registerTopicListener("entity-cache", new AECJMSListener());
    }

    private void registerEntitiesExportListener(JMSFacade jms) {
        jms.registerTopic((JMSTopicConfiguration)((JMSTopicConfiguration)new JMSTopicConfiguration().setId(ENTITY_EXPORT_TOPIC_ID)).setPersistent(true));
    }
}

