/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.jms.impl.activemq;

import com.gridnine.xtrip.common.util.XmlUtil;
import com.gridnine.xtrip.common.xml.XHelper;
import com.gridnine.xtrip.server.jms.BaseJMSBrokerConfiguration;
import com.gridnine.xtrip.server.jms.JMSEmbeddedBrokerConfiguration;
import com.gridnine.xtrip.server.jms.JMSExternalBrokerConfiguration;
import com.gridnine.xtrip.server.jms.JMSPeerBrokerConfiguration;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Element;

final class JMSActiveMQBrokerConfiguration {
    BrokerConfig<BaseJMSBrokerConfiguration<?>> defaultBroker;
    List<BrokerConfig<BaseJMSBrokerConfiguration<?>>> additionalBrokers = new ArrayList();

    JMSActiveMQBrokerConfiguration() {
    }

    void fromXML(Element elm) throws Exception {
        this.defaultBroker = new BrokerConfig();
        this.defaultBroker.fromXML(XmlUtil.getElement((Element)elm, (String)"defaultBroker"));
        this.additionalBrokers.clear();
        for (Element itemElm : XmlUtil.getElements((Element)elm, (String)"additionalBrokers/broker")) {
            BrokerConfig broker = new BrokerConfig();
            broker.fromXML(itemElm);
            this.additionalBrokers.add(broker);
        }
    }

    static class BrokerConfig<E extends BaseJMSBrokerConfiguration<?>> {
        BrokerType type;
        E config;

        BrokerConfig() {
        }

        void fromXML(Element elm) throws Exception {
            this.type = (BrokerType)XHelper.readEnum((Element)elm, (String)"@type", BrokerType.class);
            this.config = null;
            switch (this.type) {
                case PEER: {
                    this.config = new JMSPeerBrokerConfiguration();
                    break;
                }
                case EXTERNAL: {
                    this.config = new JMSExternalBrokerConfiguration();
                    break;
                }
                default: {
                    this.config = new JMSEmbeddedBrokerConfiguration();
                }
            }
            ((BaseJMSBrokerConfiguration)this.config).fromXML(elm);
        }
    }

    static enum BrokerType {
        EMBEDDED,
        EXTERNAL,
        PEER;

    }
}

