/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.jms.impl.activemq;

import com.gridnine.xtrip.common.Disposable;
import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.util.DesUtil;
import com.gridnine.xtrip.common.util.ExceptionUtil;
import com.gridnine.xtrip.server.jms.BaseJMSInternalBrokerConfiguration;
import com.gridnine.xtrip.server.jms.JMSBroker;
import com.gridnine.xtrip.server.jms.JMSBrokersManager;
import com.gridnine.xtrip.server.jms.JMSEmbeddedBrokerConfiguration;
import com.gridnine.xtrip.server.jms.JMSExternalBrokerConfiguration;
import com.gridnine.xtrip.server.jms.JMSLoginConfiguration;
import com.gridnine.xtrip.server.jms.JMSLoginPasswordConfiguration;
import com.gridnine.xtrip.server.jms.JMSPeerBrokerConfiguration;
import java.io.File;
import java.io.IOException;
import java.net.PasswordAuthentication;
import java.security.GeneralSecurityException;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.activemq.broker.BrokerPlugin;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.network.NetworkConnector;
import org.apache.activemq.security.AuthenticationUser;
import org.apache.activemq.security.SimpleAuthenticationPlugin;
import org.apache.activemq.store.leveldb.LevelDBPersistenceAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JMSActiveMQBrokersManagerImpl
implements JMSBrokersManager,
Disposable {
    private final Map<String, BrokerData> services = new HashMap<String, BrokerData>();
    private String defaultBrokerId;
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    public void registerEmbeddedBroker(JMSEmbeddedBrokerConfiguration config) throws Exception {
        String connectionUrl = String.format("vm://%s", config.getId());
        BrokerService broker = new BrokerService();
        try {
            broker.addConnector(connectionUrl);
            broker.setBrokerId(config.getId());
            broker.setBrokerName(config.getId());
            broker.setUseJmx(config.isUseJMX());
            broker.setPersistent(config.isPersistent());
            broker.getSystemUsage().getTempUsage().setLimit(100000L);
            broker.setDataDirectoryFile(this.getDataDirectory());
            broker.setSchedulerSupport(true);
            this.setBrokerAuth(broker, config);
            broker.start();
            this.log.info(String.format("embedded broker registered: id = %s, url = %s", config.getId(), connectionUrl));
        }
        catch (Exception e) {
            this.log.error("unable to start embedded broker", (Throwable)e);
            broker.stop();
            throw e;
        }
        this.services.put(config.getId(), new BrokerData(broker, connectionUrl, this.getLogin(config)));
    }

    private PasswordAuthentication getLogin(BaseJMSInternalBrokerConfiguration<?> config) throws GeneralSecurityException, IOException {
        JMSLoginConfiguration loginConfig = config.getLogin();
        if (null == loginConfig) {
            return null;
        }
        String userName = loginConfig.getUserName();
        return new PasswordAuthentication(userName, DesUtil.decode((String)config.getUsers().stream().filter(u -> userName.equals(u.getUserName())).findFirst().orElseThrow(() -> new IllegalArgumentException("unknown user " + userName)).getPassword()).toCharArray());
    }

    private PasswordAuthentication getLogin(JMSExternalBrokerConfiguration config) throws GeneralSecurityException, IOException {
        JMSLoginPasswordConfiguration loginConfig = config.getLogin();
        return loginConfig != null ? new PasswordAuthentication(loginConfig.getUserName(), DesUtil.decode((String)loginConfig.getPassword()).toCharArray()) : null;
    }

    void registerPeerBroker(JMSPeerBrokerConfiguration config) throws Exception {
        String internalConnectionUrl = String.format("vm://%s", config.getId());
        BrokerService broker = new BrokerService();
        broker.setDataDirectoryFile(this.getDataDirectory());
        broker.setUseJmx(config.isUseJMX());
        try {
            broker.setBrokerId(config.getId());
            broker.setBrokerName(config.getId());
            broker.addConnector(internalConnectionUrl);
            String localPort = String.format("tcp://%s:%s", config.getLocalIP(), Integer.toString(config.getLocalPort()));
            broker.addConnector(localPort);
            for (int n = 0; n < config.getExternalBrokersAddresses().size(); ++n) {
                NetworkConnector nc = broker.addNetworkConnector(String.format("static://(tcp://%s)", config.getExternalBrokersAddresses().get(n)));
                nc.setName(String.format("%s-%s", Environment.getApplicationId(), Integer.toString(n)));
            }
            broker.setPersistent(config.isPersistent());
            broker.setPersistenceFactory(() -> {
                LevelDBPersistenceAdapter adaptor = new LevelDBPersistenceAdapter();
                File dir = new File(broker.getBrokerDataDirectory(), "LevelDB");
                adaptor.setDirectory(dir);
                return adaptor;
            });
            broker.getSystemUsage().getTempUsage().setLimit(10000000L);
            broker.setSchedulerSupport(true);
            this.setBrokerAuth(broker, config);
            broker.start();
            this.log.info(String.format("peer broker registered: id = %s, internalURL = %s, localPort= %s, peers = %s", config.getId(), internalConnectionUrl, localPort, config.getExternalBrokersAddresses()));
        }
        catch (Exception e) {
            this.log.error("unable to start embedded broker", (Throwable)e);
            try {
                broker.stop();
            }
            catch (Exception e2) {
                this.log.error("unable to stop embedded broker", (Throwable)e);
            }
            throw e;
        }
        this.services.put(config.getId(), new BrokerData(broker, internalConnectionUrl, this.getLogin(config)));
    }

    private void setBrokerAuth(BrokerService broker, BaseJMSInternalBrokerConfiguration<?> config) {
        if (config.getUsers().size() == 0) {
            return;
        }
        SimpleAuthenticationPlugin plugin = new SimpleAuthenticationPlugin(config.getUsers().stream().map(ExceptionUtil.wrapFunction(u -> new AuthenticationUser(u.getUserName(), DesUtil.decode((String)u.getPassword()), "users,admins"))).collect(Collectors.toList()));
        BrokerPlugin[] plugins = broker.getPlugins();
        if (null == plugins || plugins.length == 0) {
            broker.setPlugins(new BrokerPlugin[]{plugin});
        } else {
            broker.setPlugins((BrokerPlugin[])Stream.concat(Stream.of(plugins), Stream.of(plugin)).toArray(BrokerPlugin[]::new));
        }
    }

    private File getDataDirectory() {
        File result = new File(Environment.getDataFolder(), "activemq-data");
        if (!result.exists() && !result.mkdirs()) {
            throw new IllegalStateException("unable to create data directory " + result);
        }
        return result;
    }

    public void registerExternalBroker(JMSExternalBrokerConfiguration config) throws GeneralSecurityException, IOException {
        String connectionUrl = String.format("failover:tcp://%s:%s", config.getExternalBrokerIP(), Integer.toString(config.getExternalBrokerPort()));
        this.services.put(config.getId(), new BrokerData(null, connectionUrl, this.getLogin(config)));
        this.log.info(String.format("external broker registered: id = %s, url = %s", config.getId(), connectionUrl));
    }

    public void stop() {
        for (BrokerData data : this.services.values()) {
            BrokerService broker = data.service;
            if (null == broker) continue;
            try {
                broker.stop();
            }
            catch (Exception e) {
                this.log.error(String.format("unable to stop broker %s", broker), (Throwable)e);
            }
        }
    }

    public String toString() {
        return String.format("ActiveMQJMSBrokers: urls = %s", this.services.values().stream().map(BrokerData::toString).collect(Collectors.joining(", ")));
    }

    @Override
    public String getDefaultBrokerId() {
        return this.defaultBrokerId;
    }

    public void setDefaultBrokerId(String value) {
        this.defaultBrokerId = value;
    }

    @Override
    public JMSBroker getBroker(String brokerId) {
        return this.services.get(brokerId);
    }

    public void dispose() {
        this.stop();
    }

    private static class BrokerData
    implements JMSBroker {
        private final BrokerService service;
        private final String connectionUrl;
        private final PasswordAuthentication login;

        BrokerData(BrokerService bService, String url, PasswordAuthentication login) {
            this.service = bService;
            this.connectionUrl = url;
            this.login = login;
        }

        @Override
        public String getConnectionUrl() {
            return this.connectionUrl;
        }

        @Override
        public PasswordAuthentication getLogin() {
            return this.login;
        }

        public String toString() {
            return this.connectionUrl;
        }
    }
}

