/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.jms.impl.activemq;

import com.gridnine.xtrip.common.Disposable;
import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.service.ExecutorServiceFacade;
import com.gridnine.xtrip.server.jms.BaseJMSItemConfiguration;
import com.gridnine.xtrip.server.jms.JMSBroker;
import com.gridnine.xtrip.server.jms.JMSBrokersManager;
import com.gridnine.xtrip.server.jms.JMSFacade;
import com.gridnine.xtrip.server.jms.JMSMessageConfiguration;
import com.gridnine.xtrip.server.jms.JMSOperationException;
import com.gridnine.xtrip.server.jms.JMSQueueConfiguration;
import com.gridnine.xtrip.server.jms.JMSQueueWorker;
import com.gridnine.xtrip.server.jms.JMSTopicConfiguration;
import com.gridnine.xtrip.server.jms.JMSTopicListener;
import com.gridnine.xtrip.server.jms.JMSTopicListenerConfiguration;
import java.io.Serializable;
import java.net.PasswordAuthentication;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.ObjectMessage;
import javax.jms.Queue;
import javax.jms.Session;
import javax.jms.Topic;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JMSActiveMQFacadeImpl
implements JMSFacade,
Disposable {
    final Map<String, TopicData> topics = new ConcurrentHashMap<String, TopicData>();
    final Map<String, QueueData> queues = new ConcurrentHashMap<String, QueueData>();
    private final ExecutorServiceFacade service = ((ExecutorServiceFacade)Environment.getPublished(ExecutorServiceFacade.class)).newFixedThreadPool("jms", 1);
    final Logger log = LoggerFactory.getLogger(this.getClass());
    final JMSBrokersManager manager;

    public JMSActiveMQFacadeImpl(JMSBrokersManager brokerManager) {
        this.manager = brokerManager;
    }

    @Override
    public void registerTopic(String topicId) throws JMSOperationException {
        this.registerTopic((JMSTopicConfiguration)((JMSTopicConfiguration)new JMSTopicConfiguration().setBrokerId(this.manager.getDefaultBrokerId())).setId(topicId));
    }

    @Override
    public void registerExternalTopic(String topicId) throws JMSOperationException {
        this.registerExternalTopic((JMSTopicConfiguration)((JMSTopicConfiguration)new JMSTopicConfiguration().setBrokerId(this.manager.getDefaultBrokerId())).setId(topicId));
    }

    @Override
    public void registerTopic(JMSTopicConfiguration config) throws JMSOperationException {
        String topicId = config.getId();
        if (this.topics.get(topicId) != null) {
            throw new IllegalArgumentException(String.format("topic %s is already published", topicId));
        }
        TopicConsumerData consumer = this.createConsumer(config);
        try {
            TopicProducerData producer = this.createProducer(config);
            this.topics.put(config.getId(), new TopicData(producer, consumer));
        }
        catch (Throwable e) {
            try {
                consumer.stop();
            }
            catch (Exception e1) {
                this.log.error("unable to stop consumer", (Throwable)e1);
            }
            throw new JMSOperationException("unable to create consumer", e);
        }
    }

    @Override
    public void registerExternalTopic(JMSTopicConfiguration config) throws JMSOperationException {
        String topicId = config.getId();
        if (this.topics.get(topicId) != null) {
            throw new IllegalArgumentException(String.format("topic %s is already published", topicId));
        }
        TopicProducerData producer = this.createProducer(config);
        this.topics.put(config.getId(), new TopicData(producer, null));
    }

    private TopicProducerData createProducer(JMSTopicConfiguration config) {
        JMSBroker broker = this.manager.getBroker(config.getBrokerId() == null ? this.manager.getDefaultBrokerId() : config.getBrokerId());
        String subscriberAddress = broker.getConnectionUrl();
        PasswordAuthentication login = config.getLogin();
        if (null == login) {
            login = broker.getLogin();
        }
        ActiveMQConnectionFactory connectionFactory = login != null ? new ActiveMQConnectionFactory(login.getUserName(), new String(login.getPassword()), subscriberAddress) : new ActiveMQConnectionFactory(subscriberAddress);
        Connection connection = null;
        try {
            connection = connectionFactory.createConnection();
            connection.start();
            Session session = connection.createSession(false, 1);
            Topic destination = session.createTopic(config.getId());
            MessageProducer producer = session.createProducer((Destination)destination);
            producer.setDeliveryMode(1);
            if (config.isPersistent()) {
                producer.setDeliveryMode(2);
                if (config.getTimeToLive() != 0) {
                    producer.setTimeToLive((long)config.getTimeToLive());
                }
            }
            this.log.info(String.format("producer for topic with id %s successfully registered", config.getId()));
            return new TopicProducerData(connection, session, producer, config);
        }
        catch (Exception e) {
            this.log.error(String.format("unable to publish producer for topic with id %s", config.getId()), (Throwable)e);
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (JMSException e1) {
                    this.log.error("unable to close connection", (Throwable)e1);
                }
            }
            throw new JMSOperationException("unable to create producer for topic with id %s", e);
        }
    }

    private TopicConsumerData createConsumer(JMSTopicConfiguration config) {
        JMSBroker broker = this.manager.getBroker(config.getBrokerId() == null ? this.manager.getDefaultBrokerId() : config.getBrokerId());
        String subscriberAddress = broker.getConnectionUrl();
        PasswordAuthentication login = config.getLogin();
        if (null == login) {
            login = broker.getLogin();
        }
        ActiveMQConnectionFactory connectionFactory = login != null ? new ActiveMQConnectionFactory(login.getUserName(), new String(login.getPassword()), subscriberAddress) : new ActiveMQConnectionFactory(subscriberAddress);
        final ArrayList listeners = new ArrayList();
        try {
            Connection connection = connectionFactory.createConnection();
            if (config.isDurableSubscribers()) {
                connection.setClientID(Environment.getApplicationId());
            }
            try {
                connection.start();
                Session session = connection.createSession(false, 1);
                Topic destination = session.createTopic(config.getId());
                MessageConsumer consumer = config.isDurableSubscribers() ? session.createDurableSubscriber(destination, config.getId()) : session.createConsumer((Destination)destination);
                connection.setExceptionListener(new ExceptionListener(){

                    public void onException(JMSException arg0) {
                        JMSActiveMQFacadeImpl.this.log.error("exception occured", (Throwable)arg0);
                    }
                });
                consumer.setMessageListener(new MessageListener(){

                    public void onMessage(Message message) {
                        try {
                            ObjectMessage om;
                            LinkedHashMap<String, Object> object = null;
                            if (message instanceof ObjectMessage) {
                                om = (ObjectMessage)message;
                                object = om.getObject();
                            } else if (message instanceof MapMessage) {
                                om = (MapMessage)message;
                                LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
                                Enumeration e = om.getMapNames();
                                while (e.hasMoreElements()) {
                                    String name = (String)e.nextElement();
                                    result.put(name, om.getObject(name));
                                }
                                object = result;
                            }
                            JMSActiveMQFacadeImpl.this.log.debug(String.format("map message %s recieved", object));
                            if (object != null) {
                                for (TopicListenerData item : listeners) {
                                    item.listener.onMessage(object);
                                }
                            }
                        }
                        catch (Throwable e) {
                            JMSActiveMQFacadeImpl.this.log.error("unable to extract message from topic", e);
                        }
                    }
                });
                this.log.info(String.format("listener successfully registered for topic %s, adress %s", config.getId(), subscriberAddress));
                return new TopicConsumerData(connection, session, consumer, config, listeners);
            }
            catch (Exception e) {
                this.log.error("unable to register listener for topic " + config.getId(), (Throwable)e);
                if (connection != null) {
                    try {
                        connection.close();
                    }
                    catch (JMSException e1) {
                        this.log.error("unable to close connection", (Throwable)e1);
                    }
                }
                throw new JMSOperationException("unable to create topic " + config.getId(), e);
            }
        }
        catch (Exception e) {
            throw new JMSOperationException("unable to create topic " + config.getId(), e);
        }
    }

    @Override
    public <T> void registerTopicListener(String topicId, JMSTopicListener<T> listener) throws JMSOperationException {
        this.registerTopicListener(listener, new JMSTopicListenerConfiguration().setTopicId(topicId));
    }

    @Override
    public <T> void registerTopicListener(JMSTopicListener<T> listener, JMSTopicListenerConfiguration config) throws JMSOperationException {
        String topicId = config.getTopicId();
        TopicData topicData = this.topics.get(topicId);
        if (topicData == null) {
            throw new IllegalArgumentException(String.format("topic %s is not published", topicId));
        }
        if (null == topicData.consumerData) {
            throw new IllegalArgumentException(String.format("write only topic %s not allowed listeners", topicId));
        }
        ((TopicConsumerData)topicData.consumerData).listeners.add(new TopicListenerData<T>(listener, config));
    }

    @Override
    public <T> void publishMessageAsync(final T message, final JMSMessageConfiguration config) {
        if (message instanceof Map) {
            Map map = (Map)message;
            for (Object key : map.keySet()) {
                if (key instanceof String) continue;
                throw new IllegalArgumentException(String.format("keys in message %s map must be String", message));
            }
        } else if (!(message instanceof Serializable)) {
            throw new IllegalArgumentException(String.format("message %s must be either map or serializable object", message));
        }
        this.service.submit((Callable)new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                BaseItemData data = JMSActiveMQFacadeImpl.this.topics.get(config.getTopicId());
                if (data == null) {
                    data = JMSActiveMQFacadeImpl.this.queues.get(config.getTopicId());
                }
                if (data == null) {
                    throw new IllegalArgumentException(String.format("neither topic nor queue with id %s is not published", config.getTopicId()));
                }
                try {
                    if (message instanceof Map) {
                        Map map = (Map)message;
                        MapMessage mapMessage = ((BaseProducerData)data.producerData).session.createMapMessage();
                        for (Map.Entry entry : map.entrySet()) {
                            mapMessage.setObject((String)entry.getKey(), entry.getValue());
                        }
                        if (config.getDelay() != null) {
                            mapMessage.setLongProperty("AMQ_SCHEDULED_DELAY", config.getDelay().longValue());
                        }
                        ((BaseProducerData)data.producerData).producer.send((Message)mapMessage);
                    } else {
                        ObjectMessage objectMessage = ((BaseProducerData)data.producerData).session.createObjectMessage((Serializable)message);
                        if (config.getDelay() != null) {
                            objectMessage.setLongProperty("AMQ_SCHEDULED_DELAY", config.getDelay().longValue());
                        }
                        ((BaseProducerData)data.producerData).producer.send((Message)objectMessage);
                    }
                    JMSActiveMQFacadeImpl.this.log.debug(String.format("message %s successfully sent", message));
                }
                catch (Throwable e) {
                    JMSActiveMQFacadeImpl.this.log.error(String.format("unable to send message %s", message), e);
                    throw new JMSOperationException("unable to send message", e);
                }
                return null;
            }
        });
    }

    @Override
    public <T> void publishMessageAsync(String topicId, T message) {
        this.publishMessageAsync(message, new JMSMessageConfiguration().setTopicId(topicId));
    }

    public void stop() {
        this.stopAllQueueWorkers();
        this.stop(this.topics.values());
        this.stop(this.queues.values());
        this.stopService();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T extends BaseJMSItemConfiguration<T>, P extends BaseProducerData<T>, C extends BaseConsumerData<T>, F extends BaseItemData<T, P, C>> void stop(Collection<F> values) {
        for (BaseItemData topic : values) {
            try {
                try {
                    ((BaseProducerData)topic.producerData).stop();
                }
                finally {
                    if (topic.consumerData == null || topic.isConsumerStopped()) continue;
                    ((BaseConsumerData)topic.consumerData).stop();
                }
            }
            catch (Exception e) {
                this.log.error("unable to stop consumers or producer of topic " + topic, (Throwable)e);
            }
        }
    }

    private void stopService() {
        this.service.dispose();
    }

    public void dispose() {
        this.stop();
    }

    public String toString() {
        return String.format("ActiveMQJMS: topics: %s, queues: %s", this.topics.keySet(), this.queues.keySet());
    }

    @Override
    public <T> void registerQueue(JMSQueueConfiguration config, JMSQueueWorker<T> worker) throws JMSOperationException {
        String topicId = config.getId();
        if (this.queues.get(topicId) != null) {
            throw new IllegalArgumentException(String.format("queue %s is already published", topicId));
        }
        QueueConsumerData consumer = this.createConsumer(config, worker);
        try {
            QueueProducerData producer = this.createProducer(config);
            this.queues.put(config.getId(), new QueueData(producer, consumer));
        }
        catch (Throwable e) {
            try {
                consumer.stop();
            }
            catch (Exception e1) {
                this.log.error("unable to stop consumer", (Throwable)e1);
            }
            throw new JMSOperationException("unable to create consumer", e);
        }
    }

    private <T> QueueConsumerData createConsumer(final JMSQueueConfiguration config, final JMSQueueWorker<T> worker) {
        JMSBroker broker = this.manager.getBroker(config.getBrokerId() == null ? this.manager.getDefaultBrokerId() : config.getBrokerId());
        String subscriberAddress = broker.getConnectionUrl();
        PasswordAuthentication login = config.getLogin();
        if (null == login) {
            login = broker.getLogin();
        }
        ActiveMQConnectionFactory connectionFactory = login != null ? new ActiveMQConnectionFactory(login.getUserName(), new String(login.getPassword()), subscriberAddress) : new ActiveMQConnectionFactory(subscriberAddress);
        try {
            Connection connection = connectionFactory.createConnection();
            try {
                connection.start();
                Session session = connection.createSession(false, 2);
                Queue destination = session.createQueue(config.isClusterWide() ? config.getId() : String.format("%s-%s", Environment.getApplicationId(), config.getId()));
                MessageConsumer consumer = session.createConsumer((Destination)destination);
                final QueueConsumerData consumerData = new QueueConsumerData(connection, session, consumer, config, worker);
                consumer.setMessageListener(new MessageListener(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void onMessage(Message message) {
                        boolean acknowledged = false;
                        try {
                            consumerData.setMessageBeingProcessed(true);
                            acknowledged = worker.processRequest(((ObjectMessage)message).getObject());
                        }
                        catch (Throwable e) {
                            JMSActiveMQFacadeImpl.this.log.error("unable to extract process item from queue " + config.getId(), e);
                        }
                        finally {
                            if (acknowledged || config.isUseAutoAcknowledge()) {
                                try {
                                    message.acknowledge();
                                }
                                catch (Throwable e) {
                                    JMSActiveMQFacadeImpl.this.log.error("unable to ucknowledge process item from queue " + config.getId(), e);
                                }
                            }
                            consumerData.setMessageBeingProcessed(false);
                        }
                    }
                });
                this.log.info(String.format("consumer successfully registered for queue %s, adress %s", config.getId(), subscriberAddress));
                return consumerData;
            }
            catch (Exception e) {
                this.log.error("unable to register consumer for queue " + config.getId(), (Throwable)e);
                if (connection != null) {
                    try {
                        connection.close();
                    }
                    catch (JMSException e1) {
                        this.log.error("unable to close connection", (Throwable)e1);
                    }
                }
                throw new JMSOperationException("unable to create consumer for queue " + config.getId(), e);
            }
        }
        catch (Exception e) {
            throw new JMSOperationException("unable to consumer for queue " + config.getId(), e);
        }
    }

    @Override
    public <T> void registerQueue(String queueId, JMSQueueWorker<T> worker) throws JMSOperationException {
        this.registerQueue((JMSQueueConfiguration)((JMSQueueConfiguration)new JMSQueueConfiguration().setId(queueId)).setPersistent(true), worker);
    }

    private QueueProducerData createProducer(JMSQueueConfiguration config) {
        JMSBroker broker = this.manager.getBroker(config.getBrokerId() == null ? this.manager.getDefaultBrokerId() : config.getBrokerId());
        String subscriberAddress = broker.getConnectionUrl();
        PasswordAuthentication login = config.getLogin();
        if (null == login) {
            login = broker.getLogin();
        }
        ActiveMQConnectionFactory connectionFactory = login != null ? new ActiveMQConnectionFactory(login.getUserName(), new String(login.getPassword()), subscriberAddress) : new ActiveMQConnectionFactory(subscriberAddress);
        Connection connection = null;
        try {
            connection = connectionFactory.createConnection();
            connection.start();
            Session session = connection.createSession(false, 2);
            Queue destination = session.createQueue(config.isClusterWide() ? config.getId() : String.format("%s-%s", Environment.getApplicationId(), config.getId()));
            MessageProducer producer = session.createProducer((Destination)destination);
            producer.setDeliveryMode(1);
            if (config.isPersistent()) {
                producer.setDeliveryMode(2);
                if (config.getTimeToLive() != 0) {
                    producer.setTimeToLive((long)config.getTimeToLive());
                }
            }
            this.log.info(String.format("producer for queue with id %s successfully registered", config.getId()));
            return new QueueProducerData(connection, session, producer, config);
        }
        catch (Exception e) {
            this.log.error(String.format("unable to publish producer for queue with id %s", config.getId()), (Throwable)e);
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (JMSException e1) {
                    this.log.error("unable to close connection", (Throwable)e1);
                }
            }
            throw new JMSOperationException("unable to create producer for queue with id %s", e);
        }
    }

    @Override
    public void stopAllQueueWorkers() throws JMSOperationException {
        JMSException t = null;
        for (Map.Entry<String, QueueData> entry : this.queues.entrySet()) {
            QueueData item = entry.getValue();
            if (null == item.consumerData) continue;
            try {
                ((QueueConsumerData)item.consumerData).consumer.setMessageListener(null);
            }
            catch (JMSException e) {
                this.log.error("unable to to cleanup message listener for " + entry.getKey(), (Throwable)e);
                t = e;
            }
        }
        for (QueueData item : this.queues.values()) {
            if (null == item.consumerData) continue;
            while (((QueueConsumerData)item.consumerData).isMessageBeingProcessed()) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        if (t != null) {
            throw new JMSOperationException("unable to stop workers", t);
        }
    }

    @Override
    public boolean isRegisterTopic(String topicId) throws JMSOperationException {
        return this.topics.containsKey(topicId);
    }

    static class QueueWorkerData<T> {
        final JMSQueueWorker<T> worker;
        final JMSQueueConfiguration config;

        public QueueWorkerData(JMSQueueWorker<T> lst, JMSQueueConfiguration conf) {
            this.worker = lst;
            this.config = conf;
        }
    }

    static class TopicListenerData<T> {
        final JMSTopicListener<T> listener;
        final JMSTopicListenerConfiguration config;

        public TopicListenerData(JMSTopicListener<T> lst, JMSTopicListenerConfiguration conf) {
            this.listener = lst;
            this.config = conf;
        }
    }

    static class QueueData
    extends BaseItemData<JMSQueueConfiguration, QueueProducerData, QueueConsumerData> {
        QueueData(QueueProducerData producer, QueueConsumerData consumer) {
            super(producer, consumer);
        }
    }

    static class TopicData
    extends BaseItemData<JMSTopicConfiguration, TopicProducerData, TopicConsumerData> {
        TopicData(TopicProducerData producer, TopicConsumerData consumer) {
            super(producer, consumer);
        }
    }

    static class BaseItemData<T extends BaseJMSItemConfiguration<T>, P extends BaseProducerData<T>, C extends BaseConsumerData<T>> {
        final P producerData;
        final C consumerData;
        private boolean consumerStopped;

        boolean isConsumerStopped() {
            return this.consumerStopped;
        }

        void setConsumerStopped(boolean value) {
            this.consumerStopped = value;
        }

        BaseItemData(P producer, C consumer) {
            this.producerData = producer;
            this.consumerData = consumer;
        }
    }

    static class QueueConsumerData
    extends BaseConsumerData<JMSQueueConfiguration> {
        private final JMSQueueWorker<?> worker;
        private volatile boolean messageBeingProcessed;

        QueueConsumerData(Connection cnn, Session ss, MessageConsumer prod, JMSQueueConfiguration conf, JMSQueueWorker<?> work) {
            super(cnn, ss, prod, conf);
            this.worker = work;
        }

        JMSQueueWorker<?> getWorker() {
            return this.worker;
        }

        boolean isMessageBeingProcessed() {
            return this.messageBeingProcessed;
        }

        void setMessageBeingProcessed(boolean value) {
            this.messageBeingProcessed = value;
        }
    }

    static class TopicConsumerData
    extends BaseConsumerData<JMSTopicConfiguration> {
        final List<TopicListenerData<?>> listeners;

        TopicConsumerData(Connection cnn, Session ss, MessageConsumer prod, JMSTopicConfiguration conf, List<TopicListenerData<?>> lsts) {
            super(cnn, ss, prod, conf);
            this.listeners = lsts;
        }
    }

    static class BaseConsumerData<T extends BaseJMSItemConfiguration<T>> {
        final Logger log = LoggerFactory.getLogger(this.getClass());
        final MessageConsumer consumer;
        final Session session;
        final Connection connection;
        final T config;

        BaseConsumerData(Connection cnn, Session ss, MessageConsumer prod, T conf) {
            this.connection = cnn;
            this.session = ss;
            this.consumer = prod;
            this.config = conf;
        }

        void stop() throws Exception {
            this.log.debug("stopping consumer " + ((BaseJMSItemConfiguration)this.config).getId());
            try {
                try {
                    this.consumer.close();
                }
                finally {
                    this.session.close();
                }
            }
            finally {
                this.connection.close();
            }
            this.log.debug("stopping consumer stopped " + ((BaseJMSItemConfiguration)this.config).getId());
        }
    }

    static class QueueProducerData
    extends BaseProducerData<JMSQueueConfiguration> {
        QueueProducerData(Connection cnn, Session ss, MessageProducer prod, JMSQueueConfiguration conf) {
            super(cnn, ss, prod, conf);
        }
    }

    static class TopicProducerData
    extends BaseProducerData<JMSTopicConfiguration> {
        TopicProducerData(Connection cnn, Session ss, MessageProducer prod, JMSTopicConfiguration conf) {
            super(cnn, ss, prod, conf);
        }
    }

    static class BaseProducerData<T extends BaseJMSItemConfiguration<T>> {
        final Logger log = LoggerFactory.getLogger(this.getClass());
        final MessageProducer producer;
        final Session session;
        final Connection connection;
        final T config;

        BaseProducerData(Connection cnn, Session ss, MessageProducer prod, T conf) {
            this.connection = cnn;
            this.session = ss;
            this.producer = prod;
            this.config = conf;
        }

        void stop() throws Exception {
            this.log.debug("stopping producer " + ((BaseJMSItemConfiguration)this.config).getId());
            try {
                try {
                    this.producer.close();
                }
                finally {
                    this.session.close();
                }
            }
            finally {
                this.connection.close();
            }
            this.log.debug("producer stopped " + ((BaseJMSItemConfiguration)this.config).getId());
        }

        public String toString() {
            return String.format("{broker: %s, topic: %s}", ((BaseJMSItemConfiguration)this.config).getBrokerId(), ((BaseJMSItemConfiguration)this.config).getId());
        }
    }
}

