/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.jms.impl.activemq;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.util.IoUtil;
import com.gridnine.xtrip.common.util.JpfUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.xml.DocumentBuilderHelper;
import com.gridnine.xtrip.server.jms.BaseJMSBrokerConfiguration;
import com.gridnine.xtrip.server.jms.JMSBrokersManager;
import com.gridnine.xtrip.server.jms.JMSConfigurator;
import com.gridnine.xtrip.server.jms.JMSEmbeddedBrokerConfiguration;
import com.gridnine.xtrip.server.jms.JMSExternalBrokerConfiguration;
import com.gridnine.xtrip.server.jms.JMSFacade;
import com.gridnine.xtrip.server.jms.JMSPeerBrokerConfiguration;
import com.gridnine.xtrip.server.jms.impl.activemq.JMSActiveMQBrokerConfiguration;
import com.gridnine.xtrip.server.jms.impl.activemq.JMSActiveMQBrokersManagerImpl;
import com.gridnine.xtrip.server.jms.impl.activemq.JMSActiveMQFacadeImpl;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Properties;
import org.java.plugin.registry.Extension;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JMSActiveMQPublisher {
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    private void publish(JMSActiveMQBrokerConfiguration config) throws Exception {
        JMSActiveMQBrokersManagerImpl brokersManager = new JMSActiveMQBrokersManagerImpl();
        brokersManager.setDefaultBrokerId(((BaseJMSBrokerConfiguration)config.defaultBroker.config).getId());
        this.registerBroker(brokersManager, config.defaultBroker);
        for (JMSActiveMQBrokerConfiguration.BrokerConfig<BaseJMSBrokerConfiguration<?>> item : config.additionalBrokers) {
            this.registerBroker(brokersManager, item);
        }
        Environment.publish(JMSBrokersManager.class, (Object)brokersManager);
        JMSActiveMQFacadeImpl facade = new JMSActiveMQFacadeImpl(brokersManager);
        Environment.publish(JMSFacade.class, (Object)facade);
        this.log.info("JMS facade published: " + facade.toString());
        for (Extension ext : JpfUtil.getConnectedExtensions((String)"com.gridnine.xtrip.server", (String)"JMSConfigurator")) {
            try {
                JMSConfigurator configurator = (JMSConfigurator)JpfUtil.getClass((Extension)ext).newInstance();
                configurator.configure(facade);
                this.log.info("JMS successfully configured from " + ext);
            }
            catch (Exception e) {
                this.log.error("failed configuring JMS from " + ext, (Throwable)e);
            }
        }
    }

    private void registerBroker(JMSActiveMQBrokersManagerImpl brokersManager, JMSActiveMQBrokerConfiguration.BrokerConfig<BaseJMSBrokerConfiguration<?>> brokerConfig) throws Exception {
        switch (brokerConfig.type) {
            case PEER: {
                brokersManager.registerPeerBroker((JMSPeerBrokerConfiguration)brokerConfig.config);
                break;
            }
            case EXTERNAL: {
                brokersManager.registerExternalBroker((JMSExternalBrokerConfiguration)brokerConfig.config);
                break;
            }
            default: {
                brokersManager.registerEmbeddedBroker((JMSEmbeddedBrokerConfiguration)brokerConfig.config);
            }
        }
    }

    public void publish(Properties props) throws Exception {
        File file = new File(Environment.getConfigurationFolder(), "jms-brokers.xml");
        if (file.exists()) {
            this.publishFromXmlConfig(file);
            return;
        }
        this.publishFromPropertiesConfig(props);
    }

    private void publishFromPropertiesConfig(Properties props) throws Exception {
        JMSActiveMQBrokerConfiguration config = new JMSActiveMQBrokerConfiguration();
        switch (this.findType(props)) {
            case EXTERNAL: {
                config.defaultBroker = this.getExternalBrokerConfig(props);
                break;
            }
            default: {
                config.defaultBroker = this.getEmbeddedBrokerConfig(props);
            }
        }
        this.publish(config);
    }

    private JMSActiveMQBrokerConfiguration.BrokerConfig<BaseJMSBrokerConfiguration<?>> getEmbeddedBrokerConfig(Properties props) {
        JMSActiveMQBrokerConfiguration.BrokerConfig brokerConfig = new JMSActiveMQBrokerConfiguration.BrokerConfig();
        brokerConfig.type = JMSActiveMQBrokerConfiguration.BrokerType.EMBEDDED;
        JMSEmbeddedBrokerConfiguration config = new JMSEmbeddedBrokerConfiguration();
        brokerConfig.config = config;
        config.setId(Environment.getApplicationId());
        return brokerConfig;
    }

    JMSActiveMQBrokerConfiguration.BrokerConfig<BaseJMSBrokerConfiguration<?>> getExternalBrokerConfig(Properties props) {
        JMSActiveMQBrokerConfiguration.BrokerConfig brokerConfig = new JMSActiveMQBrokerConfiguration.BrokerConfig();
        brokerConfig.type = JMSActiveMQBrokerConfiguration.BrokerType.EXTERNAL;
        JMSExternalBrokerConfiguration config = new JMSExternalBrokerConfiguration();
        brokerConfig.config = config;
        config.setId(Environment.getApplicationId());
        config.setExternalBrokerIP(this.findHost(props));
        config.setExternalBrokerPort(this.findPort(props));
        return brokerConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void publishFromXmlConfig(File file) throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try (FileInputStream fis = new FileInputStream(file);){
            IoUtil.copyStream((InputStream)fis, (OutputStream)baos, (int)256);
        }
        JMSActiveMQBrokerConfiguration config = new JMSActiveMQBrokerConfiguration();
        config.fromXML(DocumentBuilderHelper.parse((InputStream)new ByteArrayInputStream(baos.toByteArray())).getDocumentElement());
        this.publish(config);
    }

    private int findPort(Properties props) {
        String portStr = props.getProperty("broker-port");
        if (TextUtil.isBlank((String)portStr)) {
            return 0;
        }
        try {
            return Integer.parseInt(portStr.trim());
        }
        catch (Exception e) {
            this.log.error("unable to parse port from " + portStr);
            return 0;
        }
    }

    private String findHost(Properties props) {
        String hostStr = props.getProperty("broker-host");
        if (TextUtil.isBlank((String)hostStr)) {
            return "localhost";
        }
        return hostStr.trim();
    }

    private JMSActiveMQBrokerConfiguration.BrokerType findType(Properties props) {
        String typeStr = props.getProperty("broker-type");
        if (TextUtil.isBlank((String)typeStr)) {
            return JMSActiveMQBrokerConfiguration.BrokerType.EMBEDDED;
        }
        typeStr = typeStr.trim();
        for (JMSActiveMQBrokerConfiguration.BrokerType item : JMSActiveMQBrokerConfiguration.BrokerType.values()) {
            if (!item.name().equalsIgnoreCase(typeStr)) continue;
            return item;
        }
        this.log.warn(String.format("broker type %s does not match any predefined value", typeStr));
        return JMSActiveMQBrokerConfiguration.BrokerType.EMBEDDED;
    }
}

