/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.lockmanager;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.lockmanager.LockStats;
import com.gridnine.xtrip.common.lockmanager.NamedLock;
import com.gridnine.xtrip.common.lockmanager.OperationInProgressException;
import com.gridnine.xtrip.common.user.UserData;
import com.gridnine.xtrip.common.util.UUIDGenerator;
import com.gridnine.xtrip.server.lockmanager.DistributedException;
import com.gridnine.xtrip.server.lockmanager.DistributedLockManager;
import com.gridnine.xtrip.server.lockmanager.ZooKeeperClient;
import com.gridnine.xtrip.server.lockmanager.ZooPersistentLock;
import com.gridnine.xtrip.server.metrics.Metrics;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DistributedLock
implements NamedLock {
    private static final Logger log = LoggerFactory.getLogger(DistributedLock.class);
    private static final String LOCK_PATH = "/xtrip/locks/";
    private static final int TRY_TIMEOUT = 500;
    private static final int MAX_TRY_TIMEOUT = 2500;
    private final ZooPersistentLock zooLock;
    private final long lockPeriod;
    private final Object lockName;
    private final boolean reentrantLock;
    private static final String ROOT_METRICS = "profiling.lock";
    private static final String LOCK_METRICS = "profiling.lock.lock";
    private static final String LOCK_METRICS_ALL = "profiling.lock.lock.all.all";
    private static final String LOCK_METRICS_SUCCESS = "profiling.lock.lock.all.success";
    private static final String LOCK_METRICS_FAIL = "profiling.lock.lock.all.fail";
    private static final String LOCK_METRICS_SINGLE_ALL = "profiling.lock.lock.single.all";
    private static final String LOCK_METRICS_SINGLE_SUCCESS = "profiling.lock.lock.single.success";
    private static final String LOCK_METRICS_SINGLE_FAIL = "profiling.lock.lock.single.fail";
    private static final String LOCK_METRICS_REENTRANT_LOCAL_ALL = "profiling.lock.lock.reentrant-local.all";
    private static final String LOCK_METRICS_ANY = "profiling.lock.lock.metrics.";
    private static final String UNLOCK_METRICS = "profiling.lock.unlock";
    private static final String UNLOCK_METRICS_ALL = "profiling.lock.unlock.all.all";
    private static final String UNLOCK_METRICS_SUCCESS = "profiling.lock.unlock.all.success";
    private static final String UNLOCK_METRICS_FAIL = "profiling.lock.unlock.all.fail";
    private static final String UNLOCK_METRICS_SINGLE_ALL = "profiling.lock.unlock.single.all";
    private static final String UNLOCK_METRICS_SINGLE_SUCCESS = "profiling.lock.unlock.single.success";
    private static final String UNLOCK_METRICS_SINGLE_FAIL = "profiling.lock.unlock.single.fail";
    private static final String UNLOCK_METRICS_REENTRANT_LOCAL_ALL = "profiling.lock.unlock.reentrant-local.all";
    private static final Random RANDOM = new Random(System.currentTimeMillis());
    private static final ThreadLocal<Map<Object, LocalLockData>> localData = ThreadLocal.withInitial(HashMap::new);
    private static final ThreadLocal<String> threadUid = ThreadLocal.withInitial(() -> UUIDGenerator.generate((boolean)true).toString());

    public DistributedLock(DistributedLockManager lockManager, Object lockName, long lockPeriod, boolean reentrantLock) {
        this.lockPeriod = lockPeriod;
        this.lockName = lockName;
        this.reentrantLock = reentrantLock;
        String dir = LOCK_PATH + ZooPersistentLock.prepareLockName(lockName);
        this.zooLock = new ZooPersistentLock(lockManager.getClient(), dir);
        lockManager.initLock(lockName);
    }

    public DistributedLock(DistributedLockManager lockManager, Object lockName, boolean reentrantLock) {
        this(lockManager, lockName, 60000L, reentrantLock);
    }

    public static void init(ZooKeeperClient client, Object lockName) {
        String ln = ZooPersistentLock.prepareLockName(lockName);
        String dir = LOCK_PATH + ln;
        try {
            ZooPersistentLock.init(client, dir);
        }
        catch (InterruptedException | KeeperException e) {
            throw new DistributedException(e);
        }
    }

    public void close() {
        log.debug("close lock " + this.lockName + (this.reentrantLock ? " reentrant" : ""));
        try {
            this.zooLock.close();
        }
        catch (InterruptedException | KeeperException e) {
            throw new DistributedException(e);
        }
    }

    private long getValidUntil() {
        return System.currentTimeMillis() + this.lockPeriod;
    }

    public void lock() {
        try {
            if (!this.tryLock(0L, null, null, false).isSuccess()) {
                throw new IllegalStateException("logical error");
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new DistributedException(e);
        }
        catch (OperationInProgressException e) {
            throw new IllegalStateException("logical error", e);
        }
    }

    public void lockInterruptibly() throws InterruptedException {
        try {
            if (!this.tryLock(0L, null, null, false).isSuccess()) {
                throw new IllegalStateException("logical error");
            }
        }
        catch (OperationInProgressException e) {
            throw new IllegalStateException("logical error", e);
        }
    }

    public void trylockOrThrow(String operation) throws OperationInProgressException {
        try {
            if (!this.tryLock(0L, null, operation, true).isSuccess()) {
                throw new IllegalStateException("logical error");
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new DistributedException(e);
        }
    }

    public boolean tryLock() {
        try {
            return this.tryLock(1L, TimeUnit.SECONDS, null, false).isSuccess();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new DistributedException(e);
        }
        catch (OperationInProgressException e) {
            throw new IllegalStateException("logical error", e);
        }
    }

    public boolean tryLock(long time, TimeUnit unit) throws InterruptedException {
        Objects.requireNonNull(unit);
        try {
            return this.tryLock(time, unit, null, false).isSuccess();
        }
        catch (OperationInProgressException e) {
            throw new IllegalStateException("logical error", e);
        }
    }

    public void lockInterruptibly(String operation) throws InterruptedException {
        try {
            if (!this.tryLock(0L, null, operation, false).isSuccess()) {
                throw new IllegalStateException("logical error");
            }
        }
        catch (OperationInProgressException e) {
            throw new IllegalStateException("logical error", e);
        }
    }

    public boolean tryLock(String operation) {
        try {
            return this.tryLock(1L, TimeUnit.SECONDS, operation, false).isSuccess();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new DistributedException(e);
        }
        catch (OperationInProgressException e) {
            throw new IllegalStateException("logical error", e);
        }
    }

    public boolean tryLock(String operation, long time, TimeUnit unit) throws InterruptedException {
        Objects.requireNonNull(unit);
        try {
            return this.tryLock(time, unit, operation, false).isSuccess();
        }
        catch (OperationInProgressException e) {
            throw new IllegalStateException("logical error", e);
        }
    }

    /*
     * Exception decompiling
     */
    private ZooPersistentLock.LockResult tryLock(long time, TimeUnit unit, String operation, boolean checkInProgress) throws InterruptedException, OperationInProgressException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [31[UNCONDITIONALDOLOOP]], but top level block is 18[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private int localLock() {
        Map<Object, LocalLockData> map = localData.get();
        LocalLockData data = map.computeIfAbsent(this.lockName, k -> new LocalLockData());
        return ++data.lockCount;
    }

    private int localUnlock() {
        int lockCount;
        Map<Object, LocalLockData> map = localData.get();
        LocalLockData data = map.get(this.lockName);
        if (null == data) {
            return -1;
        }
        if ((lockCount = --data.lockCount) == 0) {
            map.remove(this.lockName);
        } else if (lockCount < 0) {
            throw new IllegalStateException("illegal lock count " + lockCount);
        }
        return lockCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unlock() {
        if (log.isDebugEnabled()) {
            log.debug("unlock " + this.lockName + (this.reentrantLock ? " reentrant" : ""));
        }
        Metrics.get().event(UNLOCK_METRICS_ALL);
        long startTimeInMillis = System.currentTimeMillis();
        boolean success = false;
        try {
            int lockCount;
            if (this.reentrantLock && (lockCount = this.localUnlock()) != -1) {
                if (log.isDebugEnabled()) {
                    log.debug("unlocked " + this.lockName + (this.reentrantLock ? " reentrant lockCount: " + (lockCount + 1) : ""));
                }
                success = true;
                Metrics.get().timingAndEvent(UNLOCK_METRICS_SUCCESS, startTimeInMillis);
                Metrics.get().timingAndEvent(UNLOCK_METRICS_REENTRANT_LOCAL_ALL, startTimeInMillis);
                return;
            }
            try {
                this.zooLock.unlock(false);
                if (log.isDebugEnabled()) {
                    log.debug("unlocked " + this.lockName + (this.reentrantLock ? " reentrant" : ""));
                }
                success = true;
                Metrics.get().timingAndEvent(UNLOCK_METRICS_SUCCESS, startTimeInMillis);
                Metrics.get().timingAndEvent(UNLOCK_METRICS_SINGLE_ALL, startTimeInMillis);
                Metrics.get().timingAndEvent(UNLOCK_METRICS_SINGLE_SUCCESS, startTimeInMillis);
            }
            catch (InterruptedException | KeeperException e) {
                throw new DistributedException(e);
            }
        }
        finally {
            Metrics.get().timing(UNLOCK_METRICS_ALL, startTimeInMillis);
            if (!success) {
                Metrics.get().timingAndEvent(UNLOCK_METRICS_FAIL, startTimeInMillis);
                Metrics.get().timingAndEvent(UNLOCK_METRICS_SINGLE_ALL, startTimeInMillis);
                Metrics.get().timingAndEvent(UNLOCK_METRICS_SINGLE_FAIL, startTimeInMillis);
            }
        }
    }

    public boolean isLocked() {
        try {
            return this.zooLock.isLocked();
        }
        catch (InterruptedException | KeeperException e) {
            throw new DistributedException(e);
        }
    }

    public Condition newCondition() {
        throw new UnsupportedOperationException();
    }

    public static void cleanExpiredLocks(ZooKeeperClient client) {
        try {
            ZooPersistentLock.cleanExpiredLocks(client, LOCK_PATH.substring(0, LOCK_PATH.length() - 1));
        }
        catch (InterruptedException | KeeperException e) {
            throw new DistributedException(e);
        }
    }

    public static List<LockStats.Lock> getLockList(ZooKeeperClient client) {
        try {
            return ZooPersistentLock.getLockList(client, LOCK_PATH.substring(0, LOCK_PATH.length() - 1));
        }
        catch (IOException | InterruptedException | KeeperException e) {
            throw new DistributedException(e);
        }
    }

    public Object getName() {
        return this.lockName;
    }

    private static String getUser() {
        return UserData.get().getCurrentUser();
    }

    private String getHost() {
        return Environment.getApplicationId();
    }

    private static String getThreadUid() {
        return threadUid.get();
    }

    protected static class LocalLockData {
        int lockCount;

        protected LocalLockData() {
        }
    }
}

