/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.lockmanager;

import com.gridnine.xtrip.common.Disposable;
import com.gridnine.xtrip.common.lockmanager.LockManager;
import com.gridnine.xtrip.common.lockmanager.LockMantaince;
import com.gridnine.xtrip.common.lockmanager.LockStats;
import com.gridnine.xtrip.common.lockmanager.NamedLock;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.configuration.ServerConfiguration;
import com.gridnine.xtrip.server.lockmanager.DistributedLock;
import com.gridnine.xtrip.server.lockmanager.ZooKeeperClient;
import com.gridnine.xtrip.server.lockmanager.ZooKeeperFactory;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.java.plugin.util.ExtendedProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DistributedLockManager
implements LockManager,
LockMantaince,
Disposable,
AutoCloseable {
    private static final Logger log = LoggerFactory.getLogger(DistributedLockManager.class);
    private static final String MAIN_ZOOKEEPER_URL_PROPERTY = "zookeeper.url";
    private static final String LOCAL_ZOOKEEPER_URL_PROPERTY = "lm.zookeeper.url";
    private final Map<Object, Object> inited = new ConcurrentHashMap<Object, Object>();
    protected volatile AtomicBoolean closed = new AtomicBoolean();
    private final Lock INITED_LOCK = new ReentrantLock();
    private final ZooKeeperClient client;

    private static String getURL() {
        ExtendedProperties properties = ServerConfiguration.get().getConfiguration();
        String url = properties.getProperty(LOCAL_ZOOKEEPER_URL_PROPERTY);
        if (url != null) {
            return url;
        }
        return properties.getProperty(MAIN_ZOOKEEPER_URL_PROPERTY);
    }

    public DistributedLockManager() {
        this(DistributedLockManager.getURL());
    }

    public DistributedLockManager(String url) {
        if (TextUtil.isBlank((String)url)) {
            throw new IllegalArgumentException("url not specified");
        }
        log.info("initialize lock manager at " + url);
        this.client = ZooKeeperFactory.getInstance(url);
        log.info("lock manager connected to " + url);
    }

    @Override
    public void close() {
        if (this.closed.getAndSet(true)) {
            return;
        }
        log.info("dispose lock manager at " + this.client.getUrl());
        ZooKeeperFactory.release(this.client);
        log.info("lock manager closed");
    }

    public void dispose() {
        this.close();
    }

    public ZooKeeperClient getClient() {
        return this.client;
    }

    protected void initLock(Object lockName) {
        if (this.inited.get(lockName) != null) {
            return;
        }
        Lock lock = this.INITED_LOCK;
        lock.lock();
        try {
            if (this.inited.get(lockName) != null) {
                return;
            }
            DistributedLock.init(this.client, lockName);
            this.inited.put(lockName, lockName);
        }
        finally {
            lock.unlock();
        }
    }

    public void cleanExpiredLocks() {
        this.inited.clear();
        DistributedLock.cleanExpiredLocks(this.client);
    }

    public NamedLock getLock(Object lockName) {
        return new DistributedLock(this, lockName, true);
    }

    public NamedLock getLock(Object lockName, long lockPeriod) {
        return new DistributedLock(this, lockName, lockPeriod, true);
    }

    public LockStats getStats() {
        LockStats result = new LockStats();
        result.getLockList().addAll(DistributedLock.getLockList(this.client));
        return result;
    }
}

