/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.lockmanager;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.lockmanager.LockManager;
import com.gridnine.xtrip.common.lockmanager.LockUtil;
import com.gridnine.xtrip.common.lockmanager.NamedLock;
import com.gridnine.xtrip.common.util.ValueHolder;
import com.gridnine.xtrip.server.configuration.ServerConfiguration;
import com.gridnine.xtrip.server.lockmanager.DistributedLockManager;
import com.gridnine.xtrip.server.lockmanager.DistributedLockManagerFactory;
import com.gridnine.xtrip.server.lockmanager.LockManagerPublisher;
import com.gridnine.xtrip.server.lockmanager.ZookepperTestBase;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.TimeUnit;
import org.java.plugin.util.ExtendedProperties;
import org.junit.Assert;
import org.junit.Test;

public class DistributedLockTest
extends ZookepperTestBase {
    private static final String LOCK_NAME = "some_lock";

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.publishServerConfiguration();
        new LockManagerPublisher().publish(new DistributedLockManagerFactory());
    }

    private void populateServerConfiguration(ExtendedProperties serverConfiguration) {
        serverConfiguration.put((Object)"cluster", (Object)"true");
        serverConfiguration.put((Object)"zookeeper.url", (Object)"localhost:2182");
    }

    private void publishServerConfiguration() {
        ExtendedProperties serverConfiguration = new ExtendedProperties();
        this.populateServerConfiguration(serverConfiguration);
        Environment.publish(ServerConfiguration.class, (Object)new ServerConfiguration(serverConfiguration));
    }

    @Test
    public void testReentrantLock() throws Throwable {
        CyclicBarrier barrier = new CyclicBarrier(2);
        ValueHolder error = new ValueHolder();
        Thread t1 = new Thread(() -> {
            try {
                try {
                    if (this.tryReentrantLock(LOCK_NAME)) {
                        Assert.fail((String)"can lock");
                    }
                    barrier.await();
                    this.underReentrantLock(LOCK_NAME, () -> this.underReentrantLock(LOCK_NAME, () -> {
                        try {
                            if (!this.tryReentrantLock(LOCK_NAME)) {
                                Assert.fail((String)"can lock");
                            }
                            barrier.await();
                            barrier.await();
                        }
                        catch (Exception e) {
                            Assert.fail((String)("an unexpected error has occurred: " + e.getMessage()));
                        }
                    }));
                }
                catch (AssertionError t) {
                    throw t;
                }
                catch (Throwable e) {
                    Assert.fail((String)("unexpected error has occurred: " + e.getMessage()));
                }
            }
            catch (AssertionError t) {
                error.setValue((Object)t);
                try {
                    barrier.await();
                }
                catch (Exception e) {
                    Assert.fail((String)("an unexpected error has occurred: " + e.getMessage()));
                }
            }
        });
        if (!this.tryReentrantLock(LOCK_NAME)) {
            Assert.fail((String)"can't lock");
        }
        this.underReentrantLock(LOCK_NAME, () -> {
            t1.start();
            try {
                barrier.await();
            }
            catch (Exception e) {
                Assert.fail((String)("an unexpected error has occurred: " + e.getMessage()));
            }
        });
        if (error.getValue() != null) {
            throw (AssertionError)error.getValue();
        }
        barrier.await();
        if (error.getValue() != null) {
            throw (AssertionError)error.getValue();
        }
        if (this.tryReentrantLock(LOCK_NAME)) {
            Assert.fail((String)"can lock");
        }
        barrier.await();
        t1.join();
        if (error.getValue() != null) {
            throw (AssertionError)error.getValue();
        }
    }

    @Test
    public void testCuncurrentReentrantLock() throws Throwable {
        CyclicBarrier barrier = new CyclicBarrier(2);
        ValueHolder error = new ValueHolder();
        Thread t1 = new Thread(() -> {
            try (DistributedLockManager dlm = new DistributedLockManager("127.0.0.1:2182");){
                barrier.await();
                this.underReentrantTryLock(dlm, LOCK_NAME, () -> {});
            }
            catch (Throwable t) {
                error.setValue((Object)t);
            }
        }, "=another-thread=");
        this.underReentrantTryLock(LOCK_NAME, () -> {
            try {
                t1.start();
                barrier.await();
                Thread.sleep(1000L);
                if (!this.tryReentrantLock(LOCK_NAME)) {
                    Assert.fail((String)"can't lock");
                }
            }
            catch (Exception e) {
                Assert.fail((String)("an unexpected error has occurred: " + e.getMessage()));
            }
        });
        t1.join();
        if (error.getValue() != null) {
            throw (Throwable)error.getValue();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean tryReentrantLock(Object lockName) throws Exception {
        try (NamedLock lock = LockUtil.getLockManager().getLock(lockName);){
            if (!lock.tryLock()) {
                boolean bl = false;
                return bl;
            }
            lock.unlock();
            boolean bl = true;
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void underReentrantLock(Object lockName, Body body) throws Throwable {
        try (NamedLock lock = LockUtil.getLockManager().getLock(lockName);){
            lock.lock();
            try {
                body.run();
            }
            finally {
                lock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void underReentrantTryLock(Object lockName, Body body) throws Throwable {
        block6: {
            try (NamedLock lock = LockUtil.getLockManager().getLock(lockName);){
                if (!lock.tryLock(1L, TimeUnit.MINUTES)) break block6;
                try {
                    body.run();
                }
                finally {
                    lock.unlock();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void underReentrantTryLock(LockManager lm, Object lockName, Body body) throws Throwable {
        block6: {
            try (NamedLock lock = lm.getLock(lockName);){
                if (!lock.tryLock(1L, TimeUnit.MINUTES)) break block6;
                try {
                    body.run();
                }
                finally {
                    lock.unlock();
                }
            }
        }
    }

    @FunctionalInterface
    protected static interface Body {
        public void run() throws Throwable;
    }
}

