/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.lockmanager;

import com.gridnine.xtrip.common.lockmanager.OperationInProgressException;
import com.gridnine.xtrip.common.user.UserData;
import com.gridnine.xtrip.common.util.UUIDGenerator;
import com.gridnine.xtrip.server.lockmanager.LocalLockManager;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalLock {
    private static final Logger log = LoggerFactory.getLogger(LocalLock.class);
    private final ReentrantLock LOCK = new ReentrantLock();
    private final AtomicBoolean closed = new AtomicBoolean();
    private Object owner = null;
    private String locked = null;
    private long exparedTime = 0L;
    private int lockCount = 0;
    private String lockUser = null;
    private String lockOperation = null;
    private long lockThreadId;
    private static final int TRY_TIMEOUT = 100;
    private final Object lockName;
    private final LocalLockManager manager;
    private final ConcurrentHashMap<Object, Object> linkCount = new ConcurrentHashMap();
    private final ThreadLocal<String> threadUid = ThreadLocal.withInitial(() -> UUIDGenerator.generate((boolean)true).toString());

    public LocalLock(Object lockName, LocalLockManager manager) {
        this.lockName = lockName;
        this.manager = manager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void tryLock(Object object, long time, TimeUnit unit, long lockPeriod, String operation, boolean reentrantLock) throws OperationInProgressException, InterruptedException {
        if (LocalLock.log.isDebugEnabled()) {
            LocalLock.log.debug((unit != null ? "try" : "begin") + " lock " + this.lockName + (reentrantLock != false ? " reentrant" : ""));
        }
        this.checkClosed();
        start = System.currentTimeMillis();
        before = time != -1L && unit != null ? start + unit.toMillis(time) : 0x7FFFFFFFFFFFFFFFL;
        lockSuccess = false;
        while (true) {
            block18: {
                block17: {
                    block16: {
                        try {
                            lock = this.LOCK;
                            lock.lock();
                            if (null == this.locked) {
                                this.owner = object;
                                this.locked = this.getThreadUid();
                                this.exparedTime = System.currentTimeMillis() + lockPeriod;
                                ++this.lockCount;
                                this.lockUser = this.getUser();
                                this.lockOperation = operation != null ? operation : Thread.currentThread().getName();
                                this.lockThreadId = Thread.currentThread().getId();
                                lockSuccess = true;
                                this.LOCK.unlock();
                                break block16;
                            }
                            ** GOTO lbl-1000
                        }
                        catch (Throwable var16_12) {
                            if (LocalLock.log.isDebugEnabled() == false) throw var16_12;
                            if (lockSuccess || this.lockCount != 0) {
                                LocalLock.log.debug("locked " + this.lockName + (reentrantLock != false ? " reentrant" + (this.lockCount != 0 ? " lockCount: " + this.lockCount : "") : "") + (this.lockUser != null ? " user: " + this.lockUser : "") + (this.lockOperation != null ? " operation: " + this.lockOperation : ""));
                                throw var16_12;
                            }
                            LocalLock.log.debug("lock failed for " + this.lockName + (reentrantLock != false ? " reentrant" : "") + (this.lockUser != null ? " user: " + this.lockUser : "") + (this.lockOperation != null ? " operation: " + this.lockOperation : ""));
                            throw var16_12;
                        }
                    }
                    if (LocalLock.log.isDebugEnabled() == false) return;
                    if (lockSuccess || this.lockCount != 0) {
                        LocalLock.log.debug("locked " + this.lockName + (reentrantLock != false ? " reentrant" + (this.lockCount != 0 ? " lockCount: " + this.lockCount : "") : "") + (this.lockUser != null ? " user: " + this.lockUser : "") + (this.lockOperation != null ? " operation: " + this.lockOperation : ""));
                        return;
                    }
                    LocalLock.log.debug("lock failed for " + this.lockName + (reentrantLock != false ? " reentrant" : "") + (this.lockUser != null ? " user: " + this.lockUser : "") + (this.lockOperation != null ? " operation: " + this.lockOperation : ""));
                    return;
lbl-1000:
                    // 1 sources

                    {
                        if (!reentrantLock || !this.getThreadUid().equals(this.locked)) break block17;
                        ++this.lockCount;
                        lockSuccess = true;
                        this.LOCK.unlock();
                    }
                    if (LocalLock.log.isDebugEnabled() == false) return;
                    if (lockSuccess || this.lockCount != 0) {
                        LocalLock.log.debug("locked " + this.lockName + (reentrantLock != false ? " reentrant" + (this.lockCount != 0 ? " lockCount: " + this.lockCount : "") : "") + (this.lockUser != null ? " user: " + this.lockUser : "") + (this.lockOperation != null ? " operation: " + this.lockOperation : ""));
                        return;
                    }
                    LocalLock.log.debug("lock failed for " + this.lockName + (reentrantLock != false ? " reentrant" : "") + (this.lockUser != null ? " user: " + this.lockUser : "") + (this.lockOperation != null ? " operation: " + this.lockOperation : ""));
                    return;
                }
                ** try [egrp 5[TRYBLOCK] [2 : 882->911)] { 
lbl52:
                // 1 sources

                if (System.currentTimeMillis() + 100L >= before) {
                    throw new OperationInProgressException(this.lockUser, this.lockOperation);
                }
                break block18;
lbl55:
                // 1 sources

                finally {
                    this.LOCK.unlock();
                }
            }
            Thread.sleep(100L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unlock(boolean reentrantLock) {
        if (log.isDebugEnabled()) {
            log.debug("unlock " + this.lockName + (reentrantLock ? " reentrant" : "") + (this.lockUser != null ? " user: " + this.lockUser : "") + (this.lockOperation != null ? " operation: " + this.lockOperation : ""));
        }
        this.checkClosed();
        ReentrantLock lock = this.LOCK;
        lock.lock();
        try {
            if (reentrantLock && this.getThreadUid() == this.locked) {
                --this.lockCount;
                if (this.lockCount < 0) {
                    throw new IllegalStateException("illegal reentrant lock count");
                }
                if (this.lockCount > 0) {
                    if (log.isDebugEnabled()) {
                        log.debug("unlocked " + this.lockName + (reentrantLock ? " reentrant lockCount: " + (this.lockCount + 1) : "") + (this.lockUser != null ? " user: " + this.lockUser : "") + (this.lockOperation != null ? " operation: " + this.lockOperation : ""));
                    }
                    return;
                }
            }
            String user = this.lockUser;
            String operation = this.lockOperation;
            this.owner = null;
            this.locked = null;
            this.exparedTime = 0L;
            this.lockCount = 0;
            this.lockUser = null;
            this.lockOperation = null;
            this.lockThreadId = -1L;
            if (log.isDebugEnabled()) {
                log.debug("unlocked " + this.lockName + (reentrantLock ? " reentrant" : "") + (user != null ? " user: " + user : "") + (operation != null ? " operation: " + operation : ""));
            }
        }
        finally {
            this.LOCK.unlock();
        }
    }

    public boolean isLocked() {
        this.checkClosed();
        ReentrantLock lock = this.LOCK;
        lock.lock();
        try {
            boolean bl = this.locked != null && this.linkCount.containsKey(this.owner) || this.exparedTime >= System.currentTimeMillis();
            return bl;
        }
        finally {
            this.LOCK.unlock();
        }
    }

    public boolean isValid() {
        ReentrantLock lock = this.LOCK;
        lock.lock();
        try {
            boolean bl = !this.linkCount.isEmpty() || this.exparedTime >= System.currentTimeMillis();
            return bl;
        }
        finally {
            this.LOCK.unlock();
        }
    }

    private void checkClosed() {
        if (this.closed.get()) {
            throw new IllegalStateException("lock utilized");
        }
    }

    public Object getName() {
        return this.lockName;
    }

    public void link(Object object) {
        this.linkCount.put(object, Boolean.TRUE);
    }

    public void unlink(Object object) {
        if (this.linkCount.remove(object) == null) {
            throw new IllegalStateException("illegal link count");
        }
        this.manager.utilize(this.lockName);
    }

    public void close() {
        log.debug("close lock " + this.lockName);
        this.closed.set(true);
    }

    public String getOperation() {
        return this.lockOperation;
    }

    public long getExpire() {
        return this.exparedTime;
    }

    public long getLockThreadId() {
        return this.lockThreadId;
    }

    protected String getLockUser() {
        return this.lockUser;
    }

    private String getUser() {
        return UserData.get().getCurrentUser();
    }

    private String getThreadUid() {
        return this.threadUid.get();
    }
}

