/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.lockmanager;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.lockmanager.LockManager;
import com.gridnine.xtrip.common.lockmanager.LockMantaince;
import com.gridnine.xtrip.common.lockmanager.LockStats;
import com.gridnine.xtrip.common.lockmanager.NamedLock;
import com.gridnine.xtrip.server.lockmanager.LocalLock;
import com.gridnine.xtrip.server.lockmanager.LocalNamedLock;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class LocalLockManager
implements LockManager,
LockMantaince {
    private final Lock LIST_LOCK = new ReentrantLock();
    private final Map<Object, LocalLock> lockList = new HashMap<Object, LocalLock>();

    public NamedLock getLock(Object name) {
        return this.getLock(name, 60000L, true);
    }

    public NamedLock getLock(Object name, long lockPeriod) {
        return this.getLock(name, lockPeriod, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private NamedLock getLock(Object name, long lockPeriod, boolean reentrantLock) {
        Lock lock = this.LIST_LOCK;
        lock.lock();
        try {
            LocalLock localLock = this.lockList.get(name);
            if (null == localLock) {
                localLock = new LocalLock(name, this);
                this.lockList.put(name, localLock);
            }
            LocalNamedLock localNamedLock = new LocalNamedLock(localLock, lockPeriod, reentrantLock);
            return localNamedLock;
        }
        finally {
            lock.unlock();
        }
    }

    private void checkLock(LocalLock lock) {
        if (lock.isValid()) {
            return;
        }
        this.lockList.remove(lock.getName());
        lock.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanExpiredLocks() {
        Lock lock = this.LIST_LOCK;
        lock.lock();
        try {
            for (LocalLock localLock : new ArrayList<LocalLock>(this.lockList.values())) {
                this.checkLock(localLock);
            }
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void utilize(Object name) {
        Lock lock = this.LIST_LOCK;
        lock.lock();
        try {
            LocalLock localLock = this.lockList.get(name);
            if (localLock != null) {
                this.checkLock(localLock);
            }
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LockStats getStats() {
        LockStats result = new LockStats();
        Lock lock = this.LIST_LOCK;
        lock.lock();
        try {
            String host = Environment.getApplicationId();
            List list = result.getLockList();
            this.lockList.values().stream().map(l -> l.isLocked() ? new LockStats.Lock(String.valueOf(l.getName()), l.getExpire() > 0L ? new Date(l.getExpire()) : null, l.getLockUser(), host, l.getOperation(), Long.valueOf(l.getLockThreadId())) : new LockStats.Lock(String.valueOf(l.getName()), null, null, null, null, null)).filter(Objects::nonNull).forEach(list::add);
        }
        finally {
            lock.unlock();
        }
        return result;
    }
}

