/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.lockmanager;

import com.gridnine.xtrip.common.lockmanager.LockUtil;
import com.gridnine.xtrip.common.lockmanager.NamedLock;
import com.gridnine.xtrip.common.test.TestBase;
import com.gridnine.xtrip.common.util.ValueHolder;
import com.gridnine.xtrip.server.lockmanager.LockManagerPublisher;
import java.util.concurrent.CyclicBarrier;
import org.junit.Assert;
import org.junit.Test;

public class LocalLockTest
extends TestBase {
    private static final String LOCK_NAME = "some_lock";

    public void setUp() throws Exception {
        super.setUp();
        new LockManagerPublisher().publish();
    }

    @Test
    public void testReentrantLock() throws Exception {
        final CyclicBarrier barrier = new CyclicBarrier(2);
        final ValueHolder error = new ValueHolder();
        final Thread t1 = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    try {
                        if (LocalLockTest.this.tryLock(true, LocalLockTest.LOCK_NAME)) {
                            Assert.fail((String)"can lock");
                        }
                        barrier.await();
                        LocalLockTest.this.underLock(true, LocalLockTest.LOCK_NAME, new Runnable(){

                            @Override
                            public void run() {
                                try {
                                    LocalLockTest.this.underLock(true, LocalLockTest.LOCK_NAME, new Runnable(){

                                        @Override
                                        public void run() {
                                            try {
                                                barrier.await();
                                                barrier.await();
                                            }
                                            catch (Exception e) {
                                                Assert.fail((String)("an unexpected error has occurred: " + e.getMessage()));
                                            }
                                        }
                                    });
                                }
                                catch (Exception e) {
                                    throw new RuntimeException(e);
                                }
                            }
                        });
                    }
                    catch (AssertionError t) {
                        throw t;
                    }
                    catch (Exception e) {
                        Assert.fail((String)("an unexpected error has occurred: " + e.getMessage()));
                    }
                }
                catch (AssertionError t) {
                    error.setValue((Object)t);
                    try {
                        barrier.await();
                    }
                    catch (Exception e) {
                        Assert.fail((String)("an unexpected error has occurred: " + e.getMessage()));
                    }
                }
            }
        });
        if (!this.tryLock(true, LOCK_NAME)) {
            Assert.fail((String)"can't lock");
        }
        this.underLock(true, LOCK_NAME, new Runnable(){

            @Override
            public void run() {
                t1.start();
                try {
                    barrier.await();
                }
                catch (Exception e) {
                    Assert.fail((String)("an unexpected error has occurred: " + e.getMessage()));
                }
            }
        });
        if (error.getValue() != null) {
            throw (AssertionError)error.getValue();
        }
        barrier.await();
        if (error.getValue() != null) {
            throw (AssertionError)error.getValue();
        }
        if (this.tryLock(true, LOCK_NAME)) {
            Assert.fail((String)"can lock");
        }
        barrier.await();
        t1.join();
        if (error.getValue() != null) {
            throw (AssertionError)error.getValue();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean tryLock(boolean reentrant, Object lockName) throws Exception {
        Assert.assertTrue((boolean)reentrant);
        try (NamedLock lock = LockUtil.getLockManager().getLock(lockName);){
            if (!lock.tryLock()) {
                boolean bl = false;
                return bl;
            }
            lock.unlock();
            boolean bl = true;
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void underLock(boolean reentrant, Object lockName, Runnable body) throws Exception {
        Assert.assertTrue((boolean)reentrant);
        try (NamedLock lock = LockUtil.getLockManager().getLock(lockName);){
            lock.lock();
            try {
                body.run();
            }
            finally {
                lock.unlock();
            }
        }
    }
}

