/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.lockmanager;

import com.gridnine.xtrip.common.lockmanager.NamedLock;
import com.gridnine.xtrip.common.lockmanager.OperationInProgressException;
import com.gridnine.xtrip.server.lockmanager.LocalLock;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Condition;

public class LocalNamedLock
implements NamedLock {
    private final LocalLock localLock;
    private final long lockPeriod;
    private final boolean reentrantLock;
    private final AtomicBoolean closed = new AtomicBoolean();

    public LocalNamedLock(LocalLock localLock, long lockPeriod, boolean reentrantLock) {
        this.localLock = localLock;
        this.lockPeriod = lockPeriod;
        this.reentrantLock = reentrantLock;
        localLock.link(this);
    }

    protected void checkClosed() {
        if (this.closed.get()) {
            throw new IllegalStateException("closed");
        }
    }

    public void lock() {
        this.checkClosed();
        boolean interrupted = false;
        while (true) {
            try {
                this.localLock.tryLock(this, -1L, null, this.lockPeriod, null, this.reentrantLock);
            }
            catch (OperationInProgressException operationInProgressException) {
                continue;
            }
            catch (InterruptedException e) {
                interrupted = true;
                continue;
            }
            break;
        }
        if (interrupted) {
            Thread.currentThread().interrupt();
        }
    }

    public void trylockOrThrow(String operation) throws OperationInProgressException {
        this.checkClosed();
        boolean interrupted = false;
        while (true) {
            try {
                this.localLock.tryLock(this, 0L, TimeUnit.MILLISECONDS, this.lockPeriod, operation, this.reentrantLock);
            }
            catch (InterruptedException e) {
                interrupted = true;
                continue;
            }
            break;
        }
        if (interrupted) {
            Thread.currentThread().interrupt();
        }
    }

    public void lockInterruptibly() throws InterruptedException {
        this.lockInterruptibly(null);
    }

    public boolean tryLock() {
        return this.tryLock(null);
    }

    public boolean tryLock(long time, TimeUnit unit) throws InterruptedException {
        return this.tryLock(null, time, unit);
    }

    public void lockInterruptibly(String operation) throws InterruptedException {
        this.checkClosed();
        while (!this.tryLock(operation)) {
            Thread.sleep(100L);
        }
    }

    public boolean tryLock(String operation) {
        this.checkClosed();
        try {
            this.localLock.tryLock(this, 0L, TimeUnit.MILLISECONDS, this.lockPeriod, operation, this.reentrantLock);
            return true;
        }
        catch (OperationInProgressException e) {
            return false;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return false;
        }
    }

    public boolean tryLock(String operation, long time, TimeUnit unit) throws InterruptedException {
        this.checkClosed();
        try {
            this.localLock.tryLock(this, time, unit, this.lockPeriod, operation, this.reentrantLock);
            return true;
        }
        catch (OperationInProgressException e) {
            return false;
        }
    }

    public void unlock() {
        this.checkClosed();
        this.localLock.unlock(this.reentrantLock);
    }

    public boolean isLocked() {
        this.checkClosed();
        return this.localLock.isLocked();
    }

    public Condition newCondition() {
        throw new UnsupportedOperationException();
    }

    public void close() {
        if (!this.closed.getAndSet(true)) {
            this.localLock.unlink(this);
        }
    }

    public Object getName() {
        return this.localLock.getName();
    }
}

