/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.lockmanager;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.Publisher;
import com.gridnine.xtrip.common.lockmanager.LockManager;
import com.gridnine.xtrip.common.lockmanager.LockMantaince;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.lockmanager.LocalLockManager;
import com.gridnine.xtrip.server.lockmanager.LockManagerFactory;

public class LockManagerPublisher
implements Publisher {
    public void publish() throws Exception {
        LockManagerFactory factory = this.getLockManagerFactory();
        if (factory != null && this.publish(factory)) {
            return;
        }
        String className = System.getProperty(LockManager.class.getName() + ".className");
        LockManager object = TextUtil.isBlank((String)className) ? this.getDefault() : (LockManager)Class.forName(className).newInstance();
        this.publish(object);
    }

    private void publish(LockManager object) throws Exception {
        Environment.publish(LockManager.class, (Object)object);
        Environment.publish(LockMantaince.class, (Object)((LockMantaince)object));
    }

    public boolean publish(LockManagerFactory factory) throws Exception {
        LockManager object = factory.getLockManager();
        if (null == object) {
            return false;
        }
        this.publish(object);
        return true;
    }

    private LockManagerFactory getLockManagerFactory() throws Exception {
        String className = System.getProperty(LockManagerFactory.class.getName() + ".className");
        return !TextUtil.isBlank((String)className) ? (LockManagerFactory)Class.forName(className).newInstance() : null;
    }

    private LockManager getDefault() {
        return new LocalLockManager();
    }
}

