/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.lockmanager;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.server.metrics.Metrics;
import java.io.IOException;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.Enumeration;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.zookeeper.AsyncCallback;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.data.ACL;
import org.apache.zookeeper.data.Stat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZooKeeperClient
implements AutoCloseable {
    protected static final Logger log = LoggerFactory.getLogger(ZooKeeperClient.class);
    private static final int DEFAULT_SESSION_TIMEOUT = 30000;
    private final String url;
    private final int sessionTimeout;
    private volatile ZooKeeper zooKeeper;
    private final Lock CREATE_ZOO_LOCK = new ReentrantLock();
    private static final int PING_TIMEOUT = 300000;
    private final Pinger pinger;
    protected final AtomicBoolean closed = new AtomicBoolean();
    private static final long RETRY_DELAY = 50L;
    private static final int RETRY_COUNT = 10;
    private static final int CONNECTION_LOST_ATTEMPT = 10;
    private static final long CONNECTION_LOST_RECONNECT_TIMEOUT = 1000L;
    private static final long DEFAULT_SYNC_TIMEOUT = 5000L;
    private static final String METRICS = "profiling.zookeeper";
    private static final String SUCCESS_METRICS = "profiling.zookeeper.%s.success";
    private static final String FAIL_METRICS = "profiling.zookeeper.%s.fail";
    private static final String OPERATION_METRICS = "operation.";

    public ZooKeeperClient(String url) {
        this(url, 30000);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ZooKeeperClient(String url, int sessionTimeout) {
        this.url = url;
        this.sessionTimeout = sessionTimeout;
        boolean connected = false;
        try {
            this.createZooKeeper();
            connected = true;
        }
        finally {
            if (!connected) {
                ZooKeeper newZoo = this.zooKeeper;
                this.zooKeeper = null;
                try {
                    newZoo.close();
                }
                catch (Throwable t) {
                    log.error("an unexpected error has occurred", t);
                }
            }
        }
        this.pinger = new Pinger("zookeeper-client-pinger-" + url);
        this.pinger.start();
    }

    public String getUrl() {
        return this.url;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        if (this.closed.getAndSet(true)) {
            return;
        }
        log.info("dispose zoo client at " + this.url);
        boolean interrupted = false;
        try {
            this.pinger.interrupt();
            try {
                this.pinger.join();
            }
            catch (InterruptedException e) {
                interrupted = true;
            }
            Lock createLock = this.CREATE_ZOO_LOCK;
            createLock.lock();
            try {
                ZooKeeper zoo = this.zooKeeper;
                this.zooKeeper = null;
                if (zoo != null) {
                    try {
                        zoo.close();
                    }
                    catch (InterruptedException e) {
                        interrupted = true;
                    }
                }
            }
            finally {
                createLock.unlock();
            }
        }
        finally {
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }

    protected void checkClosed() {
        if (this.closed.get()) {
            throw new IllegalStateException("closed");
        }
    }

    protected ZooKeeperFacade getZooKeeper() {
        ZooKeeper zoo = this.zooKeeper;
        if (null == zoo) {
            this.checkClosed();
            throw new IllegalStateException("internal critical error: ZooKeeper not initialized!");
        }
        return new ZooKeeperFacade(zoo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void createZooKeeper() {
        Lock createLock = this.CREATE_ZOO_LOCK;
        createLock.lock();
        try {
            ZooKeeper zoo = this.zooKeeper;
            log.info("connecting to " + this.url + "...");
            ReentrantLock startLock = new ReentrantLock();
            startLock.lock();
            try {
                Condition startCondition = startLock.newCondition();
                try {
                    this.zooKeeper = new ZooKeeper(this.url, this.sessionTimeout, (Watcher)new ZooKeeperStartWatcher(this.url, startLock, startCondition));
                }
                catch (IOException e) {
                    log.error("unable to create connection to ZooKeeper, url " + this.url + "!", (Throwable)e);
                    throw Xeption.forDeveloper((String)"unable to create connection to ZooKeeper", (Throwable)e, (Object[])new Object[0]);
                }
                if (zoo != null) {
                    try {
                        zoo.close();
                    }
                    catch (Throwable t) {
                        log.error("an unexpected error has occurred", t);
                    }
                }
                int i = 60;
                while (true) {
                    InterruptedException interrupted = null;
                    try {
                        if (startCondition.await(5L, TimeUnit.SECONDS)) {
                            break;
                        }
                    }
                    catch (InterruptedException e) {
                        interrupted = e;
                    }
                    if (--i <= 0 || interrupted != null) {
                        this.zooKeeper.register((Watcher)new ZooKeeperWatcher(this.url));
                        if (interrupted != null) {
                            log.error("connecting to ZooKeeper interrupted, url " + this.url + "!", (Throwable)interrupted);
                            throw Xeption.forDeveloper((String)"connecting to ZooKeeper interrupted", (Throwable)interrupted, (Object[])new Object[0]);
                        }
                        log.error("no connection to ZooKeeper, url " + this.url + "!");
                        throw Xeption.forDeveloper((String)"no connection to ZooKeeper", (Object[])new Object[0]);
                    }
                    log.warn("still connecting to " + this.url + "...");
                }
                this.zooKeeper.register((Watcher)new ZooKeeperWatcher(this.url));
                log.info("connected to " + this.url);
            }
            finally {
                startLock.unlock();
            }
        }
        finally {
            createLock.unlock();
        }
    }

    protected void reconnect() {
        log.warn("needed reconnect to " + this.url + "...");
        this.createZooKeeper();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkReconnect() {
        Lock createLock = this.CREATE_ZOO_LOCK;
        createLock.lock();
        try {
            this.checkClosed();
            ZooKeeperFacade zoo = this.getZooKeeper();
            ZooKeeper.States state = zoo.getState();
            if (state.isAlive() && state.isConnected()) {
                return;
            }
            this.reconnect();
        }
        finally {
            createLock.unlock();
        }
    }

    protected void execute(Operation operation) throws KeeperException, InterruptedException {
        this.execute(() -> {
            operation.execute();
            return null;
        });
    }

    protected <T> T execute(OperationWithResult<T> operation) throws KeeperException, InterruptedException {
        return (T)this.executeSafe(() -> this.executeUnsafe(operation));
    }

    protected <T> T executeUnsafe(OperationWithResult<T> operation) throws KeeperException, InterruptedException {
        long startTimeInMillis = System.currentTimeMillis();
        try {
            return operation.execute();
        }
        catch (KeeperException.SessionExpiredException e) {
            ZooKeeperClient.failEvent("session-expired", startTimeInMillis);
            throw e;
        }
        catch (KeeperException.ConnectionLossException e) {
            ZooKeeperClient.failEvent("connection-loss", startTimeInMillis);
            throw e;
        }
    }

    public <T> T executeSafe(OperationWithResult<T> unsafe) throws KeeperException, InterruptedException {
        int connectionLostAttempt = 10;
        while (true) {
            try {
                int i = 0;
                while (true) {
                    try {
                        return unsafe.execute();
                    }
                    catch (KeeperException.ConnectionLossException e) {
                        log.warn("attempt " + i + " failed with connection loss so attempting to reconnect", (Throwable)e);
                        if (i++ >= 10) {
                            throw e;
                        }
                        Thread.sleep((long)i * 50L);
                        continue;
                    }
                    break;
                }
            }
            catch (KeeperException.ConnectionLossException | KeeperException.SessionExpiredException e) {
                if (connectionLostAttempt > 0) {
                    log.warn(e instanceof KeeperException.SessionExpiredException ? "ZooKeeper session expired" : "ZooKeeper connection lost", e);
                    this.checkReconnect();
                    Thread.sleep(1000L * (long)(10 - --connectionLostAttempt));
                    continue;
                }
                ZooKeeperClient.failEvent("session-lost!");
                log.error("ZooKeeper session lost!", e);
                throw e;
            }
            break;
        }
    }

    protected static void successEvent(String event, long startTimeInMillis) {
        ZooKeeperClient.event(String.format(SUCCESS_METRICS, "all"), event, startTimeInMillis);
        ZooKeeperClient.event(String.format(SUCCESS_METRICS, ZooKeeperClient.getHost()), event, startTimeInMillis);
    }

    protected static void successEvent(String event) {
        ZooKeeperClient.event(String.format(SUCCESS_METRICS, "all"), event);
        ZooKeeperClient.event(String.format(SUCCESS_METRICS, ZooKeeperClient.getHost()), event);
    }

    protected static void failEvent(String event, long startTimeInMillis) {
        ZooKeeperClient.event(String.format(FAIL_METRICS, "all"), event, startTimeInMillis);
        ZooKeeperClient.event(String.format(FAIL_METRICS, ZooKeeperClient.getHost()), event, startTimeInMillis);
    }

    protected static void failEvent(String event) {
        ZooKeeperClient.event(String.format(FAIL_METRICS, "all"), event);
        ZooKeeperClient.event(String.format(FAIL_METRICS, ZooKeeperClient.getHost()), event);
    }

    protected static void event(String target, String event) {
        Metrics.get().event(target + ".all");
        Metrics.get().event(target + "." + event);
    }

    protected static void event(String target, String event, long startTimeInMillis) {
        Metrics.get().event(target + ".all");
        Metrics.get().timingAndEvent(target + "." + event, startTimeInMillis);
    }

    private static String getHost() {
        return LazyHolder.HOST;
    }

    public List<String> getChildren(String path) throws KeeperException, InterruptedException {
        return this.execute(() -> this.getZooKeeper().getChildren(path, false));
    }

    public int getChildCount(String path) throws KeeperException, InterruptedException {
        return this.execute(() -> {
            Stat stat = this.getZooKeeper().exists(path, false);
            return stat != null ? stat.getNumChildren() : 0;
        });
    }

    public boolean hasChildren(String path) throws KeeperException, InterruptedException {
        return this.getChildCount(path) > 0;
    }

    public boolean exists(String path) throws KeeperException, InterruptedException {
        return this.execute(() -> this.getZooKeeper().exists(path, false) != null);
    }

    public boolean exists(String path, boolean watch) throws KeeperException, InterruptedException {
        return this.execute(() -> this.getZooKeeper().exists(path, watch) != null);
    }

    public void delete(String path) throws KeeperException, InterruptedException {
        this.execute(() -> this.getZooKeeper().delete(path, -1));
    }

    public byte[] getData(String path) throws KeeperException, InterruptedException {
        return this.execute(() -> this.getZooKeeper().getData(path, false, new Stat()));
    }

    public long getSessionId() {
        return this.getZooKeeper().getSessionId();
    }

    public String create(String string, byte[] data, List<ACL> openAclUnsafe, CreateMode createMode) throws KeeperException, InterruptedException {
        return this.execute(() -> this.getZooKeeper().create(string, data, openAclUnsafe, createMode));
    }

    public String create(String string, byte[] data, CreateMode createMode) throws KeeperException, InterruptedException {
        return this.execute(() -> this.getZooKeeper().create(string, data, ZooDefs.Ids.OPEN_ACL_UNSAFE, createMode));
    }

    public String createUnsafe(String string, byte[] data, CreateMode createMode) throws KeeperException, InterruptedException {
        return this.executeUnsafe(() -> this.getZooKeeper().create(string, data, ZooDefs.Ids.OPEN_ACL_UNSAFE, createMode));
    }

    public String createPersistent(String string, byte[] data) throws KeeperException, InterruptedException {
        return this.execute(() -> this.getZooKeeper().create(string, data, ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT));
    }

    public String createPersistentSequential(String string, byte[] data) throws KeeperException, InterruptedException {
        return this.execute(() -> this.getZooKeeper().create(string, data, ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT_SEQUENTIAL));
    }

    public String createEphemeral(String string, byte[] data) throws KeeperException, InterruptedException {
        return this.execute(() -> this.getZooKeeper().create(string, data, ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.EPHEMERAL));
    }

    public String createEphemeralSequential(String string, byte[] data) throws KeeperException, InterruptedException {
        return this.execute(() -> this.getZooKeeper().create(string, data, ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.EPHEMERAL_SEQUENTIAL));
    }

    public void setData(String path, byte[] data) throws KeeperException, InterruptedException {
        this.execute(() -> this.getZooKeeper().setData(path, data, -1));
    }

    public void sync(String path) throws InterruptedException {
        this.sync(path, 0L, null);
    }

    public boolean sync(String path, long timeout, TimeUnit unit) throws InterruptedException {
        ReentrantLock lock = new ReentrantLock();
        lock.lock();
        try {
            long deadline = timeout > 0L ? System.currentTimeMillis() + unit.toMillis(timeout) : 0L;
            while (true) {
                long frame;
                Condition condition = lock.newCondition();
                long startTimeInMillis = System.currentTimeMillis();
                this.getZooKeeper().sync(path, (rc, nodePath, ctx) -> {
                    lock.lock();
                    try {
                        condition.signalAll();
                    }
                    finally {
                        lock.unlock();
                    }
                }, null);
                long l = frame = deadline > 0L ? Math.min(deadline - System.currentTimeMillis(), 5000L) : 5000L;
                if (frame > 0L && condition.await(frame, TimeUnit.MILLISECONDS)) {
                    ZooKeeperClient.successEvent("sync", startTimeInMillis);
                    boolean bl = true;
                    return bl;
                }
                if (frame < 5000L) {
                    if (frame >= 1000L) {
                        ZooKeeperClient.failEvent("sync-timeout", startTimeInMillis);
                        log.warn("ZooKeeper sync timeout");
                    }
                    boolean bl = false;
                    return bl;
                }
                ZooKeeperClient.failEvent("sync-timeout", startTimeInMillis);
                log.warn("ZooKeeper sync timeout");
                this.checkReconnect();
            }
        }
        finally {
            lock.unlock();
        }
    }

    private class Pinger
    extends Thread {
        public Pinger(String name) {
            super(name);
            this.setDaemon(true);
        }

        @Override
        public void run() {
            try {
                while (!ZooKeeperClient.this.closed.get()) {
                    try {
                        ZooKeeperClient.this.exists("/");
                        log.debug("ping zookeeper success");
                        Pinger.sleep(300000L);
                    }
                    catch (InterruptedException interruptedException) {
                    }
                    catch (Throwable t) {
                        log.error("an error has occurred", t);
                    }
                }
            }
            catch (Throwable t) {
                log.error("an unexpected error has occurred", t);
            }
            finally {
                log.debug("zookeeper ping stopped");
            }
        }
    }

    protected final class ZooKeeperFacade {
        final ZooKeeper zooKeeper;

        public ZooKeeperFacade(ZooKeeper zooKeeper) {
            this.zooKeeper = zooKeeper;
        }

        public Stat exists(String path, boolean watch) throws KeeperException, InterruptedException {
            long startTimeInMillis = System.currentTimeMillis();
            Stat result = this.zooKeeper.exists(path, watch);
            ZooKeeperClient.successEvent("operation.exists", startTimeInMillis);
            ZooKeeperClient.successEvent("operation.all", startTimeInMillis);
            return result;
        }

        public List<String> getChildren(String path, boolean watch) throws KeeperException, InterruptedException {
            long startTimeInMillis = System.currentTimeMillis();
            List result = this.zooKeeper.getChildren(path, watch);
            ZooKeeperClient.successEvent("operation.get-children", startTimeInMillis);
            ZooKeeperClient.successEvent("operation.all", startTimeInMillis);
            return result;
        }

        public String create(String path, byte[] data, List<ACL> acl, CreateMode createMode) throws KeeperException, InterruptedException {
            long startTimeInMillis = System.currentTimeMillis();
            String result = this.zooKeeper.create(path, data, acl, createMode);
            ZooKeeperClient.successEvent("operation.create", startTimeInMillis);
            ZooKeeperClient.successEvent("operation.all", startTimeInMillis);
            return result;
        }

        public void delete(String path, int version) throws KeeperException, InterruptedException {
            long startTimeInMillis = System.currentTimeMillis();
            this.zooKeeper.delete(path, version);
            ZooKeeperClient.successEvent("operation.delete", startTimeInMillis);
            ZooKeeperClient.successEvent("operation.all", startTimeInMillis);
        }

        public byte[] getData(String path, boolean watch, Stat stat) throws KeeperException, InterruptedException {
            long startTimeInMillis = System.currentTimeMillis();
            byte[] result = this.zooKeeper.getData(path, watch, stat);
            ZooKeeperClient.successEvent("operation.get-data", startTimeInMillis);
            ZooKeeperClient.successEvent("operation.all", startTimeInMillis);
            return result;
        }

        public Stat setData(String path, byte[] data, int version) throws KeeperException, InterruptedException {
            long startTimeInMillis = System.currentTimeMillis();
            Stat result = this.zooKeeper.setData(path, data, version);
            ZooKeeperClient.successEvent("operation.set-data", startTimeInMillis);
            ZooKeeperClient.successEvent("operation.all", startTimeInMillis);
            return result;
        }

        public void sync(String path, AsyncCallback.VoidCallback cb, Object ctx) {
            long startTimeInMillis = System.currentTimeMillis();
            this.zooKeeper.sync(path, cb, ctx);
            ZooKeeperClient.successEvent("operation.sync", startTimeInMillis);
            ZooKeeperClient.successEvent("operation.all", startTimeInMillis);
        }

        public long getSessionId() {
            return this.zooKeeper.getSessionId();
        }

        public ZooKeeper.States getState() {
            return this.zooKeeper.getState();
        }
    }

    private static class ZooKeeperStartWatcher
    extends ZooKeeperWatcher {
        private final Lock startLock;
        private final Condition startCondition;

        public ZooKeeperStartWatcher(String url, Lock startLock, Condition startCondition) {
            super(url);
            this.startLock = startLock;
            this.startCondition = startCondition;
        }

        @Override
        public void process(WatchedEvent event) {
            super.process(event);
            if (event.getState() == Watcher.Event.KeeperState.SyncConnected) {
                Lock lock = this.startLock;
                lock.lock();
                try {
                    this.startCondition.signalAll();
                }
                finally {
                    lock.unlock();
                }
            }
        }
    }

    protected static class ZooKeeperWatcher
    implements Watcher {
        private final String url;

        public ZooKeeperWatcher(String url) {
            this.url = url;
        }

        public void process(WatchedEvent event) {
            if (event.getState() == Watcher.Event.KeeperState.Disconnected) {
                log.warn("ZooKeeper disconnected from " + this.url + "!");
                ZooKeeperClient.failEvent("disconnected");
            }
            log.debug("zookeeper state changed type=" + (event.getType() != null ? event.getType().name() : "null") + ", state=" + (event.getState() != null ? event.getState().name() : "null") + ", url=" + String.valueOf(this.url));
        }
    }

    @FunctionalInterface
    protected static interface OperationWithResult<T> {
        public T execute() throws KeeperException, InterruptedException;
    }

    @FunctionalInterface
    protected static interface Operation {
        public void execute() throws KeeperException, InterruptedException;
    }

    private static class LazyHolder {
        public static final String HOST = Metrics.key(Environment.getApplicationId()) + "-" + Metrics.key(LazyHolder.getIp().replace(".", "-"));

        private LazyHolder() {
        }

        private static String getIp() {
            String ipAddress = "unknown-host";
            try {
                Enumeration<NetworkInterface> net = NetworkInterface.getNetworkInterfaces();
                block2: while (net.hasMoreElements()) {
                    NetworkInterface element = net.nextElement();
                    Enumeration<InetAddress> addresses = element.getInetAddresses();
                    while (addresses.hasMoreElements()) {
                        InetAddress ip = addresses.nextElement();
                        if (!(ip instanceof Inet4Address) || !ip.isSiteLocalAddress()) continue;
                        ipAddress = ip.getHostAddress();
                        continue block2;
                    }
                }
            }
            catch (Throwable t) {
                log.error("an unexpected error has occurred", t);
            }
            return ipAddress;
        }
    }
}

