/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.lockmanager;

import com.gridnine.xtrip.server.lockmanager.ZooKeeperClient;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class ZooKeeperFactory {
    private static final Map<String, Data> instances = new ConcurrentHashMap<String, Data>();
    private static final Lock LOCK = new ReentrantLock();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ZooKeeperClient getInstance(String url) {
        Data data = instances.get(url);
        if (data != null) {
            if (data.getCount().getAndIncrement() != 0) {
                return data.getClient();
            }
            data.getCount().decrementAndGet();
        }
        Lock lock = LOCK;
        lock.lock();
        try {
            data = instances.get(url);
            if (data != null) {
                data.getCount().incrementAndGet();
                ZooKeeperClient zooKeeperClient = data.getClient();
                return zooKeeperClient;
            }
            data = new Data(url);
            data.getCount().incrementAndGet();
            instances.put(url, data);
            ZooKeeperClient zooKeeperClient = data.getClient();
            return zooKeeperClient;
        }
        finally {
            lock.unlock();
        }
    }

    public static void release(ZooKeeperClient client) {
        Lock lock = LOCK;
        lock.lock();
        try {
            Data data = instances.get(client.getUrl());
            if (null == data || data.getClient() != client) {
                client.close();
                return;
            }
            if (data.getCount().decrementAndGet() != 0) {
                return;
            }
            instances.remove(client.getUrl());
            client.close();
        }
        finally {
            lock.unlock();
        }
    }

    private static class Data {
        private final ZooKeeperClient client;
        private final AtomicInteger count = new AtomicInteger();

        public Data(String url) {
            this.client = new ZooKeeperClient(url);
        }

        public ZooKeeperClient getClient() {
            return this.client;
        }

        public AtomicInteger getCount() {
            return this.count;
        }
    }
}

