/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.lockmanager;

import com.gridnine.xtrip.common.lockmanager.LockStats;
import com.gridnine.xtrip.common.util.GZIPUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.lockmanager.ZooKeeperClient;
import com.gridnine.xtrip.server.lockmanager.ZooUtil;
import com.gridnine.xtrip.server.metrics.Metrics;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.UTFDataFormatException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZooPersistentLock {
    private static final Logger log = LoggerFactory.getLogger(ZooPersistentLock.class);
    private static final boolean TRACE_LOG = false;
    private final ZooKeeperClient client;
    private final String dir;
    private final AtomicBoolean closed = new AtomicBoolean(false);
    private String id;
    private String id2;
    private String prefix1;
    private static final AtomicLong COUNTER = new AtomicLong();
    private static final String ROOT_METRICS = "profiling.lock";
    private static final String INTRENAL_METRICS = "profiling.lock.internal";
    private static final boolean USE_GZIP = true;
    private static final byte[] SIGN_V5 = new byte[]{37, 5, 4, 0};

    public ZooPersistentLock(ZooKeeperClient client, String dir) {
        this.client = client;
        this.dir = dir;
    }

    protected void checkClosed() {
        if (this.closed.get()) {
            throw new IllegalStateException("closed");
        }
    }

    public void close() throws KeeperException, InterruptedException {
        if (!this.closed.getAndSet(true)) {
            if (this.id2 != null) {
                try {
                    this.client.delete(this.id2);
                }
                catch (KeeperException.NoNodeException noNodeException) {
                    // empty catch block
                }
                this.id2 = null;
            }
            try {
                this.client.delete(this.dir);
            }
            catch (KeeperException.NoNodeException | KeeperException.NotEmptyException throwable) {
                // empty catch block
            }
        }
    }

    public static String prepareLockName(Object lockName) {
        return String.valueOf(lockName).replace("$", "$$").replace("\\", "$1").replace("/", "$2").replace(".", "$-");
    }

    private static String getLockName(String lockName) {
        return lockName.replace("$-", ".").replace("$2", "/").replace("$1", "\\").replace("$$", "$");
    }

    public static void init(ZooKeeperClient client, String dir) throws KeeperException, InterruptedException {
        ZooUtil.ensurePersistentPathExists(client, dir);
    }

    public static void cleanExpiredLocks(ZooKeeperClient client, String root) throws KeeperException, InterruptedException {
        List<String> names;
        try {
            names = client.getChildren(root);
        }
        catch (KeeperException.NoNodeException e) {
            return;
        }
        for (String localName : names) {
            String name = root + "/" + localName;
            ZooPersistentLock.cleanExpiredLock(client, name, localName);
        }
    }

    protected static void cleanExpiredLock(ZooKeeperClient client, String dir, String lockName) throws KeeperException, InterruptedException {
        byte[] nodeData;
        List<String> names;
        try {
            names = client.getChildren(dir);
        }
        catch (KeeperException.NoNodeException e) {
            return;
        }
        for (String localName : names) {
            if (!localName.startsWith("x")) continue;
            String name = dir + "/" + localName;
            String sessionNodeName = "y" + localName.substring(1);
            if (names.contains(sessionNodeName)) continue;
            if (log.isDebugEnabled()) {
                log.debug("node without session detected: " + name);
            }
            try {
                nodeData = client.getData(name);
            }
            catch (KeeperException.NoNodeException e) {
                continue;
            }
            Data data2 = ZooPersistentLock.decodeData(nodeData);
            if (null != data2 && data2.date > System.currentTimeMillis()) continue;
            if (data2 != null) {
                if (log.isDebugEnabled()) {
                    log.debug(String.format("delete not alive node: %s, expired %s", name, new Date(data2.date).toString()));
                }
            } else {
                log.warn(String.format("delete not alive node: %s, invalid", name));
            }
            try {
                client.delete(name);
            }
            catch (KeeperException.NoNodeException noNodeException) {}
        }
        for (String localName : names) {
            String xLocalName;
            if (!localName.startsWith("y") || names.contains(xLocalName = "x" + localName.substring(1))) continue;
            String name = dir + "/" + localName;
            try {
                nodeData = client.getData(name);
            }
            catch (KeeperException.NoNodeException e) {
                continue;
            }
            Data data = ZooPersistentLock.decodeData(nodeData);
            if (null != data && data.date + TimeUnit.MINUTES.toMillis(5L) > System.currentTimeMillis()) continue;
            if (data != null) {
                if (log.isDebugEnabled()) {
                    log.debug(String.format("delete not alive session node: %s, expired %s", name, new Date(data.date).toString()));
                }
            } else {
                log.warn(String.format("delete not alive session node: %s, invalid", name));
            }
            try {
                client.delete(name);
            }
            catch (KeeperException.NoNodeException noNodeException) {}
        }
        try {
            if (log.isDebugEnabled()) {
                log.debug(String.format("delete not alive lock: %s", lockName));
            }
            client.delete(dir);
        }
        catch (KeeperException.NoNodeException | KeeperException.NotEmptyException throwable) {
            // empty catch block
        }
    }

    public static List<LockStats.Lock> getLockList(ZooKeeperClient client, String root) throws KeeperException, InterruptedException, IOException {
        List<String> names;
        ArrayList<LockStats.Lock> result = new ArrayList<LockStats.Lock>();
        try {
            names = client.getChildren(root);
        }
        catch (KeeperException.NoNodeException e) {
            return result;
        }
        for (String localName : names) {
            String dir = root + "/" + localName;
            LockResult info = ZooPersistentLock.getLockedInfo(client, dir);
            result.add(new LockStats.Lock(ZooPersistentLock.getLockName(localName), info != null && info.getDate() > 0L ? new Date(info.getDate()) : null, info != null ? info.getUser() : null, info != null ? info.getHost() : null, info != null ? ZooPersistentLock.getOperation(info.getOperation()) : null, info != null ? Long.valueOf(info.getThreadId()) : null));
        }
        return result;
    }

    public LockResult lock(long validUntil, String user, String operation, String host, String threadUid, long threadId) throws KeeperException, InterruptedException, IOException {
        LockResult result;
        this.checkClosed();
        long startTimeInMillis = System.currentTimeMillis();
        boolean success = false;
        Metrics.get().event("profiling.lock.internal.lock.all");
        try {
            result = this.lock(ZooPersistentLock.encodeData(validUntil, user, operation, host, threadUid, threadId));
            success = true;
            Metrics.get().timing("profiling.lock.internal.lock.all", startTimeInMillis);
        }
        catch (Throwable t) {
            try {
                Metrics.get().timingAndEvent("profiling.lock.internal.lock.fail." + ZooPersistentLock.getLabel(MiscUtil.getSimpleClassName(t.getClass())) + (!TextUtil.isBlank((String)t.getMessage()) ? " - " + Metrics.key(t.getMessage().toLowerCase()) + "!" : ""), startTimeInMillis);
                log.error("an unexpected error has occurred", t);
                throw t;
            }
            catch (Throwable throwable) {
                Metrics.get().timing("profiling.lock.internal.lock.all", startTimeInMillis);
                Metrics.get().timingAndEvent(success ? "profiling.lock.internal.lock.success" : "profiling.lock.internal.lock.fail", startTimeInMillis);
                throw throwable;
            }
        }
        Metrics.get().timingAndEvent(success ? "profiling.lock.internal.lock.success" : "profiling.lock.internal.lock.fail", startTimeInMillis);
        if (null == result) {
            log.error("an unexpected result for lock " + String.valueOf(this.id));
        }
        return result != null ? result : new LockResult(false, false, null, null, null, null, -1L, 0L);
    }

    private static String getLabel(String camel) {
        StringBuilder sb = new StringBuilder();
        int l = 0;
        for (int i = 0; i < camel.length(); ++i) {
            char c = camel.charAt(i);
            if (Character.isUpperCase(c)) {
                if (i > 0 && (l > 0 || 0 == l && i + 1 < camel.length() && Character.isLowerCase(camel.charAt(i + 1)))) {
                    sb.append('-');
                }
                sb.append(Character.toLowerCase(c));
                l = 0;
                continue;
            }
            sb.append(c);
            ++l;
        }
        return sb.toString();
    }

    protected static byte[] encodeData(long value, String user, String operation, String host, String threadUid, long threadId) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(baos);
        out.write(SIGN_V5);
        out.writeLong(value);
        out.writeUTF(user != null ? user : "");
        ZooPersistentLock.writeBytes(out, ZooPersistentLock.getOperation(operation));
        out.writeUTF(host != null ? host : "");
        out.writeUTF(threadUid != null ? threadUid : "");
        out.writeLong(threadId);
        out.flush();
        return baos.toByteArray();
    }

    protected static Data decodeData(byte[] data) {
        try {
            DataInputStream in = new DataInputStream(new ByteArrayInputStream(data));
            byte[] sign = new byte[SIGN_V5.length];
            if (in.read(sign) != sign.length) {
                return null;
            }
            if (!Arrays.equals(SIGN_V5, sign)) {
                return null;
            }
            Data data2 = new Data();
            data2.date = in.readLong();
            data2.user = in.readUTF();
            data2.operation = ZooPersistentLock.readBytes(in);
            data2.host = in.readUTF();
            data2.threadUid = in.readUTF();
            data2.threadId = in.readLong();
            return data2;
        }
        catch (IOException e) {
            log.warn("an unexpected error has occurred while decode data", (Throwable)e);
            return null;
        }
    }

    private static void writeBytes(DataOutputStream out, byte[] bytes) throws IOException {
        int count = bytes != null ? bytes.length : 0;
        out.writeShort(count);
        if (0 == count) {
            return;
        }
        out.write(bytes);
    }

    private static byte[] readBytes(DataInputStream in) throws IOException {
        int count = in.readUnsignedShort();
        if (0 == count) {
            return null;
        }
        byte[] bytes = new byte[count];
        in.readFully(bytes);
        return bytes;
    }

    public static String getOperation(byte[] operation) throws IOException {
        if (null == operation || 0 == operation.length) {
            return null;
        }
        return new String(GZIPUtil.gunzip((byte[])operation), StandardCharsets.UTF_8);
    }

    public static byte[] getOperation(String operation) throws IOException {
        if (null == operation || 0 == operation.length()) {
            return null;
        }
        byte[] bytes = operation.getBytes(StandardCharsets.UTF_8);
        int length = (bytes = GZIPUtil.gzip((byte[])bytes)).length;
        if (length > 65535) {
            throw new UTFDataFormatException("encoded string too long: " + length + " bytes");
        }
        return bytes;
    }

    private void specificUnlock(boolean force) throws KeeperException, InterruptedException {
        List<String> names;
        try {
            names = this.client.getChildren(this.dir);
        }
        catch (KeeperException.NoNodeException e) {
            return;
        }
        for (String localName : names) {
            if (!force && !localName.startsWith("x")) continue;
            String name = this.dir + "/" + localName;
            String sessionNodeName = "y" + localName.substring(1);
            if (!force && names.contains(sessionNodeName)) continue;
            try {
                this.client.delete(name);
            }
            catch (KeeperException.NoNodeException noNodeException) {}
        }
    }

    public void breakLock() throws KeeperException, InterruptedException {
        String _id = this.id;
        if (this.id != null) {
            try {
                this.client.delete(this.id);
            }
            catch (KeeperException.NoNodeException noNodeException) {
                // empty catch block
            }
            this.id = null;
        }
        if (this.id2 != null) {
            try {
                this.client.delete(this.id2);
            }
            catch (KeeperException.NoNodeException noNodeException) {
                // empty catch block
            }
            this.id2 = null;
        }
    }

    public void unlock(boolean force) throws KeeperException, InterruptedException {
        this.checkClosed();
        this.breakLock();
        this.specificUnlock(force);
    }

    public LockResult getLockedInfo() throws KeeperException, InterruptedException {
        return ZooPersistentLock.getLockedInfo(this.client, this.dir);
    }

    private static LockResult getLockedInfo(ZooKeeperClient client, String dir) throws KeeperException, InterruptedException {
        List<String> names;
        try {
            names = client.getChildren(dir);
        }
        catch (KeeperException.NoNodeException e) {
            return null;
        }
        TreeSet<ZNodeName> sortedNames = new TreeSet<ZNodeName>();
        TreeSet<String> sortedNames2 = new TreeSet<String>();
        for (String localName : names) {
            if (!localName.startsWith("x")) continue;
            String name = dir + "/" + localName;
            Data data = null;
            String sessionNodeName = "y" + localName.substring(1);
            if (!names.contains(sessionNodeName)) {
                byte[] nodeData;
                if (log.isDebugEnabled()) {
                    log.debug("node without session detected: " + name);
                }
                try {
                    nodeData = client.getData(name);
                }
                catch (KeeperException.NoNodeException e) {
                    continue;
                }
                data = ZooPersistentLock.decodeData(nodeData);
                if (null == data || data.date <= System.currentTimeMillis()) {
                    if (data != null) {
                        if (log.isDebugEnabled()) {
                            log.debug(String.format("delete not alive node: %s, expired %s", name, new Date(data.date).toString()));
                        }
                    } else {
                        log.warn(String.format("delete not alive node: %s, invalid", name));
                    }
                    try {
                        client.delete(name);
                    }
                    catch (KeeperException.NoNodeException noNodeException) {}
                    continue;
                }
            }
            sortedNames.add(new ZNodeName(name, name, data));
            sortedNames2.add(localName);
        }
        for (String localName : names) {
            byte[] nodeData;
            String xLocalName;
            if (!localName.startsWith("y") || sortedNames2.contains(xLocalName = "x" + localName.substring(1))) continue;
            String name = dir + "/" + localName;
            try {
                nodeData = client.getData(name);
            }
            catch (KeeperException.NoNodeException e) {
                continue;
            }
            Data data = ZooPersistentLock.decodeData(nodeData);
            if (null == data || data.date + TimeUnit.MINUTES.toMillis(5L) <= System.currentTimeMillis()) {
                if (data != null) {
                    if (log.isDebugEnabled()) {
                        log.debug(String.format("delete not alive session node: %s, expired %s", name, new Date(data.date).toString()));
                    }
                } else {
                    log.warn(String.format("delete not alive session node: %s, invalid", name));
                }
                try {
                    client.delete(name);
                }
                catch (KeeperException.NoNodeException noNodeException) {}
                continue;
            }
            sortedNames.add(new ZNodeName(dir + "/" + xLocalName, dir + "/" + localName, null));
        }
        if (sortedNames.isEmpty()) {
            return null;
        }
        ZNodeName ownerName = (ZNodeName)sortedNames.first();
        Data data = ownerName.getData();
        if (null == data) {
            try {
                byte[] nodeData = client.getData(ownerName.getOriginal());
                data = ZooPersistentLock.decodeData(nodeData);
            }
            catch (KeeperException.NoNodeException noNodeException) {
                // empty catch block
            }
        }
        if (data != null) {
            return new LockResult(false, true, data.user, data.host, data.operation, data.threadUid, data.threadId, data.date);
        }
        return new LockResult(false, false, null, null, null, null, -1L, 0L);
    }

    public boolean isLocked() throws KeeperException, InterruptedException {
        List<String> names;
        this.checkClosed();
        try {
            names = this.client.getChildren(this.dir);
        }
        catch (KeeperException.NoNodeException e) {
            return false;
        }
        for (String localName : names) {
            if (localName.startsWith("y")) {
                return true;
            }
            if (!localName.startsWith("x")) continue;
            String name = this.dir + "/" + localName;
            String sessionNodeName = "y" + localName.substring(1);
            if (!names.contains(sessionNodeName)) {
                byte[] nodeData;
                if (log.isDebugEnabled()) {
                    log.debug("node without session detected: " + name);
                }
                try {
                    nodeData = this.client.getData(name);
                }
                catch (KeeperException.NoNodeException e) {
                    continue;
                }
                Data data2 = ZooPersistentLock.decodeData(nodeData);
                if (null == data2 || data2.date <= System.currentTimeMillis()) {
                    if (data2 != null) {
                        if (log.isDebugEnabled()) {
                            log.debug(String.format("delete not alive node: %s, expired %s", name, new Date(data2.date).toString()));
                        }
                    } else {
                        log.warn(String.format("delete not alive node: %s, invalid", name));
                    }
                    try {
                        this.client.delete(name);
                    }
                    catch (KeeperException.NoNodeException noNodeException) {}
                    continue;
                }
            }
            return true;
        }
        return false;
    }

    private String createX(String prefix, String dir, byte[] data) throws KeeperException, InterruptedException {
        String id;
        String nodeName = dir + "/" + prefix;
        try {
            id = this.client.createPersistent(nodeName, data);
        }
        catch (KeeperException.NodeExistsException e) {
            return nodeName;
        }
        return id;
    }

    private String createY(String prefix, String dir, byte[] data) throws KeeperException, InterruptedException {
        String nodeName = dir + "/" + prefix;
        return this.client.executeSafe(() -> {
            try {
                String id;
                while (true) {
                    try {
                        id = this.client.createUnsafe(nodeName, data, CreateMode.EPHEMERAL_SEQUENTIAL);
                    }
                    catch (KeeperException.NoNodeException e) {
                        ZooUtil.ensurePersistentPathExists(this.client, dir);
                        continue;
                    }
                    break;
                }
                return id;
            }
            catch (KeeperException.ConnectionLossException | KeeperException.SessionExpiredException e) {
                List<String> names;
                log.warn("failed to create ephemeral node", e);
                this.client.sync(dir);
                try {
                    names = this.client.getChildren(dir);
                }
                catch (KeeperException.NoNodeException nne) {
                    throw e;
                }
                for (String localName : names) {
                    if (!localName.startsWith(nodeName)) continue;
                    log.info("found ephemeral id: " + dir + "/" + localName);
                    return dir + "/" + localName;
                }
                throw e;
            }
        });
    }

    private LockResult lock(byte[] lockData) throws KeeperException, InterruptedException {
        Data data;
        block47: {
            byte[] nodeData;
            if (null == this.id && null == this.id2) {
                try {
                    int count = 0;
                    List<String> names2 = this.client.getChildren(this.dir);
                    for (String localName : names2) {
                        if (!localName.startsWith("y") || ++count <= 10) continue;
                        return this.getLockedInfo();
                    }
                }
                catch (KeeperException.NoNodeException count) {
                    // empty catch block
                }
            }
            boolean recreate = false;
            while (true) {
                byte[] nodeData2;
                List<String> names;
                if (recreate) {
                    log.warn("No children in: " + this.dir + " when we've just created one! Lets recreate it...");
                    if (this.id != null) {
                        try {
                            this.client.delete(this.id);
                        }
                        catch (KeeperException.NoNodeException names2) {
                            // empty catch block
                        }
                    }
                    this.id = null;
                    if (this.id2 != null) {
                        try {
                            this.client.delete(this.id2);
                        }
                        catch (KeeperException.NoNodeException names2) {
                            // empty catch block
                        }
                    }
                    this.id2 = null;
                } else {
                    recreate = true;
                }
                if (null == this.id2) {
                    long sessionId = this.client.getSessionId();
                    long instanceId = COUNTER.incrementAndGet();
                    String prefix2 = "y-" + sessionId + "-" + instanceId + "-";
                    this.id2 = this.createY(prefix2, this.dir, lockData);
                    int pos = this.id2.indexOf(prefix2);
                    if (pos < 0) {
                        throw new IllegalStateException("internal exception: bad node name");
                    }
                    this.prefix1 = "x" + this.id2.substring(pos + 1);
                }
                if (null == this.id) {
                    try {
                        this.id = this.createX(this.prefix1, this.dir, lockData);
                    }
                    catch (KeeperException.NoNodeException e) {
                        continue;
                    }
                }
                try {
                    names = this.client.getChildren(this.dir);
                }
                catch (KeeperException.NoNodeException e) {
                    continue;
                }
                if (names.isEmpty()) continue;
                TreeSet<ZNodeName> sortedNames = new TreeSet<ZNodeName>();
                TreeSet<String> sortedNames2 = new TreeSet<String>();
                boolean xFound = false;
                for (String localName : names) {
                    if (!localName.startsWith("x")) continue;
                    String name = this.dir + "/" + localName;
                    data = null;
                    if (!name.equals(this.id)) {
                        String sessionNodeName = "y" + localName.substring(1);
                        if (!names.contains(sessionNodeName)) {
                            if (log.isDebugEnabled()) {
                                log.debug("node without session detected: " + name);
                            }
                            try {
                                nodeData2 = this.client.getData(name);
                            }
                            catch (KeeperException.NoNodeException e) {
                                continue;
                            }
                            data = ZooPersistentLock.decodeData(nodeData2);
                            if (null == data || data.date <= System.currentTimeMillis()) {
                                if (data != null) {
                                    if (log.isDebugEnabled()) {
                                        log.debug(String.format("delete not alive node: %s, expired %s", name, new Date(data.date).toString()));
                                    }
                                } else {
                                    log.warn(String.format("delete not alive node: %s, invalid", name));
                                }
                                try {
                                    this.client.delete(name);
                                }
                                catch (KeeperException.NoNodeException e) {}
                                continue;
                            }
                        }
                    } else {
                        xFound = true;
                    }
                    sortedNames.add(new ZNodeName(name, name, data));
                    sortedNames2.add(localName);
                }
                if (!xFound) continue;
                boolean yFound = false;
                for (String localName : names) {
                    if (!localName.startsWith("y")) continue;
                    String name = this.dir + "/" + localName;
                    if (name.equals(this.id2)) {
                        yFound = true;
                        continue;
                    }
                    String xLocalName = "x" + localName.substring(1);
                    if (sortedNames2.contains(xLocalName)) continue;
                    try {
                        nodeData2 = this.client.getData(name);
                    }
                    catch (KeeperException.NoNodeException e) {
                        continue;
                    }
                    Data data2 = ZooPersistentLock.decodeData(nodeData2);
                    if (null == data2 || data2.date + TimeUnit.MINUTES.toMillis(5L) <= System.currentTimeMillis()) {
                        if (data2 != null) {
                            if (log.isDebugEnabled()) {
                                log.debug(String.format("delete not alive session node: %s, expired %s", name, new Date(data2.date).toString()));
                            }
                        } else {
                            log.warn(String.format("delete not alive session node: %s, invalid", name));
                        }
                        try {
                            this.client.delete(name);
                        }
                        catch (KeeperException.NoNodeException noNodeException) {}
                        continue;
                    }
                    sortedNames.add(new ZNodeName(this.dir + "/" + xLocalName, this.dir + "/" + localName, null));
                    log.debug("add spirit of the " + this.dir + "/" + xLocalName);
                }
                if (!yFound || sortedNames.isEmpty()) continue;
                ZNodeName ownerName = (ZNodeName)sortedNames.first();
                String ownerId = ownerName.getName();
                if (this.id.equals(ownerId)) {
                    return new LockResult(true, false, null, null, null, null, -1L, 0L);
                }
                data = ownerName.getData();
                if (null != data) break block47;
                try {
                    nodeData = this.client.getData(ownerName.getOriginal());
                }
                catch (KeeperException.NoNodeException e) {
                    continue;
                }
                break;
            }
            data = ZooPersistentLock.decodeData(nodeData);
        }
        if (data != null) {
            return new LockResult(false, true, data.user, data.host, data.operation, data.threadUid, data.threadId, data.date);
        }
        return new LockResult(false, false, null, null, null, null, -1L, 0L);
    }

    public String getId() {
        return this.id;
    }

    private static class ZNodeName
    implements Comparable<ZNodeName> {
        private final String name;
        private final String original;
        private final Data data;
        private int sequence = -1;

        public ZNodeName(String name, String original, Data data) {
            if (name == null) {
                throw new NullPointerException("id cannot be null");
            }
            this.name = name;
            this.original = original;
            this.data = data;
            int idx = name.lastIndexOf(45);
            if (idx >= 0) {
                this.sequence = Integer.parseInt(name.substring(idx + 1));
            }
        }

        public String toString() {
            return this.name;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ZNodeName zNodeName = (ZNodeName)o;
            return this.name.equals(zNodeName.name);
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        @Override
        public int compareTo(ZNodeName that) {
            int s1 = this.sequence;
            int s2 = that.sequence;
            if (s1 == -1 && s2 == -1) {
                return this.name.compareTo(that.name);
            }
            return s1 == -1 ? 1 : (s2 == -1 ? -1 : s1 - s2);
        }

        public String getName() {
            return this.name;
        }

        public String getOriginal() {
            return this.original;
        }

        public Data getData() {
            return this.data;
        }
    }

    protected static class Data {
        public long date;
        public String user;
        public byte[] operation;
        public String host;
        public String threadUid;
        public long threadId;

        protected Data() {
        }
    }

    public static class LockResult {
        private final boolean success;
        private final boolean lockedBy;
        private final String user;
        private final String host;
        private final byte[] operation;
        private final String threadUid;
        private final long threadId;
        private final long date;

        public LockResult(boolean success, boolean lockedBy, String user, String host, byte[] operation, String threadUid, long threadId, long date) {
            this.success = success;
            this.lockedBy = lockedBy;
            this.user = user;
            this.host = host;
            this.operation = operation;
            this.threadUid = threadUid;
            this.threadId = threadId;
            this.date = date;
        }

        public boolean isSuccess() {
            return this.success;
        }

        public boolean isLockedBy() {
            return this.lockedBy;
        }

        public String getUser() {
            return this.user;
        }

        public String getHost() {
            return this.host;
        }

        public byte[] getOperation() {
            return this.operation;
        }

        public String getThreadUid() {
            return this.threadUid;
        }

        public long getThreadId() {
            return this.threadId;
        }

        public long getDate() {
            return this.date;
        }
    }
}

