/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.lockmanager;

import com.gridnine.xtrip.server.lockmanager.ZooKeeperClient;
import java.util.List;
import org.apache.zookeeper.KeeperException;

public class ZooUtil {
    public static void ensurePersistentPathExists(ZooKeeperClient client, String path) throws KeeperException, InterruptedException {
        int finish;
        int n = finish = path.endsWith("/") ? path.length() - 1 : path.length();
        if (client.exists(path.substring(0, finish))) {
            return;
        }
        int start = path.startsWith("/") ? 1 : 0;
        String[] parts = path.substring(start, finish).split("/");
        String p = "";
        for (String part : parts) {
            p = p + "/" + part;
            ZooUtil.ensurePersistentExists(client, p, null);
        }
    }

    public static boolean ensurePersistentExists(ZooKeeperClient client, String path, byte[] data) throws KeeperException, InterruptedException {
        if (client.exists(path)) {
            return true;
        }
        try {
            client.createPersistent(path, data);
        }
        catch (KeeperException.NodeExistsException e) {
            return true;
        }
        return true;
    }

    public static void deletePath(ZooKeeperClient client, String path) throws KeeperException, InterruptedException {
        List<String> nodes;
        try {
            nodes = client.getChildren(path);
        }
        catch (KeeperException.NoNodeException e) {
            return;
        }
        for (String node : nodes) {
            ZooUtil.deletePath(client, path + "/" + node);
        }
        try {
            client.delete(path);
        }
        catch (KeeperException.NoNodeException noNodeException) {
            // empty catch block
        }
    }
}

