/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.lockmanager;

import com.gridnine.xtrip.common.test.TestBase;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.ConnectException;
import java.net.Socket;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.server.ServerConfig;
import org.apache.zookeeper.server.ZooKeeperServerMain;
import org.apache.zookeeper.server.admin.AdminServer;
import org.apache.zookeeper.server.quorum.QuorumPeerConfig;

public abstract class ZookepperTestBase
extends TestBase {
    protected static final String ZOO_URL = "localhost:2182";
    protected LocalZooKeeperServerMain zooServer;
    protected Thread zooThread;
    private final File zooFolder = new File(String.format("./test/zoo/%s/", UUID.randomUUID().toString()));
    protected final ReentrantLock CONNECTED_LOCK = new ReentrantLock();
    protected final Condition CONNECTED_CONDITION = this.CONNECTED_LOCK.newCondition();

    public void setUp() throws Exception {
        super.setUp();
        Properties startupProperties = new Properties();
        this.populateZooConfig(startupProperties);
        QuorumPeerConfig quorumConfiguration = new QuorumPeerConfig();
        quorumConfiguration.parseProperties(startupProperties);
        ServerConfig configuration = new ServerConfig();
        configuration.readFrom(quorumConfiguration);
        this.waitPort(configuration);
        this.zooServer = new LocalZooKeeperServerMain();
        this.zooThread = new Thread(() -> {
            try {
                this.log.info("zoo start");
                this.zooServer.runFromConfig(configuration);
                this.log.info("zoo stop");
            }
            catch (IOException | AdminServer.AdminServerException e) {
                this.log.error("ZooKeeper Failed", e);
            }
        });
        this.zooThread.start();
        this.waitForStart();
        this.log.info("ZooKeepper started");
    }

    public void tearDown() throws Exception {
        super.tearDown();
        if (this.zooServer != null) {
            this.zooServer.shutdown();
        }
        if (this.zooThread != null) {
            this.zooThread.join();
        }
        try {
            FileUtils.deleteDirectory((File)this.zooFolder);
        }
        catch (IOException e) {
            this.log.error("an unexpected error has occurred", (Throwable)e);
        }
    }

    private void waitPort(ServerConfig configuration) throws IOException, TimeoutException, InterruptedException {
        long i = TimeUnit.MINUTES.toSeconds(1L);
        while (true) {
            Socket socket;
            try {
                socket = new Socket(configuration.getClientPortAddress().getAddress(), configuration.getClientPortAddress().getPort());
            }
            catch (ConnectException e) {
                break;
            }
            socket.close();
            if (0L == --i) {
                throw new TimeoutException();
            }
            this.log.info("port " + configuration.getClientPortAddress().getPort() + " in use, wait...");
            Thread.sleep(TimeUnit.SECONDS.toMillis(1L));
        }
    }

    private void populateZooConfig(Properties properties) throws IOException {
        try (InputStream in = ZookepperTestBase.class.getResource("zoo.cfg").openStream();){
            properties.load(in);
        }
        properties.setProperty("dataDir", this.zooFolder.getAbsolutePath());
        properties.setProperty("clientPort", Integer.toString(this.getHostInfo(ZOO_URL).getPort()));
    }

    private HostInfo getHostInfo(String connectionString) {
        Matcher matcher = Pattern.compile("^([^:]+)(?::(\\d+)$)?").matcher(connectionString);
        if (!matcher.matches()) {
            throw new IllegalArgumentException(connectionString);
        }
        String host = matcher.group(1);
        String portStr = matcher.group(2);
        int port = portStr != null ? Integer.parseInt(portStr) : 2181;
        return new HostInfo(host, port);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForStart() throws IOException, InterruptedException {
        try (ZooKeeper zooKeeper = new ZooKeeper(ZOO_URL, 300000, (Watcher)new ZooKeeperWatcher(ZOO_URL));){
            ReentrantLock lock = this.CONNECTED_LOCK;
            lock.lock();
            try {
                this.CONNECTED_CONDITION.await(60L, TimeUnit.SECONDS);
            }
            finally {
                lock.unlock();
            }
        }
    }

    protected ZooKeeper getInstance(String url) throws IOException {
        return new ZooKeeper(url, 300000, (Watcher)new ZooKeeperWatcher(url));
    }

    protected class ZooKeeperWatcher
    implements Watcher {
        final String url;

        public ZooKeeperWatcher(String url) {
            this.url = url;
        }

        public synchronized void process(WatchedEvent event) {
            ZookepperTestBase.this.log.debug("zookeeper state changed type=" + (event.getType() != null ? event.getType().name() : "null") + ", state=" + (event.getState() != null ? event.getState().name() : "null") + ", url=" + String.valueOf(this.url));
            if (event.getState() == Watcher.Event.KeeperState.SyncConnected) {
                ReentrantLock lock = ZookepperTestBase.this.CONNECTED_LOCK;
                lock.lock();
                try {
                    ZookepperTestBase.this.CONNECTED_CONDITION.signalAll();
                }
                finally {
                    lock.unlock();
                }
            }
        }
    }

    protected static final class LocalZooKeeperServerMain
    extends ZooKeeperServerMain {
        public void shutdown() {
            super.shutdown();
        }
    }

    private static class HostInfo {
        private final String host;
        private final int port;

        public HostInfo(String host, int port) {
            this.host = host;
            this.port = port;
        }

        public String getHost() {
            return this.host;
        }

        public int getPort() {
            return this.port;
        }
    }
}

