/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.lockmanager;

import com.google.common.base.Charsets;
import com.google.common.io.Files;
import com.gridnine.xtrip.common.test.TestBase;
import com.gridnine.xtrip.server.lockmanager.ZookepperTestBase;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.ConnectException;
import java.net.Socket;
import java.nio.charset.Charset;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.io.FileUtils;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.server.ServerConfig;
import org.apache.zookeeper.server.ZooKeeperServerMain;
import org.apache.zookeeper.server.admin.AdminServer;
import org.apache.zookeeper.server.quorum.QuorumPeerConfig;

public abstract class ZookepperTestBase2
extends TestBase {
    protected static final String ZOO1_URL = "localhost:2182";
    protected static final String ZOO2_URL = "localhost:2183";
    protected static final String ZOO_URL = "localhost:2182,localhost:2183";
    protected LocalZooKeeperServerMain zooServer1;
    protected Thread zooThread1;
    private final File zooFolder1 = new File(String.format("./test/zoo1/%s/", UUID.randomUUID().toString()));
    protected LocalZooKeeperServerMain zooServer2;
    protected Thread zooThread2;
    private final File zooFolder2 = new File(String.format("./test/zoo2/%s/", UUID.randomUUID().toString()));
    protected final ReentrantLock CONNECTED_LOCK = new ReentrantLock();
    protected final Condition CONNECTED_CONDITION = this.CONNECTED_LOCK.newCondition();

    public void setUp() throws Exception {
        super.setUp();
        this.createMyId(this.zooFolder1, "1");
        Properties startupProperties = new Properties();
        this.populateZooConfig(startupProperties, "zoo1.cfg", this.zooFolder1);
        QuorumPeerConfig quorumConfiguration = new QuorumPeerConfig();
        quorumConfiguration.parseProperties(startupProperties);
        ServerConfig configuration = new ServerConfig();
        configuration.readFrom(quorumConfiguration);
        this.waitPort(configuration);
        this.zooServer1 = new LocalZooKeeperServerMain();
        this.zooThread1 = new Thread(() -> {
            try {
                this.log.info("zoo 1 start");
                this.zooServer1.runFromConfig(configuration);
                this.log.info("zoo 1 stop");
            }
            catch (IOException | AdminServer.AdminServerException e) {
                this.log.error("ZooKeeper failed", e);
            }
        });
        this.zooThread1.start();
        this.createMyId(this.zooFolder2, "2");
        startupProperties = new Properties();
        this.populateZooConfig(startupProperties, "zoo2.cfg", this.zooFolder2);
        quorumConfiguration = new QuorumPeerConfig();
        quorumConfiguration.parseProperties(startupProperties);
        configuration = new ServerConfig();
        configuration.readFrom(quorumConfiguration);
        this.waitPort(configuration);
        this.zooServer2 = new LocalZooKeeperServerMain();
        this.zooThread2 = new Thread(() -> {
            try {
                this.log.info("zoo 2 start");
                this.zooServer2.runFromConfig(configuration);
                this.log.info("zoo 2 stop");
            }
            catch (IOException | AdminServer.AdminServerException e) {
                this.log.error("ZooKeeper failed", e);
            }
        });
        this.zooThread2.start();
        this.waitForStart();
        this.log.info("ZooKeepper started");
    }

    public void tearDown() throws Exception {
        super.tearDown();
        if (this.zooServer1 != null) {
            this.zooServer1.shutdown();
        }
        if (this.zooThread1 != null) {
            this.zooThread1.join();
        }
        if (this.zooServer2 != null) {
            this.zooServer2.shutdown();
        }
        if (this.zooThread2 != null) {
            this.zooThread2.join();
        }
        FileUtils.deleteDirectory((File)this.zooFolder1);
        FileUtils.deleteDirectory((File)this.zooFolder2);
    }

    private void waitPort(ServerConfig configuration) throws IOException, TimeoutException, InterruptedException {
        long i = TimeUnit.MINUTES.toSeconds(1L);
        while (true) {
            Socket socket;
            try {
                socket = new Socket(configuration.getClientPortAddress().getAddress(), configuration.getClientPortAddress().getPort());
            }
            catch (ConnectException e) {
                break;
            }
            socket.close();
            if (0L == --i) {
                throw new TimeoutException();
            }
            this.log.info("post " + configuration.getClientPortAddress().getPort() + " in use, wait...");
            Thread.sleep(TimeUnit.SECONDS.toMillis(1L));
        }
    }

    private void createMyId(File zooFolder, String id) throws IOException {
        zooFolder.mkdirs();
        File myId = new File(zooFolder, "myid");
        Files.write((CharSequence)id, (File)myId, (Charset)Charsets.UTF_8);
    }

    private void populateZooConfig(Properties properties, String config, File zooFolder) throws IOException {
        try (InputStream in = ZookepperTestBase.class.getResource(config).openStream();){
            properties.load(in);
        }
        properties.setProperty("dataDir", zooFolder.getAbsolutePath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForStart() throws IOException, InterruptedException {
        try (ZooKeeper zooKeeper = new ZooKeeper(ZOO_URL, 300000, (Watcher)new ZooKeeperWatcher(ZOO_URL));){
            ReentrantLock lock = this.CONNECTED_LOCK;
            lock.lock();
            try {
                this.CONNECTED_CONDITION.await(60L, TimeUnit.SECONDS);
            }
            finally {
                lock.unlock();
            }
        }
    }

    protected ZooKeeper getInstance(String url) throws IOException {
        return new ZooKeeper(url, 300000, (Watcher)new ZooKeeperWatcher(url));
    }

    protected class ZooKeeperWatcher
    implements Watcher {
        final String url;

        public ZooKeeperWatcher(String url) {
            this.url = url;
        }

        public synchronized void process(WatchedEvent event) {
            ZookepperTestBase2.this.log.debug("zookeeper state changed type=" + (event.getType() != null ? event.getType().name() : "null") + ", state=" + (event.getState() != null ? event.getState().name() : "null") + ", url=" + String.valueOf(this.url));
            if (event.getState() == Watcher.Event.KeeperState.SyncConnected) {
                ReentrantLock lock = ZookepperTestBase2.this.CONNECTED_LOCK;
                lock.lock();
                try {
                    ZookepperTestBase2.this.CONNECTED_CONDITION.signalAll();
                }
                finally {
                    lock.unlock();
                }
            }
        }
    }

    protected static final class LocalZooKeeperServerMain
    extends ZooKeeperServerMain {
        public void shutdown() {
            super.shutdown();
        }
    }
}

