/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.logging;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.cache.common.ModificationData;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.logging.CentralizedLoggingSettings;
import com.gridnine.xtrip.server.jms.JMSConfigurator;
import com.gridnine.xtrip.server.jms.JMSFacade;
import com.gridnine.xtrip.server.jms.JMSTopicListener;
import com.gridnine.xtrip.server.logging.CentralizedLoggingSystemConnector;

public class CentralizedLoggingJMSConfigurator
implements JMSConfigurator {
    @Override
    public void configure(JMSFacade jms) throws Exception {
        jms.registerTopicListener("entity-cache", new JMSTopicListener<ModificationData<EntityReference<?>>>(){

            @Override
            public void onMessage(ModificationData<EntityReference<?>> message) {
                if (message == null) {
                    return;
                }
                EntityReference messageItem = (EntityReference)message.getItem();
                if (messageItem == null || messageItem.getType() == null || messageItem.getUid() == null || !messageItem.getType().equals(CentralizedLoggingSettings.class)) {
                    return;
                }
                EntityContainer settings = EntityStorage.get().resolve(messageItem);
                CentralizedLoggingSystemConnector.startOrUpdateConfiguration(settings != null ? (CentralizedLoggingSettings)settings.getEntity() : null);
            }
        });
    }
}

