/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.logging;

import com.google.common.base.Objects;
import com.gridnine.xtrip.common.model.logging.CentralizedLoggingSettings;
import com.gridnine.xtrip.common.user.UserData;
import com.gridnine.xtrip.server.logging.LogServerConnector;
import com.gridnine.xtrip.server.logging.LogServerMessage;
import com.gridnine.xtrip.server.logging.LogServerSettings;
import java.time.Instant;
import java.util.Arrays;
import java.util.stream.Collectors;
import org.apache.log4j.helpers.LogLog;
import org.apache.log4j.spi.LocationInfo;
import org.apache.log4j.spi.LoggingEvent;

public final class CentralizedLoggingSystemConnector {
    private static volatile LogServerConnector CONNECTOR;
    private static volatile boolean applicationInitialized;

    public static void setApplicationInitialized(boolean value) {
        applicationInitialized = value;
    }

    public static synchronized void startOrUpdateConfiguration(CentralizedLoggingSettings settings) {
        LogServerSettings newSettings;
        if (settings == null || !settings.isNetworkSendingEnabled()) {
            newSettings = null;
        } else {
            try {
                newSettings = new LogServerSettings(settings);
            }
            catch (Exception e) {
                LogLog.error((String)"Error parsing logging settings", (Throwable)e);
                CentralizedLoggingSystemConnector.stop();
                return;
            }
        }
        if (CONNECTOR != null && Objects.equal((Object)CentralizedLoggingSystemConnector.CONNECTOR.serverSettings, (Object)newSettings)) {
            LogLog.debug((String)"Server connection parameters has not been changed");
            return;
        }
        CentralizedLoggingSystemConnector.start(newSettings);
    }

    public static void sendMessage(LoggingEvent event) {
        if (CONNECTOR == null) {
            LogLog.warn((String)"Attempt to send log message to centralized logging system while sender is not enabled");
            return;
        }
        try {
            String[] strRep;
            LogServerMessage message = new LogServerMessage();
            message.setDatetime(Instant.now());
            message.setSeverity(event.getLevel().toString());
            message.setThreadname(event.getThreadName());
            LocationInfo locationInfo = event.getLocationInformation();
            if (locationInfo != null) {
                message.setClassname(locationInfo.getClassName());
                message.setMethodname(locationInfo.getMethodName());
                message.setFilename(locationInfo.getFileName());
                message.setLinenumber(locationInfo.getLineNumber());
            }
            if (event.getMessage() != null) {
                message.setMessage(event.getMessage().toString());
            }
            if ((strRep = event.getThrowableStrRep()) != null) {
                message.setDetails(Arrays.stream(strRep).collect(Collectors.joining("\n")));
            } else {
                try {
                    StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
                    int loggingHead = 9;
                    if (stackTrace.length > loggingHead) {
                        StringBuilder sb = new StringBuilder("[ no exception in log message ]\n");
                        for (int i = loggingHead; i < stackTrace.length; ++i) {
                            sb.append("\tat ").append(stackTrace[i].toString()).append('\n');
                        }
                        message.setDetails(sb.toString());
                    } else {
                        LogLog.warn((String)("Received stacktrace shorter than 9 elements. Seems that logging configuration has been changed:\n" + Arrays.stream(stackTrace).map(StackTraceElement::toString).collect(Collectors.joining("\n"))));
                    }
                }
                catch (Exception e) {
                    LogLog.error((String)"Error generating log message stacktrace", (Throwable)e);
                }
            }
            if (applicationInitialized) {
                try {
                    String userLogin = UserData.get().getCurrentUser();
                    if (userLogin != null) {
                        message.setUserLogin(userLogin);
                    }
                }
                catch (Exception e) {
                    LogLog.error((String)"Error setting current user", (Throwable)e);
                }
            }
            CONNECTOR.submitMessage(message);
        }
        catch (Exception e) {
            LogLog.error((String)"Error writing log message to centralized logging", (Throwable)e);
        }
    }

    private static synchronized void start(LogServerSettings serverSettings) {
        if (CONNECTOR != null) {
            CentralizedLoggingSystemConnector.stop();
        }
        CONNECTOR = new LogServerConnector(serverSettings);
    }

    static synchronized void stop() {
        if (CONNECTOR == null) {
            return;
        }
        CONNECTOR.stop();
        CONNECTOR = null;
    }

    private CentralizedLoggingSystemConnector() {
    }

    static {
        applicationInitialized = false;
    }
}

