/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.logging;

import com.google.gson.stream.JsonWriter;
import com.gridnine.xtrip.server.logging.LogServerMessageBase;
import com.gridnine.xtrip.server.logging.LogServerMessageType;
import java.io.IOException;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;

public class LogServerMessage
extends LogServerMessageBase {
    private String messageId;
    private String severity;
    private String threadname;
    private String classname;
    private String methodname;
    private String filename;
    private String linenumber;
    private String columnnumber;
    private String message;
    private String details;
    private String userLogin;
    private List<String> userOrganizationUids;
    private List<String> userOrganizationNames;

    @Override
    LogServerMessageType getType() {
        return LogServerMessageType.JAVA_LOG;
    }

    @Override
    void writeFields(JsonWriter out, DateTimeFormatter dtFormatter) throws IOException {
        super.writeFields(out, dtFormatter);
        out.name("message_id").value(this.messageId);
        if (this.severity != null) {
            out.name("severity").value(this.severity);
        }
        if (this.threadname != null) {
            out.name("threadname").value(this.threadname);
        }
        if (this.classname != null) {
            out.name("classname").value(this.classname);
        }
        if (this.methodname != null) {
            out.name("methodname").value(this.methodname);
        }
        if (this.filename != null) {
            out.name("filename").value(this.filename);
        }
        if (this.linenumber != null) {
            out.name("linenumber").value(this.linenumber);
        }
        if (this.columnnumber != null) {
            out.name("columnnumber").value(this.columnnumber);
        }
        if (this.message != null) {
            out.name("message").value(this.message);
        }
        if (this.details != null) {
            out.name("details").value(this.details);
        }
        if (this.userLogin != null) {
            out.name("user_login").value(this.userLogin);
        }
        if (this.userOrganizationUids != null && !this.userOrganizationUids.isEmpty()) {
            out.name("user_organization_uids").beginArray();
            for (String name : this.userOrganizationUids) {
                out.value(name);
            }
            out.endArray();
        }
        if (this.userOrganizationNames != null && !this.userOrganizationNames.isEmpty()) {
            out.name("user_organization_names").beginArray();
            for (String name : this.userOrganizationNames) {
                out.value(name);
            }
            out.endArray();
        }
    }

    String getMessageId() {
        return this.messageId;
    }

    void setMessageId(String messageId) {
        this.messageId = messageId;
    }

    void setSeverity(String severity) {
        this.severity = severity;
    }

    void setThreadname(String threadname) {
        this.threadname = threadname;
    }

    void setClassname(String classname) {
        this.classname = classname;
    }

    void setMethodname(String methodname) {
        this.methodname = methodname;
    }

    void setFilename(String filename) {
        this.filename = filename;
    }

    void setLinenumber(String linenumber) {
        this.linenumber = linenumber;
    }

    void setColumnnumber(String columnnumber) {
        this.columnnumber = columnnumber;
    }

    void setMessage(String message) {
        this.message = message;
    }

    void setDetails(String details) {
        this.details = details;
    }

    public String getUserLogin() {
        return this.userLogin;
    }

    void setUserLogin(String userLogin) {
        this.userLogin = userLogin;
    }

    public void addUserOrganizationUid(String userOrganizationUid) {
        if (this.userOrganizationUids == null) {
            this.userOrganizationUids = new ArrayList<String>(1);
        }
        this.userOrganizationUids.add(userOrganizationUid);
    }

    public void addUserOrganizationName(String userOrganizationName) {
        if (this.userOrganizationNames == null) {
            this.userOrganizationNames = new ArrayList<String>(1);
        }
        this.userOrganizationNames.add(userOrganizationName);
    }

    boolean hasOrganizationInfo() {
        return this.userOrganizationUids != null || this.userOrganizationNames != null;
    }
}

