/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.logging;

import com.gridnine.xtrip.common.model.logging.CentralizedLoggingSettings;
import com.gridnine.xtrip.common.util.TextUtil;
import java.net.URL;
import java.util.Objects;

class LogServerSettings {
    final String serverUrl;
    final String instalaltionId;
    final String password;
    final boolean allowSelfSignedCertificate;

    public LogServerSettings(CentralizedLoggingSettings source) {
        try {
            String tempUrl = LogServerSettings.notEmpty(source.getLogServerUrl(), "logServerUrl");
            if (!tempUrl.trim().toLowerCase().startsWith("https://")) {
                throw new IllegalArgumentException("logServerUrl should start with https://");
            }
            URL tempUrlParsed = new URL(tempUrl);
            if (!"https".equalsIgnoreCase(tempUrlParsed.getProtocol())) {
                throw new IllegalArgumentException("https scheme should be used for log server URL");
            }
            this.serverUrl = tempUrl;
            this.instalaltionId = LogServerSettings.notEmpty(source.getInstallationId(), "instalaltionId");
            this.password = LogServerSettings.notEmpty(source.getPassword(), "password");
            this.allowSelfSignedCertificate = source.isAllowSelfSignedCertificate();
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Failed to initialize log server settings", e);
        }
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof LogServerSettings)) {
            return false;
        }
        LogServerSettings other = (LogServerSettings)obj;
        return Objects.equals(this.serverUrl, other.serverUrl) && Objects.equals(this.instalaltionId, other.instalaltionId) && Objects.equals(this.password, other.password) && this.allowSelfSignedCertificate == other.allowSelfSignedCertificate;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.serverUrl == null ? 0 : this.serverUrl.hashCode());
        result = 31 * result + (this.instalaltionId == null ? 0 : this.instalaltionId.hashCode());
        result = 31 * result + (this.password == null ? 0 : this.password.hashCode());
        result = 31 * result + (this.allowSelfSignedCertificate ? 10 : 20);
        return result;
    }

    private static final String notEmpty(String value, String valueName) {
        if (TextUtil.isBlank((String)value)) {
            throw new IllegalArgumentException(valueName + " cannot be empty");
        }
        return value;
    }
}

