/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.metrics;

import com.gridnine.xtrip.server.metrics.GraphiteSender;
import com.gridnine.xtrip.server.metrics.MetricItem;
import com.gridnine.xtrip.server.metrics.MetricItemType;
import java.util.ArrayList;
import java.util.Date;
import java.util.Random;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public class GraphiteProbe {
    public static void main(String[] args) throws Exception {
        System.setProperty("org.apache.commons.logging.Log", "org.apache.commons.logging.impl.SimpleLog");
        System.setProperty("org.apache.commons.logging.simplelog.defaultlog", "info");
        System.setProperty("org.apache.commons.logging.simplelog.showlogname", "true");
        System.setProperty("org.apache.commons.logging.simplelog.showShortLogname", "true");
        System.setProperty("org.apache.commons.logging.simplelog.showdatetime", "true");
        System.setProperty("org.apache.commons.logging.simplelog.log.com.gridnine", "debug");
        System.setProperty(GraphiteSender.class.getName() + ".host", "10.0.4.164");
        System.setProperty(GraphiteSender.class.getName() + ".port", "2023");
        final Random rnd = new Random();
        final GraphiteSender sender = new GraphiteSender();
        final ArrayList items = new ArrayList();
        ScheduledExecutorService service = Executors.newScheduledThreadPool(1);
        service.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                items.add(new MetricItem("test.probe.carbon", MetricItemType.COUNT, "1"));
                items.add(new MetricItem("test.probe.carbon", MetricItemType.TIMING, String.valueOf(500 + rnd.nextInt(4500))));
                sender.send(items);
                items.clear();
            }
        }, 0L, 1L, TimeUnit.SECONDS);
        System.out.println("Graphite's probe is now running sending one count and one timing metrics every second.");
        System.out.println("Start time: " + new Date());
        System.out.println();
        System.out.println("Press any key to interrupt.");
        System.in.read();
        service.shutdown();
        System.out.println("Stop time: " + new Date());
    }
}

