/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.metrics;

import com.google.common.collect.Lists;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.metrics.CustomByteArrayOutputStream;
import com.gridnine.xtrip.server.metrics.MetricItem;
import com.gridnine.xtrip.server.metrics.MetricSender;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.InetSocketAddress;
import java.nio.channels.DatagramChannel;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphiteSender
implements MetricSender {
    private static final Charset UTF8 = Charset.forName("UTF-8");
    private static final int BATCH_SIZE = 25;
    private final transient Logger log = LoggerFactory.getLogger(this.getClass());
    private final InetSocketAddress address;
    private final String keyPrefix;
    private volatile DatagramChannel channel;
    private Collection<Pattern> regexpPatterns = new ArrayList<Pattern>();

    public GraphiteSender() {
        String name = this.getClass().getName() + ".host";
        String value = System.getProperty(name);
        if (TextUtil.isBlank((String)value)) {
            throw Xeption.forAdmin((String)"System.property {1} not found", (Object[])new Object[]{name});
        }
        String host = value;
        String name2 = this.getClass().getName() + ".port";
        String value2 = System.getProperty(name2);
        if (TextUtil.isBlank((String)value2)) {
            throw Xeption.forAdmin((String)"System.property {1} not found", (Object[])new Object[]{name2});
        }
        int port = Integer.parseInt(value2);
        name2 = this.getClass().getName() + ".prefix";
        value2 = System.getProperty(name2);
        if (!TextUtil.isBlank((String)value2)) {
            if (!value2.endsWith(".")) {
                value2 = value2 + ".";
            }
            this.keyPrefix = value2;
        } else {
            this.keyPrefix = "";
        }
        this.address = new InetSocketAddress(host, port);
    }

    public GraphiteSender(String host, int port, String prefix) {
        this.address = new InetSocketAddress(host, port);
        this.keyPrefix = prefix.endsWith(".") ? prefix : prefix + '.';
    }

    public GraphiteSender(String host, int port, String prefix, Collection<String> regexpPatterns) {
        this(host, port, prefix);
        this.regexpPatterns = new ArrayList<Pattern>();
        for (String exp : regexpPatterns) {
            this.regexpPatterns.add(Pattern.compile(exp));
        }
    }

    @Override
    public void dispose() {
        if (this.channel != null) {
            try {
                this.channel.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.channel = null;
        }
    }

    @Override
    public void send(List<MetricItem> items) {
        if (items.size() <= 25) {
            this.sendInternal(items);
            return;
        }
        for (List batch : Lists.partition(items, (int)25)) {
            this.sendInternal(batch);
        }
    }

    private void appendMetricItem(Appendable buf, MetricItem item) throws IOException {
        buf.append(this.keyPrefix).append(item.key).append('.').append(item.type.getSuffix()).append(' ').append(item.value).append(' ').append(String.valueOf(item.timestamp)).append('\n');
    }

    private void sendInternal(List<MetricItem> items) {
        if (!this.isConnected()) {
            try {
                this.reconnect();
            }
            catch (IOException ioe) {
                this.log.error("failed opening data channel", (Throwable)ioe);
                return;
            }
        }
        CustomByteArrayOutputStream out = new CustomByteArrayOutputStream();
        BufferedWriter buf = new BufferedWriter(new OutputStreamWriter((OutputStream)out, UTF8));
        if (!this.regexpPatterns.isEmpty()) {
            block14: for (MetricItem item : items) {
                for (Pattern patter : this.regexpPatterns) {
                    if (!patter.matcher(item.key).matches()) continue;
                    try {
                        this.appendMetricItem(buf, item);
                    }
                    catch (IOException ioe) {
                        this.log.error("failed appending item", (Throwable)ioe);
                    }
                    continue block14;
                }
            }
        } else {
            for (MetricItem item : items) {
                try {
                    this.appendMetricItem(buf, item);
                }
                catch (IOException ioe) {
                    this.log.error("failed appending item", (Throwable)ioe);
                }
            }
        }
        try {
            ((Writer)buf).flush();
        }
        catch (IOException ioe) {
            this.log.error("failed appending items", (Throwable)ioe);
        }
        if (out.size() == 0) {
            return;
        }
        try {
            this.channel.send(out.toByteBuffer(), this.address);
            return;
        }
        catch (IOException ioe) {
            try {
                this.reconnect();
            }
            catch (IOException ioe2) {
                this.log.error("failed opening data channel", (Throwable)ioe2);
                return;
            }
            try {
                this.channel.send(out.toByteBuffer(), this.address);
            }
            catch (IOException ioe3) {
                this.log.error("failed sending data", (Throwable)ioe3);
            }
            return;
        }
    }

    private boolean isConnected() {
        return this.channel != null && this.channel.isConnected() && !this.channel.socket().isClosed();
    }

    private synchronized void reconnect() throws IOException {
        if (this.isConnected()) {
            return;
        }
        if (this.channel != null) {
            this.channel.close();
        }
        this.channel = DatagramChannel.open();
        this.channel.connect(this.address);
    }
}

