/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.metrics;

import com.gridnine.xtrip.common.Disposable;
import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.util.TranslitUtil;
import com.gridnine.xtrip.server.metrics.MetricItem;
import com.gridnine.xtrip.server.metrics.MetricItemType;
import com.gridnine.xtrip.server.metrics.MetricSender;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Pattern;

public final class Metrics
implements Disposable {
    private static final Pattern KEY_CLEANUP_PATTERN = Pattern.compile("[^a-zA-Z0-9_-]");
    private static final Metrics DUMB_INSTANCE = new Metrics(null);
    private final Collection<MetricSender> senders = new ArrayList<MetricSender>();
    private static final int QUEUE_SIZE_LIMIT = 1000000;
    private final List<MetricItem> queue = new ArrayList<MetricItem>();
    private ScheduledExecutorService executor;
    private boolean scheduleThreadsStarted;

    public static Metrics get() {
        if (!Environment.isPublished(Metrics.class)) {
            return DUMB_INSTANCE;
        }
        return (Metrics)Environment.getPublished(Metrics.class);
    }

    Metrics(MetricSender sender) {
        if (sender != null) {
            this.addMetricSender(sender);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addToQueue(MetricItem ... items) {
        List<MetricItem> list = this.queue;
        synchronized (list) {
            for (MetricItem item : items) {
                if (this.queue.size() >= 1000000) continue;
                this.queue.add(item);
            }
        }
    }

    public void addMetricSender(MetricSender sender) {
        this.senders.add(sender);
        if (!this.scheduleThreadsStarted) {
            this.startScheduleThreads();
        }
    }

    private void startScheduleThreads() {
        this.executor = Executors.newScheduledThreadPool(5, new ThreadFactory(){
            private final AtomicInteger counter = new AtomicInteger(0);

            @Override
            public Thread newThread(Runnable r) {
                return new Thread(r, "metrics-sender-" + this.counter.incrementAndGet());
            }
        });
        this.executor.scheduleAtFixedRate(this::processItems, 10L, 10L, TimeUnit.SECONDS);
        this.scheduleThreadsStarted = true;
    }

    public void dispose() {
        if (this.executor != null) {
            this.executor.shutdownNow();
            this.executor = null;
        }
        this.processItems();
        if (!this.senders.isEmpty()) {
            Iterator<MetricSender> iterator = this.senders.iterator();
            while (iterator.hasNext()) {
                MetricSender type = iterator.next();
                type.dispose();
                iterator.remove();
            }
        }
    }

    public void event(String key) {
        if (this.senders.isEmpty()) {
            return;
        }
        this.addToQueue(new MetricItem(key, MetricItemType.COUNT, "1"));
    }

    public void value(String key, long value) {
        if (this.senders.isEmpty()) {
            return;
        }
        this.addToQueue(new MetricItem(key, MetricItemType.AVERAGE, String.valueOf(value)));
    }

    public void value(String key, double value) {
        if (this.senders.isEmpty()) {
            return;
        }
        this.addToQueue(new MetricItem(key, MetricItemType.AVERAGE, String.format(Locale.US, "%2.2f", value)));
    }

    public void sum(String key, long value) {
        if (this.senders.isEmpty()) {
            return;
        }
        this.addToQueue(new MetricItem(key, MetricItemType.SUM, String.valueOf(value)));
    }

    public void sum(String key, double value) {
        if (this.senders.isEmpty()) {
            return;
        }
        this.addToQueue(new MetricItem(key, MetricItemType.SUM, String.format(Locale.US, "%2.2f", value)));
    }

    public void valueAndSum(String key, long value) {
        if (this.senders.isEmpty()) {
            return;
        }
        this.addToQueue(new MetricItem(key, MetricItemType.AVERAGE, String.valueOf(value)), new MetricItem(key, MetricItemType.SUM, String.valueOf(value)));
    }

    public void valueAndSum(String key, double value) {
        if (this.senders.isEmpty()) {
            return;
        }
        this.addToQueue(new MetricItem(key, MetricItemType.AVERAGE, String.format(Locale.US, "%2.2f", value)), new MetricItem(key, MetricItemType.SUM, String.format(Locale.US, "%2.2f", value)));
    }

    public void timing(String key, long startTimeInMillis) {
        if (this.senders.isEmpty()) {
            return;
        }
        this.addToQueue(new MetricItem(key, MetricItemType.TIMING, String.valueOf(System.currentTimeMillis() - startTimeInMillis)));
    }

    public void timingAndEvent(String key, long startTimeInMillis) {
        if (this.senders.isEmpty()) {
            return;
        }
        this.addToQueue(new MetricItem(key, MetricItemType.TIMING, String.valueOf(System.currentTimeMillis() - startTimeInMillis)), new MetricItem(key, MetricItemType.COUNT, "1"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processItems() {
        ArrayList<MetricItem> items;
        if (this.queue.isEmpty()) {
            return;
        }
        long timing = System.currentTimeMillis();
        List<MetricItem> list = this.queue;
        synchronized (list) {
            items = new ArrayList<MetricItem>(this.queue);
            this.queue.clear();
        }
        if (!this.senders.isEmpty()) {
            items.add(new MetricItem("profiling.metrics.queueSize", MetricItemType.VALUE, String.valueOf(items.size())));
            for (MetricSender sender : this.senders) {
                sender.send(items);
            }
            this.timing("profiling.metrics.send", timing);
        }
    }

    public static String key(String ... parts) {
        if (parts == null || parts.length == 0) {
            return null;
        }
        if (parts.length == 1) {
            return Metrics.cleanKeyPart(parts[0]);
        }
        StringBuilder buf = new StringBuilder();
        for (String part : parts) {
            if (buf.length() > 0) {
                buf.append('.');
            }
            buf.append(Metrics.cleanKeyPart(part));
        }
        return buf.toString();
    }

    public static String cleanKeyPart(String value) {
        if (TextUtil.isBlank((String)value)) {
            return "null";
        }
        return KEY_CLEANUP_PATTERN.matcher(TranslitUtil.cyr2lat((String)value, (TranslitUtil.TranslitRules)TranslitUtil.TranslitRules.GOST_52535_1_2006)).replaceAll("_");
    }
}

