/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.pool;

import com.gridnine.xtrip.common.Disposable;
import com.gridnine.xtrip.common.lockmanager.LockUtil;
import com.gridnine.xtrip.common.lockmanager.NamedLock;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.util.Identity;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.util.UUIDGenerator;
import com.gridnine.xtrip.server.configuration.ServerConfiguration;
import com.gridnine.xtrip.server.lockmanager.ZooKeeperClient;
import com.gridnine.xtrip.server.lockmanager.ZooKeeperFactory;
import com.gridnine.xtrip.server.lockmanager.ZooUtil;
import com.gridnine.xtrip.server.metrics.Metrics;
import com.gridnine.xtrip.server.pool.ExhaustedException;
import com.gridnine.xtrip.server.pool.PoolManager;
import com.gridnine.xtrip.server.pool.PooledResourceManager;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.zookeeper.KeeperException;
import org.java.plugin.util.ExtendedProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DistributedPoolManager
implements PoolManager,
Disposable {
    protected static final Logger log = LoggerFactory.getLogger(DistributedPoolManager.class);
    private static final boolean TRACE = true;
    private static final String POOL_PATH = "/xtrip/pools/";
    private static final String POOL_LOCK_NAME = "POOL_%s";
    private static final String POOL_RESOURCE_LOCK_NAME = "POOL_RESOURCE_%s";
    private static final String MAIN_ZOOKEEPER_URL_PROPERTY = "zookeeper.url";
    private static final String LOCAL_ZOOKEEPER_URL_PROPERTY = "pool.zookeeper.url";
    private static final int DEFAULT_TIMEOUT = 10;
    protected volatile ZooKeeperClient client;
    private static final String POOL_METRICS = "profiling.pool";
    protected volatile boolean closed = false;
    private static final Random RANDOM = new Random();
    private static final String RESOURCE_NODE_NAME = "resource";
    protected static final byte[] SIGN_V1 = new byte[]{37, 7, 1, 0};

    private static String getURL() {
        ExtendedProperties properties = ServerConfiguration.get().getConfiguration();
        String url = properties.getProperty(LOCAL_ZOOKEEPER_URL_PROPERTY);
        if (url != null) {
            return url;
        }
        return properties.getProperty(MAIN_ZOOKEEPER_URL_PROPERTY);
    }

    public DistributedPoolManager() {
        this(DistributedPoolManager.getURL());
    }

    public DistributedPoolManager(String url) {
        if (TextUtil.isBlank((String)url)) {
            throw new IllegalArgumentException("url not specified");
        }
        log.info("initialize pool manager at " + url);
        this.client = ZooKeeperFactory.getInstance(url);
        log.info("pool manager connected to " + url);
    }

    public void close() {
        if (log.isDebugEnabled()) {
            log.debug("close pool");
        }
        this.closed = true;
        ZooKeeperFactory.release(this.client);
        log.info("pool manager closed");
    }

    public void dispose() {
        this.close();
    }

    /*
     * Exception decompiling
     */
    protected <R extends Identity & Serializable> R internalAcquire(PooledResourceManager<R> resourceManager, long deadline) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 40[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void syncRoot(String poolId, long deadline) throws InterruptedException, TimeoutException {
        String rootPath = POOL_PATH + DistributedPoolManager.prepareName(poolId);
        this.sync(rootPath, deadline, "profiling.pool." + DistributedPoolManager.encodeMetricsKey(poolId) + ".internal.sync-root");
    }

    private boolean isLimited(int limit) {
        return limit > 0 && limit != Integer.MAX_VALUE;
    }

    private void checkLimit(String poolId, int acquiredCount, int limit) throws ExhaustedException {
        if (acquiredCount >= limit) {
            log.error("checkLimit() pool {} is exhausted, size is {}", (Object)poolId, (Object)limit);
            Metrics.get().event("profiling.pool." + DistributedPoolManager.encodeMetricsKey(poolId) + ".internal.exhausted");
            throw new ExhaustedException(Xeption.forEndUser((String)"pool {0} is exhausted, size is {1}", (Object[])new Object[]{poolId, limit}));
        }
    }

    private void beginLock(NamedLock lock, long deadline, String poolId) throws InterruptedException, TimeoutException {
        if (deadline > 0L) {
            if (log.isDebugEnabled() && log.isDebugEnabled()) {
                log.debug("try to lock... (lock {}, pool {})", lock.getName(), (Object)poolId);
            }
            if (!lock.tryLock(deadline - System.currentTimeMillis(), TimeUnit.MILLISECONDS)) {
                if (log.isDebugEnabled()) {
                    log.error("timeout (lock {}, pool {})", lock.getName(), (Object)poolId);
                }
                throw new TimeoutException();
            }
        } else {
            if (log.isDebugEnabled()) {
                log.debug("beginLock() lock... (lock {}, pool {})", lock.getName(), (Object)poolId);
            }
            lock.lockInterruptibly();
        }
        if (log.isDebugEnabled()) {
            log.debug("locked (lock {}, pool {})", lock.getName(), (Object)poolId);
        }
    }

    private boolean beginLock2(NamedLock lock, String poolId) throws InterruptedException {
        if (log.isDebugEnabled() && log.isDebugEnabled()) {
            log.debug("try to lock... (lock {}, pool {})", lock.getName(), (Object)poolId);
        }
        if (!lock.tryLock(1L, TimeUnit.MILLISECONDS)) {
            return false;
        }
        if (log.isDebugEnabled()) {
            log.debug("locked (lock {}, pool {})", lock.getName(), (Object)poolId);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <R extends Identity & Serializable> boolean isDataExpired(PooledResourceManager<R> resourceManager, String poolId, Data<R> data, long deadline) throws Exception {
        if (!data.isExpired()) {
            return false;
        }
        Throwable throwable = null;
        try (NamedLock lock = data.createLock();){
            boolean bl;
            block33: {
                boolean bl2;
                if (log.isDebugEnabled()) {
                    log.debug("isDataExpired() data locking... (uid {}, pool {})", (Object)data.getUid(), (Object)poolId);
                }
                if (!this.beginLock2(lock, poolId)) {
                    boolean bl3 = false;
                    return bl3;
                }
                try {
                    if (log.isDebugEnabled()) {
                        log.debug("isDataExpired() data locked (uid {}, pool {})", (Object)data.getUid(), (Object)poolId);
                    }
                    if (data.upToDate(deadline)) break block33;
                    bl2 = true;
                }
                catch (Throwable throwable2) {
                    try {
                        if (log.isDebugEnabled()) {
                            log.debug("isDataExpired() data unlocking... (uid {}, pool {})", (Object)data.getUid(), (Object)poolId);
                        }
                        lock.unlock();
                        if (log.isDebugEnabled()) {
                            log.debug("isDataExpired() data locked (uid {}, pool {})", (Object)data.getUid(), (Object)poolId);
                        }
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        throwable = throwable3;
                        throw throwable3;
                    }
                }
                if (log.isDebugEnabled()) {
                    log.debug("isDataExpired() data unlocking... (uid {}, pool {})", (Object)data.getUid(), (Object)poolId);
                }
                lock.unlock();
                if (log.isDebugEnabled()) {
                    log.debug("isDataExpired() data locked (uid {}, pool {})", (Object)data.getUid(), (Object)poolId);
                }
                return bl2;
            }
            if (log.isDebugEnabled()) {
                log.debug("isDataExpired() data validated (uid {}, pool {})", (Object)data.getUid(), (Object)poolId);
            }
            boolean bl4 = bl = !data.exists() || this.checkResourceExpired(resourceManager, poolId, data, deadline);
            if (log.isDebugEnabled()) {
                log.debug("isDataExpired() data unlocking... (uid {}, pool {})", (Object)data.getUid(), (Object)poolId);
            }
            lock.unlock();
            if (log.isDebugEnabled()) {
                log.debug("isDataExpired() data locked (uid {}, pool {})", (Object)data.getUid(), (Object)poolId);
            }
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <R extends Identity & Serializable> boolean checkResourceExpired(PooledResourceManager<R> resourceManager, String poolId, Data<R> data, long deadline) throws Exception {
        if (!data.isExpired()) {
            return false;
        }
        Metrics.get().event("profiling.pool." + DistributedPoolManager.encodeMetricsKey(poolId) + ".internal.expired");
        if (log.isDebugEnabled()) {
            log.debug("checkResourceExpired() get resource (uid {}, pool {})", (Object)data.getUid(), (Object)poolId);
        }
        R resource = data.getResource(deadline);
        if (log.isDebugEnabled()) {
            log.debug("checkResourceExpired() remove data (uid {}, pool {})", (Object)data.getUid(), (Object)poolId);
        }
        data.remove();
        if (null == resource) {
            log.error("empty pool node detected (uid {}, pool {})", (Object)data.getUid(), (Object)poolId);
            return true;
        }
        if (log.isDebugEnabled()) {
            log.debug("checkResourceExpired() resource manager expired... (uid {}, pool {})", (Object)data.getUid(), (Object)poolId);
        }
        long timing = System.currentTimeMillis();
        try {
            resourceManager.expired(resource, Math.max(deadline - System.currentTimeMillis(), TimeUnit.SECONDS.toMillis(10L)), TimeUnit.MILLISECONDS);
        }
        finally {
            Metrics.get().timing("profiling.pool." + DistributedPoolManager.encodeMetricsKey(poolId) + ".internal.expired", timing);
        }
        if (log.isDebugEnabled()) {
            log.debug("checkResourceExpired() resource manager expired done (uid {}, pool {})", (Object)data.getUid(), (Object)poolId);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <R extends Identity & Serializable> R acquireResource(PooledResourceManager<R> resourceManager, String poolId, Data<R> data, long deadline) throws Exception {
        if (data.isAcquired()) {
            return null;
        }
        Throwable throwable = null;
        try (NamedLock lock = data.createLock();){
            R resource;
            block64: {
                block63: {
                    block62: {
                        block61: {
                            block60: {
                                R r;
                                if (log.isDebugEnabled()) {
                                    log.debug("acquireResource() data locking... (uid {}, pool {})", (Object)data.getUid(), (Object)poolId);
                                }
                                if (!this.beginLock2(lock, poolId)) {
                                    R r2 = null;
                                    return r2;
                                }
                                try {
                                    if (log.isDebugEnabled()) {
                                        log.debug("acquireResource() data locked (uid {}, pool {})", (Object)data.getUid(), (Object)poolId);
                                    }
                                    if (data.upToDate(deadline)) break block60;
                                    r = null;
                                }
                                catch (Throwable throwable2) {
                                    try {
                                        if (log.isDebugEnabled()) {
                                            log.debug("acquireResource() data unlocking... (uid {}, pool {})", (Object)data.getUid(), (Object)poolId);
                                        }
                                        lock.unlock();
                                        if (log.isDebugEnabled()) {
                                            log.debug("acquireResource() data unlocked (uid {}, pool {})", (Object)data.getUid(), (Object)poolId);
                                        }
                                        throw throwable2;
                                    }
                                    catch (Throwable throwable3) {
                                        throwable = throwable3;
                                        throw throwable3;
                                    }
                                }
                                if (log.isDebugEnabled()) {
                                    log.debug("acquireResource() data unlocking... (uid {}, pool {})", (Object)data.getUid(), (Object)poolId);
                                }
                                lock.unlock();
                                if (log.isDebugEnabled()) {
                                    log.debug("acquireResource() data unlocked (uid {}, pool {})", (Object)data.getUid(), (Object)poolId);
                                }
                                return r;
                            }
                            if (log.isDebugEnabled()) {
                                log.debug("acquireResource() data validated (uid {}, pool {})", (Object)data.getUid(), (Object)poolId);
                            }
                            if (!data.isAcquired() && data.exists()) break block61;
                            R r = null;
                            if (log.isDebugEnabled()) {
                                log.debug("acquireResource() data unlocking... (uid {}, pool {})", (Object)data.getUid(), (Object)poolId);
                            }
                            lock.unlock();
                            if (log.isDebugEnabled()) {
                                log.debug("acquireResource() data unlocked (uid {}, pool {})", (Object)data.getUid(), (Object)poolId);
                            }
                            return r;
                        }
                        if (!this.checkResourceExpired(resourceManager, poolId, data, deadline)) break block62;
                        R r = null;
                        if (log.isDebugEnabled()) {
                            log.debug("acquireResource() data unlocking... (uid {}, pool {})", (Object)data.getUid(), (Object)poolId);
                        }
                        lock.unlock();
                        if (log.isDebugEnabled()) {
                            log.debug("acquireResource() data unlocked (uid {}, pool {})", (Object)data.getUid(), (Object)poolId);
                        }
                        return r;
                    }
                    if (log.isDebugEnabled()) {
                        log.debug("acquireResource() get resource... (uid {}, pool {})", (Object)data.getUid(), (Object)poolId);
                    }
                    if (null != (resource = data.getResource(deadline))) break block63;
                    log.error("empty pool node detected (uid {}, pool {})", (Object)data.getUid(), (Object)poolId);
                    data.remove();
                    R r = null;
                    if (log.isDebugEnabled()) {
                        log.debug("acquireResource() data unlocking... (uid {}, pool {})", (Object)data.getUid(), (Object)poolId);
                    }
                    lock.unlock();
                    if (log.isDebugEnabled()) {
                        log.debug("acquireResource() data unlocked (uid {}, pool {})", (Object)data.getUid(), (Object)poolId);
                    }
                    return r;
                }
                log.debug("acquireResource() resource manager acquired... (pool {})", (Object)poolId);
                data.setExpiredAfter(resourceManager.acquired(resource, Math.max(deadline - System.currentTimeMillis(), TimeUnit.SECONDS.toMillis(10L)), TimeUnit.MILLISECONDS));
                log.debug("acquireResource() resource manager acquired done (pool {})", (Object)poolId);
                if (!this.checkResourceExpired(resourceManager, poolId, data, deadline)) break block64;
                R r = null;
                if (log.isDebugEnabled()) {
                    log.debug("acquireResource() data unlocking... (uid {}, pool {})", (Object)data.getUid(), (Object)poolId);
                }
                lock.unlock();
                if (log.isDebugEnabled()) {
                    log.debug("acquireResource() data unlocked (uid {}, pool {})", (Object)data.getUid(), (Object)poolId);
                }
                return r;
            }
            data.setAcquired(true);
            if (log.isDebugEnabled()) {
                log.debug("acquireResource() update data... (uid {}, pool {})", (Object)data.getUid(), (Object)poolId);
            }
            data.update();
            if (log.isDebugEnabled()) {
                log.debug("acquireResource() resource acquired (uid {}, pool {})", (Object)data.getUid(), (Object)poolId);
            }
            R r = resource;
            if (log.isDebugEnabled()) {
                log.debug("acquireResource() data unlocking... (uid {}, pool {})", (Object)data.getUid(), (Object)poolId);
            }
            lock.unlock();
            if (log.isDebugEnabled()) {
                log.debug("acquireResource() data unlocked (uid {}, pool {})", (Object)data.getUid(), (Object)poolId);
            }
            return r;
        }
    }

    @Override
    public <R extends Identity & Serializable> R acquire(PooledResourceManager<R> resourceManager) throws Exception {
        return this.acquire(resourceManager, 0L, null);
    }

    @Override
    public <R extends Identity & Serializable> R acquire(PooledResourceManager<R> resourceManager, long time, TimeUnit unit) throws Exception {
        String poolId = resourceManager.getPoolId();
        Metrics.get().event("profiling.pool." + DistributedPoolManager.encodeMetricsKey(poolId) + ".acquire.all");
        long timing = System.currentTimeMillis();
        boolean success = false;
        try {
            long deadline;
            long l = deadline = time > 0L ? System.currentTimeMillis() + unit.toMillis(time) : -1L;
            while (true) {
                block11: {
                    R r;
                    if (Thread.interrupted()) {
                        throw new InterruptedException();
                    }
                    try {
                        R result = this.internalAcquire(resourceManager, deadline);
                        if (result == null) break block11;
                        success = true;
                        r = result;
                    }
                    catch (ExhaustedException e) {
                        Metrics.get().event("profiling.pool." + DistributedPoolManager.encodeMetricsKey(poolId) + ".acquire.exhausted");
                        if (deadline <= 0L || deadline >= System.currentTimeMillis()) break block11;
                        throw e;
                    }
                    return r;
                }
                if (log.isDebugEnabled()) {
                    log.debug("acquire() wait... (pool {})", (Object)poolId);
                }
                Thread.sleep(500 + RANDOM.nextInt(500));
            }
        }
        finally {
            Metrics.get().timing("profiling.pool." + DistributedPoolManager.encodeMetricsKey(poolId) + ".acquire.all", timing);
            if (success) {
                Metrics.get().timingAndEvent("profiling.pool." + DistributedPoolManager.encodeMetricsKey(poolId) + ".acquire.success", timing);
            } else {
                Metrics.get().timingAndEvent("profiling.pool." + DistributedPoolManager.encodeMetricsKey(poolId) + ".acquire.fail", timing);
            }
        }
    }

    @Override
    public <R extends Identity & Serializable> R get(String resourceUid, PooledResourceManager<R> resourceManager) throws Exception {
        return this.get(resourceUid, resourceManager, 0L, null);
    }

    /*
     * Exception decompiling
     */
    @Override
    public <R extends Identity & Serializable> R get(String resourceUid, PooledResourceManager<R> resourceManager, long time, TimeUnit unit) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public <R extends Identity & Serializable> void release(String resourceUid, PooledResourceManager<R> resourceManager) throws Exception {
        this.release((R)resourceUid, resourceManager, 0L, null);
    }

    /*
     * Exception decompiling
     */
    @Override
    public <R extends Identity & Serializable> void release(String resourceUid, PooledResourceManager<R> resourceManager, long time, TimeUnit unit) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public <R extends Identity & Serializable> void release(R resource, PooledResourceManager<R> resourceManager) throws Exception {
        this.release(resource, resourceManager, 0L, (TimeUnit)null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public <R extends Identity & Serializable> void release(R resource, PooledResourceManager<R> resourceManager, long time, TimeUnit unit) throws Exception {
        String poolId = resourceManager.getPoolId();
        long timing = System.currentTimeMillis();
        try {
            long deadline = time > 0L ? System.currentTimeMillis() + unit.toMillis(time) : -1L;
            Data<R> data = new Data<R>(poolId, resource.getUid());
            try (NamedLock lock = data.createLock();){
                if (log.isDebugEnabled()) {
                    log.debug("release2() data locking... (uid {}, pool {})", (Object)data.getUid(), (Object)poolId);
                }
                this.beginLock(lock, deadline, poolId);
                try {
                    if (log.isDebugEnabled()) {
                        log.debug("release2() data locked (uid {}, pool {})", (Object)data.getUid(), (Object)poolId);
                    }
                    if (!data.upToDate(deadline)) {
                        return;
                    }
                    if (log.isDebugEnabled()) {
                        log.debug("release2() data validated (uid {}, pool {})", (Object)data.getUid(), (Object)poolId);
                    }
                    if (!data.exists()) {
                        return;
                    }
                    if (data.isInternal()) {
                        throw new IllegalArgumentException();
                    }
                    if (!data.isAcquired()) {
                        return;
                    }
                    log.debug("release2() resource manager released... (uid {}, pool {})", (Object)resource.getUid(), (Object)poolId);
                    long timing2 = System.currentTimeMillis();
                    try {
                        data.setExpiredAfter(resourceManager.released(resource, Math.max(deadline - System.currentTimeMillis(), TimeUnit.SECONDS.toMillis(10L)), TimeUnit.MILLISECONDS));
                    }
                    finally {
                        Metrics.get().timingAndEvent("profiling.pool." + DistributedPoolManager.encodeMetricsKey(poolId) + ".internal.released", timing2);
                    }
                    log.debug("release2() resource manager released (uid {}, pool {})", (Object)resource.getUid(), (Object)poolId);
                    if (this.checkResourceExpired(resourceManager, poolId, data, deadline)) {
                        return;
                    }
                    data.setResource(resource);
                    data.setAcquired(false);
                    if (log.isDebugEnabled()) {
                        log.debug("release2() update data... (uid {}, pool {})", (Object)data.getUid(), (Object)poolId);
                    }
                    data.update();
                    if (!log.isDebugEnabled()) return;
                    log.debug("release2() data updated... (uid {}, pool {})", (Object)data.getUid(), (Object)poolId);
                    return;
                }
                finally {
                    if (log.isDebugEnabled()) {
                        log.debug("release2() data unlocking... (uid {}, pool {})", (Object)data.getUid(), (Object)poolId);
                    }
                    lock.unlock();
                    if (log.isDebugEnabled()) {
                        log.debug("release2() data unlocked (uid {}, pool {})", (Object)data.getUid(), (Object)poolId);
                    }
                }
            }
        }
        finally {
            Metrics.get().timingAndEvent("profiling.pool." + DistributedPoolManager.encodeMetricsKey(poolId) + ".release", timing);
        }
    }

    @Override
    public <R extends Identity & Serializable> Collection<PoolManager.Info> stats(PooledResourceManager<R> resourceManager) throws Exception {
        return this.stats(resourceManager, 0L, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <R extends Identity & Serializable> Collection<PoolManager.Info> stats(PooledResourceManager<R> resourceManager, long time, TimeUnit unit) throws Exception {
        String poolId = resourceManager.getPoolId();
        long timing = System.currentTimeMillis();
        try {
            ArrayList<PoolManager.Info> result = new ArrayList<PoolManager.Info>();
            log.debug("stats() get data... (pool {})", (Object)poolId);
            DataIterator resources = new DataIterator(poolId);
            log.debug("stats() data where obtained (pool {})", (Object)poolId);
            while (resources.hasNext()) {
                if (Thread.interrupted()) {
                    throw new InterruptedException();
                }
                Object data = resources.next();
                if (((Data)data).isInternal()) continue;
                result.add(new ResourceInfo(((Data)data).getUid(), ((Data)data).isAcquired(), new Date(((Data)data).getExpiredAfter())));
            }
            log.debug("stats() done (pool {})", (Object)poolId);
            ArrayList<PoolManager.Info> arrayList = result;
            return arrayList;
        }
        finally {
            Metrics.get().timingAndEvent("profiling.pool." + DistributedPoolManager.encodeMetricsKey(poolId) + ".stats", timing);
        }
    }

    @Override
    public <R extends Identity & Serializable> Collection<R> resources(PooledResourceManager<R> resourceManager) throws Exception {
        return this.resources(resourceManager, 0L, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <R extends Identity & Serializable> Collection<R> resources(PooledResourceManager<R> resourceManager, long time, TimeUnit unit) throws Exception {
        String poolId = resourceManager.getPoolId();
        long timing = System.currentTimeMillis();
        try {
            long deadline = time > 0L ? System.currentTimeMillis() + unit.toMillis(time) : -1L;
            ArrayList result = new ArrayList();
            log.debug("resources() get resources... (pool {})", (Object)poolId);
            DataIterator resources = new DataIterator(poolId);
            log.debug("resources() get resources done (pool {})", (Object)poolId);
            while (resources.hasNext()) {
                if (Thread.interrupted()) {
                    throw new InterruptedException();
                }
                Object data = resources.next();
                if (((Data)data).isInternal()) continue;
                if (log.isDebugEnabled()) {
                    log.debug("resources() get data resource... (uid {}, pool {})", (Object)((Data)data).getUid(), (Object)poolId);
                }
                Object resource = ((Data)data).getResource(deadline);
                if (log.isDebugEnabled()) {
                    log.debug("resources() have got data resource (uid {}, pool {})", (Object)((Data)data).getUid(), (Object)poolId);
                }
                if (null == resource) continue;
                result.add(resource);
            }
            log.debug("resources() done (pool {})", (Object)poolId);
            ArrayList arrayList = result;
            return arrayList;
        }
        finally {
            Metrics.get().timingAndEvent("profiling.pool." + DistributedPoolManager.encodeMetricsKey(poolId) + ".resources", timing);
        }
    }

    @Override
    public <R extends Identity & Serializable> void remove(R resource, PooledResourceManager<R> resourceManager) throws Exception {
        this.remove(resource, resourceManager, 0L, (TimeUnit)null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public <R extends Identity & Serializable> void remove(R resource, PooledResourceManager<R> resourceManager, long time, TimeUnit unit) throws Exception {
        String poolId = resourceManager.getPoolId();
        long timing = System.currentTimeMillis();
        try {
            long deadline = time > 0L ? System.currentTimeMillis() + unit.toMillis(time) : -1L;
            Data data = new Data(poolId, resource.getUid());
            try (NamedLock lock = data.createLock();){
                if (log.isDebugEnabled()) {
                    log.debug("remove() data locking... (uid {}, pool {})", (Object)data.getUid(), (Object)poolId);
                }
                this.beginLock(lock, deadline, poolId);
                try {
                    if (log.isDebugEnabled()) {
                        log.debug("remove() data locked (uid {}, pool {})", (Object)data.getUid(), (Object)poolId);
                    }
                    if (!data.upToDate(deadline)) {
                        return;
                    }
                    if (log.isDebugEnabled()) {
                        log.debug("remove() data validated (uid {}, pool {})", (Object)data.getUid(), (Object)poolId);
                    }
                    if (!data.exists()) {
                        return;
                    }
                    if (data.isInternal()) {
                        throw new IllegalArgumentException();
                    }
                    if (log.isDebugEnabled()) {
                        log.debug("remove() removing data... (uid {}, pool {})", (Object)data.getUid(), (Object)poolId);
                    }
                    data.remove();
                    if (!log.isDebugEnabled()) return;
                    log.debug("remove() data removed (uid {}, pool {})", (Object)data.getUid(), (Object)poolId);
                    return;
                }
                finally {
                    if (log.isDebugEnabled()) {
                        log.debug("remove() data unlocking... (uid {}, pool {})", (Object)data.getUid(), (Object)poolId);
                    }
                    lock.unlock();
                    if (log.isDebugEnabled()) {
                        log.debug("remove() data unlocked (uid {}, pool {})", (Object)data.getUid(), (Object)poolId);
                    }
                }
            }
        }
        finally {
            Metrics.get().timingAndEvent("profiling.pool." + DistributedPoolManager.encodeMetricsKey(poolId) + ".remove", timing);
        }
    }

    protected boolean exists(String nodePath) throws KeeperException, InterruptedException {
        log.trace("check exists node " + nodePath);
        boolean result = this.client.exists(nodePath);
        log.trace("node " + nodePath + (result ? "" : " not") + " exists");
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void remove(String poolId, String nodePath) throws InterruptedException, KeeperException {
        long timing = System.currentTimeMillis();
        try {
            log.trace("remove node " + nodePath);
            ZooUtil.deletePath(this.client, nodePath);
            log.trace("node " + nodePath + " removed");
        }
        finally {
            Metrics.get().timingAndEvent("profiling.pool." + DistributedPoolManager.encodeMetricsKey(poolId) + ".internal.node.remove", timing);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void createNode(String poolId, String poolNodePath, String nodePath, byte[] bytes) throws KeeperException, InterruptedException {
        long timing = System.currentTimeMillis();
        try {
            log.trace("create node " + nodePath);
            ZooUtil.ensurePersistentPathExists(this.client, poolNodePath);
            this.client.createPersistent(nodePath, bytes);
            log.trace("node " + nodePath + " created");
        }
        finally {
            Metrics.get().timingAndEvent("profiling.pool." + DistributedPoolManager.encodeMetricsKey(poolId) + ".internal.node.create", timing);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateNode(String poolId, String nodePath, byte[] bytes) throws KeeperException, InterruptedException {
        long timing = System.currentTimeMillis();
        try {
            log.trace("update node " + nodePath);
            this.client.setData(nodePath, bytes);
            log.trace("node " + nodePath + " updated");
        }
        finally {
            Metrics.get().timingAndEvent("profiling.pool." + DistributedPoolManager.encodeMetricsKey(poolId) + ".internal.node.update", timing);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected byte[] readNode(String poolId, String nodePath) throws KeeperException, InterruptedException {
        long timing = System.currentTimeMillis();
        try {
            byte[] nodeData = this.client.getData(nodePath);
            if (nodeData == null) {
                log.trace("node " + nodePath + " data is null");
            }
            byte[] byArray = nodeData;
            return byArray;
        }
        finally {
            Metrics.get().timingAndEvent("profiling.pool." + DistributedPoolManager.encodeMetricsKey(poolId) + ".internal.node.get", timing);
        }
    }

    /*
     * Exception decompiling
     */
    protected <R extends Identity & Serializable> R readResource(String poolId, String nodePath) throws KeeperException, InterruptedException, IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <R extends Identity & Serializable> void createResource(String poolId, String resourceNodePath, R resource) throws Exception {
        long timing = System.currentTimeMillis();
        try {
            byte[] bytes;
            log.trace("create resource " + resourceNodePath);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            try (ObjectOutputStream out = new ObjectOutputStream((OutputStream)baos);){
                out.writeObject(resource);
                log.trace("resource " + resourceNodePath + " written");
                bytes = baos.toByteArray();
            }
            if (!this.client.exists(resourceNodePath)) {
                this.client.createPersistent(resourceNodePath, bytes);
            } else {
                this.client.setData(resourceNodePath, bytes);
            }
            log.trace("resource " + resourceNodePath + " created");
        }
        finally {
            Metrics.get().timingAndEvent("profiling.pool." + DistributedPoolManager.encodeMetricsKey(poolId) + ".internal.node.resource.update", timing);
        }
    }

    protected static String encodeMetricsKey(String key) {
        return Metrics.cleanKeyPart(key.replace(".", "-"));
    }

    protected NamedLock createPoolLock(String poolId) throws Exception {
        return LockUtil.getLockManager().getLock((Object)String.format(POOL_LOCK_NAME, poolId));
    }

    protected void sync(String nodePath, long deadline, String metrics) throws InterruptedException, TimeoutException {
        long timing = System.currentTimeMillis();
        boolean success = false;
        try {
            long timeout;
            log.trace("sync...");
            long l = timeout = deadline > 0L ? Math.max(deadline - System.currentTimeMillis(), 250L) : 0L;
            if (!this.client.sync(nodePath, timeout, TimeUnit.MILLISECONDS)) {
                throw new TimeoutException();
            }
            log.trace("sync: released");
            success = true;
        }
        catch (TimeoutException t) {
            Metrics.get().timingAndEvent(metrics + ".timeout", timing);
            throw t;
        }
        finally {
            Metrics.get().timingAndEvent(metrics + ".all", timing);
            if (success) {
                Metrics.get().timingAndEvent(metrics + ".success", timing);
            } else {
                Metrics.get().timingAndEvent(metrics + ".fail", timing);
            }
        }
    }

    protected static String prepareName(String name) {
        return String.valueOf(name).replace("$", "$$").replace("\\", "$1").replace("/", "$2").replace(".", "$-");
    }

    protected static String extractName(String nodeName) {
        StringBuilder sb = new StringBuilder();
        block6: for (int i = 0; i < nodeName.length(); ++i) {
            char c = nodeName.charAt(i);
            if (c != '$' || i + 1 == nodeName.length()) {
                sb.append(c);
                continue;
            }
            c = nodeName.charAt(++i);
            switch (c) {
                case '1': {
                    sb.append("\\");
                    continue block6;
                }
                case '2': {
                    sb.append("/");
                    continue block6;
                }
                case '-': {
                    sb.append(".");
                    continue block6;
                }
                case '$': {
                    sb.append("$");
                    continue block6;
                }
                default: {
                    throw new IllegalArgumentException("Invalid node name: " + nodeName);
                }
            }
        }
        return sb.toString();
    }

    private class DataIterator<R extends Identity & Serializable>
    implements Iterator<Data<R>> {
        private final String poolId;
        private final String nodePath;
        private final Iterator<String> nodes;
        private Data<R> item;
        private boolean loaded;

        public DataIterator(String poolId) throws Exception {
            List<String> nodes;
            String nodePath;
            this.poolId = poolId;
            this.nodePath = nodePath = DistributedPoolManager.POOL_PATH + DistributedPoolManager.prepareName(poolId);
            try {
                nodes = DistributedPoolManager.this.client.getChildren(nodePath);
            }
            catch (KeeperException.NoNodeException e) {
                nodes = null;
                log.trace("no node found");
            }
            this.nodes = nodes != null ? nodes.iterator() : null;
            Metrics.get().value("profiling.pool." + DistributedPoolManager.encodeMetricsKey(poolId) + ".internal.node.size", nodes != null ? (long)nodes.size() : 0L);
        }

        @Override
        public boolean hasNext() {
            if (null == this.nodes) {
                return false;
            }
            if (this.loaded) {
                return this.item != null;
            }
            while (this.nodes.hasNext()) {
                String node = this.nodes.next();
                try {
                    this.item = new Data(this.poolId, this.nodePath, node, true);
                    this.loaded = true;
                    return true;
                }
                catch (IllegalStateException e) {
                }
                catch (KeeperException.NoNodeException e) {
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new IllegalStateException(e);
                }
            }
            return false;
        }

        @Override
        public Data<R> next() {
            do {
                if (!this.loaded) continue;
                Data<R> result = this.item;
                this.item = null;
                this.loaded = false;
                return result;
            } while (this.hasNext());
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            Object item = this.next();
            try {
                ((Data)item).remove();
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        }
    }

    private static class ResourceInfo
    implements PoolManager.Info {
        private final String uid;
        private final boolean acquired;
        private final Date expiredAfter;

        public ResourceInfo(String uid, boolean acquired, Date expiredAfter) {
            this.uid = uid;
            this.acquired = acquired;
            this.expiredAfter = expiredAfter;
        }

        @Override
        public String getUid() {
            return this.uid;
        }

        @Override
        public boolean isAcquired() {
            return this.acquired;
        }

        @Override
        public Date getExpiredAfter() {
            return this.expiredAfter;
        }
    }

    private class Data<R extends Identity & Serializable> {
        private final String poolId;
        private final String rootPath;
        private final String nodePath;
        private final String uid;
        private long expiredAfter;
        private boolean acquired;
        private boolean internal;

        public Data(String poolId) {
            this.poolId = poolId;
            this.uid = UUIDGenerator.generate((boolean)true).toString();
            this.rootPath = DistributedPoolManager.POOL_PATH + DistributedPoolManager.prepareName(poolId);
            this.nodePath = this.rootPath + "/" + DistributedPoolManager.prepareName(this.uid);
            this.internal = true;
        }

        public Data(String poolId, String uid) {
            this.poolId = poolId;
            this.rootPath = DistributedPoolManager.POOL_PATH + DistributedPoolManager.prepareName(poolId);
            this.nodePath = this.rootPath + "/" + DistributedPoolManager.prepareName(uid);
            this.uid = uid;
            this.internal = false;
        }

        public Data(String poolId, String rootPath, String nodeName, boolean iterator) throws IOException, KeeperException, InterruptedException {
            this.poolId = poolId;
            this.rootPath = rootPath;
            this.nodePath = rootPath + "/" + nodeName;
            this.uid = DistributedPoolManager.extractName(nodeName);
            this.load(DistributedPoolManager.this.readNode(poolId, this.nodePath));
        }

        public String getUid() {
            return this.uid;
        }

        public boolean isExpired() {
            return this.expiredAfter > 0L && System.currentTimeMillis() >= this.expiredAfter;
        }

        public long getExpiredAfter() {
            return this.expiredAfter;
        }

        public void setExpiredAfter(long expiredAfter) {
            this.expiredAfter = expiredAfter;
        }

        public boolean isInternal() {
            return this.internal;
        }

        public boolean isAcquired() {
            return this.acquired;
        }

        public void setAcquired(boolean acquired) {
            this.acquired = acquired;
        }

        public boolean upToDate(long deadline) throws InterruptedException, TimeoutException, IOException, KeeperException {
            DistributedPoolManager.this.sync(this.nodePath, deadline, "profiling.pool." + DistributedPoolManager.encodeMetricsKey(this.poolId) + ".internal.node.sync");
            try {
                this.load(DistributedPoolManager.this.readNode(this.poolId, this.nodePath));
                return true;
            }
            catch (KeeperException.NoNodeException e) {
                return false;
            }
        }

        public R getResource(long deadline) throws InterruptedException, TimeoutException, KeeperException, IOException {
            String resourceNodePath = this.nodePath + "/" + DistributedPoolManager.RESOURCE_NODE_NAME;
            DistributedPoolManager.this.sync(resourceNodePath, deadline, "profiling.pool." + DistributedPoolManager.encodeMetricsKey(this.poolId) + ".internal.node.sync");
            try {
                return DistributedPoolManager.this.readResource(this.poolId, resourceNodePath);
            }
            catch (KeeperException.NoNodeException e) {
                return null;
            }
        }

        public void setResource(R resource) throws Exception {
            DistributedPoolManager.this.createResource(this.poolId, this.nodePath + "/" + DistributedPoolManager.RESOURCE_NODE_NAME, resource);
        }

        public NamedLock createLock() throws Exception {
            return LockUtil.getLockManager().getLock((Object)String.format(DistributedPoolManager.POOL_RESOURCE_LOCK_NAME, this.uid));
        }

        public boolean exists() throws KeeperException, InterruptedException {
            return DistributedPoolManager.this.exists(this.nodePath);
        }

        public void create() throws KeeperException, InterruptedException, IOException {
            DistributedPoolManager.this.createNode(this.poolId, this.rootPath, this.nodePath, this.toBytes());
        }

        public void update() throws KeeperException, InterruptedException, IOException {
            DistributedPoolManager.this.updateNode(this.poolId, this.nodePath, this.toBytes());
        }

        public void remove() throws InterruptedException, KeeperException {
            DistributedPoolManager.this.remove(this.poolId, this.nodePath);
        }

        protected byte[] toBytes() throws IOException {
            try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
                DataOutputStream out = new DataOutputStream((OutputStream)baos);
                out.write(SIGN_V1);
                out.writeBoolean(this.acquired);
                out.writeLong(this.expiredAfter);
                out.writeBoolean(this.internal);
                out.flush();
                byte[] byArray = baos.toByteArray();
                return byArray;
            }
        }

        protected void load(byte[] bytes) throws IOException, InterruptedException, KeeperException {
            DataInputStream in = new DataInputStream(new ByteArrayInputStream(bytes));
            byte[] sign = new byte[SIGN_V1.length];
            if (in.read(sign) != sign.length) {
                this.remove();
                throw new IllegalStateException();
            }
            if (!Arrays.equals(SIGN_V1, sign)) {
                this.remove();
                throw new IllegalStateException();
            }
            this.acquired = in.readBoolean();
            this.expiredAfter = in.readLong();
            this.internal = in.readBoolean();
        }
    }
}

