/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.pool;

import com.gridnine.xtrip.common.Disposable;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.util.Identity;
import com.gridnine.xtrip.server.pool.ExhaustedException;
import com.gridnine.xtrip.server.pool.PoolManager;
import com.gridnine.xtrip.server.pool.PooledResourceManager;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;

public class LocalPoolManager
implements PoolManager,
Disposable {
    private static final long DEFAULT_TIMEOUT = 10L;
    private final ConcurrentMap<String, Queue<Entry<?>>> available = new ConcurrentHashMap();
    private final ConcurrentMap<String, ConcurrentMap<String, Entry<?>>> acquired = new ConcurrentHashMap();

    @Override
    public <R extends Identity & Serializable> R acquire(PooledResourceManager<R> resourceManager) throws Exception {
        return this.acquire(resourceManager, 0L, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public <R extends Identity & Serializable> R acquire(PooledResourceManager<R> resourceManager, long time, TimeUnit unit) throws Exception {
        Queue<Entry<R>> queue = this.getQueue(resourceManager.getPoolId());
        ConcurrentMap<String, Entry<R>> map = this.getAcquired(resourceManager.getPoolId());
        Entry<R> entry = null;
        long timing = System.currentTimeMillis();
        boolean doPause = false;
        while (true) {
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            if (doPause) {
                doPause = false;
                Thread.sleep(1000L);
            }
            Queue<Entry<R>> queue2 = queue;
            synchronized (queue2) {
                while (!queue.isEmpty() && (entry = queue.remove()).isExpired()) {
                    resourceManager.expired(entry.resource, 10L, TimeUnit.SECONDS);
                    entry = null;
                }
                boolean newEntry = false;
                if (entry == null) {
                    if (this.isExhausted(map, resourceManager)) {
                        if (time <= 0L || System.currentTimeMillis() - timing > unit.toMillis(time)) {
                            throw new ExhaustedException(Xeption.forAdmin((String)"pool {0} is exhausted, size is {1}", (Object[])new Object[]{resourceManager.getPoolId(), resourceManager.getSize()}));
                        }
                        doPause = true;
                        continue;
                    }
                    newEntry = true;
                    entry = new Entry(resourceManager.createNew(10L, TimeUnit.SECONDS));
                }
                entry.expiredAfter = resourceManager.acquired(entry.resource, 10L, TimeUnit.SECONDS);
                if (!entry.isExpired()) {
                    map.put(entry.resource.getUid(), entry);
                    return entry.resource;
                }
                if (newEntry) {
                    throw Xeption.forAdmin((String)"initially expired entry was created in pool {0}", (Object[])new Object[]{resourceManager.getPoolId()});
                }
                resourceManager.expired(entry.resource, 10L, TimeUnit.SECONDS);
                entry = null;
            }
        }
    }

    @Override
    public <R extends Identity & Serializable> R get(String resourceUid, PooledResourceManager<R> resourceManager) throws Exception {
        return this.get(resourceUid, resourceManager, 0L, null);
    }

    @Override
    public <R extends Identity & Serializable> R get(String resourceUid, PooledResourceManager<R> resourceManager, long time, TimeUnit unit) throws Exception {
        ConcurrentMap<String, Entry<R>> map = this.getAcquired(resourceManager.getPoolId());
        Entry entry = (Entry)map.get(resourceUid);
        if (entry == null) {
            return null;
        }
        if (entry.isExpired()) {
            map.remove(resourceUid);
            resourceManager.expired(entry.resource, 10L, TimeUnit.SECONDS);
            return null;
        }
        entry.expiredAfter = resourceManager.touched(entry.resource, 10L, TimeUnit.SECONDS);
        if (entry.isExpired()) {
            map.remove(resourceUid);
            resourceManager.expired(entry.resource, 10L, TimeUnit.SECONDS);
            return null;
        }
        return entry.resource;
    }

    @Override
    public <R extends Identity & Serializable> void release(String resourceUid, PooledResourceManager<R> resourceManager) throws Exception {
        this.release((R)resourceUid, resourceManager, 0L, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <R extends Identity & Serializable> void release(String resourceUid, PooledResourceManager<R> resourceManager, long time, TimeUnit unit) throws Exception {
        Queue<Entry<R>> queue = this.getQueue(resourceManager.getPoolId());
        ConcurrentMap<String, Entry<R>> map = this.getAcquired(resourceManager.getPoolId());
        Queue<Entry<R>> queue2 = queue;
        synchronized (queue2) {
            Entry entry = (Entry)map.remove(resourceUid);
            if (entry == null) {
                return;
            }
            if (entry.isExpired()) {
                resourceManager.expired(entry.resource, 10L, TimeUnit.SECONDS);
                return;
            }
            entry.expiredAfter = resourceManager.released(entry.resource, 10L, TimeUnit.SECONDS);
            if (!entry.isExpired()) {
                queue.add(entry);
            } else {
                resourceManager.expired(entry.resource, 10L, TimeUnit.SECONDS);
            }
        }
    }

    @Override
    public <R extends Identity & Serializable> void release(R resource, PooledResourceManager<R> resourceManager) throws Exception {
        this.release(resource, resourceManager, 0L, (TimeUnit)null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <R extends Identity & Serializable> void release(R resource, PooledResourceManager<R> resourceManager, long time, TimeUnit unit) throws Exception {
        Queue<Entry<R>> queue = this.getQueue(resourceManager.getPoolId());
        ConcurrentMap<String, Entry<R>> map = this.getAcquired(resourceManager.getPoolId());
        Queue<Entry<R>> queue2 = queue;
        synchronized (queue2) {
            Entry<R> entry = (Entry<R>)map.remove(resource.getUid());
            if (entry == null) {
                return;
            }
            entry = new Entry<R>(resource);
            entry.expiredAfter = resourceManager.released(entry.resource, 10L, TimeUnit.SECONDS);
            if (!entry.isExpired()) {
                queue.add(entry);
            } else {
                resourceManager.expired(entry.resource, 10L, TimeUnit.SECONDS);
            }
        }
    }

    @Override
    public <R extends Identity & Serializable> Collection<R> resources(PooledResourceManager<R> resourceManager) throws Exception {
        return this.resources(resourceManager, 0L, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <R extends Identity & Serializable> Collection<R> resources(PooledResourceManager<R> resourceManager, long time, TimeUnit unit) throws Exception {
        Queue<Entry<R>> queue = this.getQueue(resourceManager.getPoolId());
        ConcurrentMap<String, Entry<R>> map = this.getAcquired(resourceManager.getPoolId());
        Queue<Entry<R>> queue2 = queue;
        synchronized (queue2) {
            LinkedList result = new LinkedList();
            for (Entry entry : queue) {
                result.add(entry.resource);
            }
            for (Entry entry : map.values()) {
                result.add(entry.resource);
            }
            return result;
        }
    }

    @Override
    public <R extends Identity & Serializable> Collection<PoolManager.Info> stats(PooledResourceManager<R> resourceManager) throws Exception {
        return this.stats(resourceManager, 0L, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <R extends Identity & Serializable> Collection<PoolManager.Info> stats(PooledResourceManager<R> resourceManager, long time, TimeUnit unit) throws Exception {
        Queue<Entry<R>> queue = this.getQueue(resourceManager.getPoolId());
        ConcurrentMap<String, Entry<R>> map = this.getAcquired(resourceManager.getPoolId());
        Queue<Entry<R>> queue2 = queue;
        synchronized (queue2) {
            LinkedList<PoolManager.Info> result = new LinkedList<PoolManager.Info>();
            for (Entry entry : queue) {
                result.add(new ResourceInfo(entry.resource.getUid(), false, new Date(entry.expiredAfter)));
            }
            for (Entry entry : map.values()) {
                result.add(new ResourceInfo(entry.resource.getUid(), true, new Date(entry.expiredAfter)));
            }
            return result;
        }
    }

    @Override
    public <R extends Identity & Serializable> void remove(R resource, PooledResourceManager<R> resourceManager) throws Exception {
        this.remove(resource, resourceManager, 0L, (TimeUnit)null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <R extends Identity & Serializable> void remove(R resource, PooledResourceManager<R> resourceManager, long time, TimeUnit unit) throws Exception {
        Queue<Entry<R>> queue;
        Queue<Entry<R>> queue2 = queue = this.getQueue(resourceManager.getPoolId());
        synchronized (queue2) {
            for (Entry entry : queue) {
                if (entry.resource != resource) continue;
                queue.remove(entry);
                return;
            }
            ConcurrentMap<String, Entry<R>> map = this.getAcquired(resourceManager.getPoolId());
            for (Map.Entry entry : map.entrySet()) {
                if (((Entry)entry.getValue()).resource != resource) continue;
                map.remove(entry.getKey());
                return;
            }
        }
    }

    public void dispose() {
        this.acquired.clear();
        this.available.clear();
    }

    private <R extends Identity & Serializable> Queue<Entry<R>> getQueue(String poolId) {
        Queue prev;
        Queue result = (LinkedList)this.available.get(poolId);
        if (result == null && (prev = (Queue)this.available.putIfAbsent(poolId, result = new LinkedList())) != null) {
            result = prev;
        }
        return result;
    }

    private <R extends Identity & Serializable> ConcurrentMap<String, Entry<R>> getAcquired(String poolId) {
        ConcurrentMap prev;
        ConcurrentMap result = (ConcurrentHashMap)this.acquired.get(poolId);
        if (result == null && (prev = (ConcurrentMap)this.acquired.putIfAbsent(poolId, result = new ConcurrentHashMap())) != null) {
            result = prev;
        }
        return result;
    }

    private <R extends Identity & Serializable> boolean isExhausted(Map<String, Entry<R>> map, PooledResourceManager<R> resourceManager) throws Exception {
        if (map.size() < resourceManager.getSize()) {
            return false;
        }
        Iterator<Map.Entry<String, Entry<R>>> it = map.entrySet().iterator();
        while (it.hasNext()) {
            Entry<R> entry = it.next().getValue();
            if (!entry.isExpired()) continue;
            resourceManager.expired(entry.resource, 10L, TimeUnit.SECONDS);
            it.remove();
        }
        return map.size() >= resourceManager.getSize();
    }

    private static class ResourceInfo
    implements PoolManager.Info {
        private final String uid;
        private final boolean acquired;
        private final Date expiredAfter;

        ResourceInfo(String uid, boolean acquired, Date expiredAfter) {
            this.uid = uid;
            this.acquired = acquired;
            this.expiredAfter = expiredAfter;
        }

        @Override
        public String getUid() {
            return this.uid;
        }

        @Override
        public boolean isAcquired() {
            return this.acquired;
        }

        @Override
        public Date getExpiredAfter() {
            return this.expiredAfter;
        }
    }

    private static class Entry<R extends Identity & Serializable> {
        final R resource;
        long expiredAfter;

        Entry(R res) {
            this.resource = res;
        }

        boolean isExpired() {
            return this.expiredAfter > 0L && System.currentTimeMillis() >= this.expiredAfter;
        }
    }
}

