/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.pool;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.util.Identity;
import com.gridnine.xtrip.server.pool.PoolManager;
import com.gridnine.xtrip.server.pool.PooledResourceManager;
import com.gridnine.xtrip.server.pool.ResourcePoolInfo;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.function.BiFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PoolManagerMaintaince<R extends Identity & Serializable, S extends ResourcePoolInfo<R>> {
    private static Logger log = LoggerFactory.getLogger(PoolManagerMaintaince.class);

    public void removeSession(PooledResourceManager<R> manager, String uid, BiFunction<R, PoolManager.Info, S> elementBuilder, long time, TimeUnit unit) throws Exception {
        Optional<ResourcePoolInfo> resourceInfo = this.collectSessionData(manager, elementBuilder).stream().filter(info -> uid.equals(info.getInfo().getUid())).findFirst();
        if (resourceInfo.isPresent()) {
            this.removeSession(manager, resourceInfo.get().getResource(), time, unit);
        } else {
            log.warn("remove failed - session with uid [{}] not found", (Object)uid);
        }
    }

    public Collection<S> collectSessionData(PooledResourceManager<R> manager, BiFunction<R, PoolManager.Info, S> elementBuilder) throws Exception {
        PoolManager poolManager = this.getPoolManager();
        Collection<PoolManager.Info> stats = poolManager.stats(manager);
        ArrayList result = new ArrayList();
        for (Identity resource : poolManager.resources(manager)) {
            stats.stream().filter(info -> info.getUid().equals(resource.getUid())).findAny().map(info -> (ResourcePoolInfo)elementBuilder.apply((Object)resource, (PoolManager.Info)info)).ifPresent(result::add);
        }
        return result;
    }

    public long getAcquiredSessions(PooledResourceManager<R> manager) throws Exception {
        PoolManager poolManager = this.getPoolManager();
        return poolManager.stats(manager).stream().filter(PoolManager.Info::isAcquired).count();
    }

    public void releaseAcquiredAndExpired(PooledResourceManager<R> manager, Date limit, int releaseTimeoutInSeconds) {
        try {
            log.trace("Check expired sessions limit {}", (Object)PoolManagerMaintaince.formatDate(limit));
            int released = 0;
            for (PoolManager.Info info : this.getPoolManager().stats(manager)) {
                log.trace("session uid {} expiredAfter {}", (Object)info.getUid(), (Object)PoolManagerMaintaince.formatDate(info.getExpiredAfter()));
                if (!info.isAcquired() || !info.getExpiredAfter().before(limit)) continue;
                ++released;
                log.trace("Session uid {} - to release", (Object)info.getUid());
                ((PoolManager)Environment.getPublished(PoolManager.class)).release(info.getUid(), manager, (long)releaseTimeoutInSeconds, TimeUnit.SECONDS);
            }
            log.trace("released {} expired sessions", (Object)released);
        }
        catch (Exception e) {
            log.warn("releaseException", (Throwable)e);
            throw Xeption.forDeveloper((String)"releaseException", (Throwable)e, (Object[])new Object[0]);
        }
    }

    public void removeSession(PooledResourceManager<R> manager, R resource, long time, TimeUnit unit) {
        try {
            this.getPoolManager().remove(resource, manager, time, unit);
        }
        catch (Exception e) {
            throw Xeption.forDeveloper((String)"remove session exception", (Throwable)e, (Object[])new Object[0]);
        }
    }

    private static String formatDate(Date date) {
        SimpleDateFormat dateFormatter = new SimpleDateFormat("HH:mm:ss dd.MM");
        return dateFormatter.format(date);
    }

    protected PoolManager getPoolManager() {
        return (PoolManager)Environment.getPublished(PoolManager.class);
    }
}

