/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.pool;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.Publisher;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.pool.LocalPoolManager;
import com.gridnine.xtrip.server.pool.PoolManager;
import com.gridnine.xtrip.server.pool.PoolManagerFactory;

public class PoolManagerPublisher
implements Publisher {
    public void publish() throws Exception {
        PoolManagerFactory factory = PoolManagerPublisher.getPoolManagerFactory();
        if (factory != null && this.publish(factory)) {
            return;
        }
        String className = System.getProperty(PoolManager.class.getName() + ".className");
        PoolManager object = !TextUtil.isBlank((String)className) ? (PoolManager)Class.forName(className).newInstance() : PoolManagerPublisher.getDefault();
        this.publish(object);
    }

    private void publish(PoolManager object) {
        Environment.publish(PoolManager.class, (Object)object);
    }

    public boolean publish(PoolManagerFactory factory) throws Exception {
        PoolManager object = factory.getPoolManager();
        if (null == object) {
            return false;
        }
        this.publish(object);
        return true;
    }

    private static PoolManagerFactory getPoolManagerFactory() throws Exception {
        String className = System.getProperty(PoolManagerFactory.class.getName() + ".className");
        return !TextUtil.isBlank((String)className) ? (PoolManagerFactory)Class.forName(className).newInstance() : null;
    }

    private static PoolManager getDefault() {
        return new LocalPoolManager();
    }
}

